/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.impl;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.dto.strategy.FilterOrderCheckDto;
import com.qiho.center.api.enums.ShotOrder.ShotOrderFieldEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.enums.StrategyUseType;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.Factory.ProcessFaceory;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.engine.impl.BaseOrderEngine;
import com.qiho.center.biz.service.order.StrategyMerchantService;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiFilterRuleHitMapper;
import com.qiho.center.common.entityd.qiho.order.StrategyMerchantEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiFilterRuleHitEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FilterOrderEngine
extends BaseOrderEngine
implements BaseEngine<FilterOrderCheckDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterOrderEngine.class);
    private BaseHandler baseHandler;
    @Autowired
    private StrategyMerchantService strategyMerchantService;
    @Autowired
    private BaiqiFilterRuleHitMapper baiqiFilterRuleHitMapper;

    @Override
    public FilterOrderCheckDto process(FilterOrderCheckDto valuteData) {
        if (null == valuteData || null == valuteData.getOrderSnapshotDto()) {
            return valuteData;
        }
        try {
            List<OrderStrategyDto> orderStrategyDtos = this.getOrderStrategyList(StrategyType.FILTER_ORDER_RULE);
            if (CollectionUtils.isEmpty(orderStrategyDtos)) {
                return valuteData;
            }
            return this.filterRuleCheck(valuteData, orderStrategyDtos);
        }
        catch (Exception e) {
            LOGGER.error("\u8fc7\u6ee4\u89c4\u5219\u5931\u8d25\uff0corderId,{}", (Object)valuteData.getOrderSnapshotDto().getOrderId(), (Object)e);
            return valuteData;
        }
    }

    private FilterOrderCheckDto filterRuleCheck(FilterOrderCheckDto result, List<OrderStrategyDto> orderStrategyDtos) {
        boolean flag = false;
        for (OrderStrategyDto orderStrategyDto : orderStrategyDtos) {
            Boolean match = this.isOrderMatchStrategy(orderStrategyDto, result.getOrderSnapshotDto());
            if (!match.booleanValue()) continue;
            ResultBase<List<StrategyRuleDto>> resultBase = this.validateorderStrategyDto(orderStrategyDto);
            if (!resultBase.hasSuccessValue()) {
                LOGGER.warn("\u8fc7\u6ee4\u89c4\u5219\u89e3\u6790\u9519\u8bef\uff0c\u8fc7\u6ee4\u89c4\u5219\uff1a{}\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)orderStrategyDto, (Object)resultBase.getErrorMsg());
                continue;
            }
            List strategyRuleDtos = (List)resultBase.getValue();
            ResultBase<Boolean> checkResult = this.checkStrategyDetail(orderStrategyDto, strategyRuleDtos, result.getOrderSnapshotDto());
            if (checkResult.getValue() == null || !((Boolean)checkResult.getValue()).booleanValue()) continue;
            flag = true;
            this.saveInsertAnticheate(result.getOrderSnapshotDto().getOrderId(), orderStrategyDto.getStrategyName());
        }
        result.setCheckResult(flag);
        return result;
    }

    private void saveInsertAnticheate(String orderId, String ruleName) {
        BaiqiFilterRuleHitEntity baiqiFilterRuleHitEntity = new BaiqiFilterRuleHitEntity();
        baiqiFilterRuleHitEntity.setOrderId(orderId);
        baiqiFilterRuleHitEntity.setRule(ruleName);
        this.baiqiFilterRuleHitMapper.insert(baiqiFilterRuleHitEntity);
    }

    private ResultBase<Boolean> checkStrategyDetail(OrderStrategyDto orderStrategyDto, List<StrategyRuleDto> strategyRuleDtos, OrderSnapshotDto orderSnapshotDto) {
        Boolean flag = Boolean.TRUE;
        ResultBase<Boolean> checkResult = ResultBase.defaultReturn((Object)false);
        List mobileStrategyList = strategyRuleDtos.stream().filter(e -> ShotOrderFieldEnum.PHONE_STATUS.getVal().equals(e.getFieldName())).collect(Collectors.toList());
        strategyRuleDtos.removeAll(mobileStrategyList);
        if (CollectionUtils.isEmpty(strategyRuleDtos)) {
            checkResult.setValue((Object)false);
            return checkResult;
        }
        for (StrategyRuleDto strategyRuleDto : strategyRuleDtos) {
            ProcessContext processContext = this.createProcessContext(orderSnapshotDto, orderStrategyDto, strategyRuleDto);
            checkResult = this.baseHandler.handleRequest(processContext);
            if (checkResult.hasSuccessValue()) {
                flag = flag != false && (Boolean)checkResult.getValue() != false;
                continue;
            }
            flag = Boolean.FALSE;
            LOGGER.error("\u8fc7\u6ee4\u89c4\u5219\u6821\u9a8c\u5931\u8d25 msg={} strategyName={} ruleName={} fieldName={}", new Object[]{checkResult.getErrorMsg(), orderStrategyDto.getStrategyName(), strategyRuleDto.getRuleName(), strategyRuleDto.getFieldName()});
            break;
        }
        checkResult.setValue((Object)flag);
        return checkResult;
    }

    private ProcessContext createProcessContext(OrderSnapshotDto orderSnapshotDto, OrderStrategyDto orderStrategyDto, StrategyRuleDto strategyRuleDto) {
        if (StrategyUseType.PART.equals((Object)StrategyUseType.findByValue((int)orderStrategyDto.getUseType()))) {
            strategyRuleDto.setPartMerchant(Boolean.valueOf(true));
        } else {
            strategyRuleDto.setPartMerchant(Boolean.valueOf(false));
        }
        return ProcessFaceory.createProcessContext(orderSnapshotDto, strategyRuleDto, orderStrategyDto);
    }

    private boolean isOrderMatchStrategy(OrderStrategyDto orderStrategyDto, OrderSnapshotDto orderSnapshotDto) {
        StrategyUseType useType = StrategyUseType.findByValue((int)orderStrategyDto.getUseType());
        if (StrategyUseType.PART.equals((Object)useType)) {
            Long strategyId;
            Long merchantId = orderSnapshotDto.getMerchantId();
            StrategyMerchantEntity strategyMerchantEntity = this.strategyMerchantService.find(merchantId, strategyId = orderStrategyDto.getId());
            return strategyMerchantEntity != null;
        }
        return true;
    }

    public BaseHandler getBaseHandler() {
        return this.baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }
}

