/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.enums.ordersms.SmsMobileStatusEnum;
import com.qiho.center.biz.engine.impl.ShotOrderEngine;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsCommitMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsCommitEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ChuangLanSmsTimeOutJob
extends AbstractQihoSimpleElasticJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChuangLanSmsTimeOutJob.class);
    @Autowired
    ChuangLanSmsCommitMapper chuangLanSmsCommitMapper;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Resource
    private ShotOrderEngine shotOrderEngine;
    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;
    @Value(value="${qiho.ssjx.sms.status.push}")
    private String pushUrl;
    @Value(value="${qiho.order.ssjx.merchantid}")
    private String ssjxMerchartId;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.info("\u521b\u84dd\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u5904\u7406...");
        List list = this.chuangLanSmsCommitMapper.selectByTime(new DateTime().minusDays(1).toString("yyyy-MM-dd hh:mm:ss"));
        if (list.isEmpty()) {
            return;
        }
        for (ChuangLanSmsCommitEntity chuangLanSmsCommitEntity : list) {
            try {
                BaiqiOrderSmsEntity orderSmsParam = new BaiqiOrderSmsEntity();
                orderSmsParam.setMsgId(chuangLanSmsCommitEntity.getMsgId());
                orderSmsParam.setMobileStatus(Integer.valueOf(SmsMobileStatusEnum.TIME_OUT.getNum()));
                this.baiqiOrderSmsMapper.updateMobileByMsgId(orderSmsParam);
                QihoOrderSnapshotEntity entity = this.qihoOrderSnapshotDAO.findByOrderId(chuangLanSmsCommitEntity.getOrderId());
                if (null == entity) continue;
                OrderSnapshotDto orderSnapshotDto = (OrderSnapshotDto)BeanUtils.copy((Object)entity, OrderSnapshotDto.class);
                orderSnapshotDto.setSmsRetCode("bq999");
                LOGGER.info("\u8d85\u65f6\u5904\u7406\uff0c\u8ba2\u5355\u7f16\u53f7" + entity.getOrderId() + ",\u547d\u4e2d\uff1abq999");
                this.shotOrderEngine.process(orderSnapshotDto);
                chuangLanSmsCommitEntity.setHandlerStatus(Integer.valueOf(1));
                this.chuangLanSmsCommitMapper.updateByPrimaryKey(chuangLanSmsCommitEntity);
                List merchantIds = StringUtil.stringToListOrderByIds((String)this.ssjxMerchartId);
                if (!merchantIds.contains(entity.getMerchantId())) continue;
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("phone", entity.getMobile());
                map.put("msgBacKcode", "TIME_OUT");
                map.put("sendTime", System.currentTimeMillis() + "");
                HttpClientUtil.sendPost((String)this.pushUrl, map);
                LOGGER.info("phone:" + entity.getMobile() + ",msgBacKcode:TIME_OUT");
            }
            catch (Exception e) {
                LOGGER.error("\u521b\u84dd\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38,orderId:{},", (Object)chuangLanSmsCommitEntity.getOrderId(), (Object)e);
            }
        }
        LOGGER.info("\u521b\u84dd\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u7ed3\u675f...");
    }
}

