/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.tuia.core.api.remoteservice.advert.RemoteAdvertStopService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.biz.model.AdvertCloseLog;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemExtDAO;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.daoh.qiho.BusinessLogMapper;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entity.item.QihoItemExtEntity;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.entityd.qiho.BusinessLogEntity;
import com.qiho.center.common.params.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ItemAdvertStopJob
extends AbstractQihoSimpleElasticJob {
    @Resource
    private QihoItemExtDAO qihoItemExtDAO;
    @Resource
    private QihoItemSkuDAO qihoItemSkuDAO;
    @Resource
    private QihoItemDAO qihoItemDAO;
    @Resource
    private RemoteStockService remoteStockService;
    @Resource
    private RemoteAdvertStopService remoteAdvertStopService;
    @Resource
    private BusinessLogMapper businessLogMapper;
    private List<AdvertCloseLog> closeAdList = new ArrayList<AdvertCloseLog>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemAdvertStopJob.class);

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.warn("\u626b\u63cf\u9608\u503c\u5546\u54c1 and \u505c\u6b62\u5bf9\u5e94\u5e7f\u544a\u7684\u5b9a\u65f6\u4efb\u52a1 start");
        StopWatch times = new StopWatch();
        times.start();
        Boolean resultBase = this.stopAdvertAboutItem();
        times.stop();
        LOGGER.warn("\u626b\u63cf\u9608\u503c\u5546\u54c1 and \u505c\u6b62\u5bf9\u5e94\u5e7f\u544a\u7684\u5b9a\u65f6\u4efb\u52a1 end wasteTime={} result={}", (Object)times.getTime(), (Object)resultBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean stopAdvertAboutItem() {
        List qihoIt = this.qihoItemDAO.queryItemByStatus(new QihoItemEntity());
        if (CollectionUtils.isEmpty((Collection)qihoIt)) {
            return Boolean.TRUE;
        }
        List itemIds = qihoIt.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List extEntityList = this.qihoItemExtDAO.queryAllItemExt(itemIds);
        HashMap<Long, KeyPair<String, Long>> itemIdsRule = new HashMap<Long, KeyPair<String, Long>>();
        List thresholdItemIds = extEntityList.stream().filter(this::needStopAdvert).peek(e -> itemIdsRule.put(e.getItemId(), this.itemAboutAdvertRule((QihoItemExtEntity)e))).map(QihoItemExtEntity::getItemId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(thresholdItemIds) || itemIdsRule.isEmpty()) {
            return Boolean.TRUE;
        }
        List skuEntityList = this.qihoItemSkuDAO.getSkuByItemIds(thresholdItemIds);
        HashMap itemIdWithStockIds = Maps.newHashMap();
        List stockIds = skuEntityList.stream().peek(skuEntity -> {
            Long itemId = skuEntity.getItemId();
            ArrayList<Long> stockId = (ArrayList<Long>)itemIdWithStockIds.get(itemId);
            if (CollectionUtils.isEmpty((Collection)stockId)) {
                stockId = new ArrayList<Long>();
                itemIdWithStockIds.put(itemId, stockId);
            }
            stockId.add(skuEntity.getStockId());
        }).map(QihoItemSkuEntity::getStockId).distinct().collect(Collectors.toList());
        try {
            DubboResult dubboResult = this.remoteStockService.findBatchByIds(stockIds);
            if (!dubboResult.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)dubboResult.getResult()))) {
                throw new QihoException("\u6279\u91cf\u67e5\u8be2\u65fa\u5e97\u901a\u5e93\u5b58\u5931\u8d25");
            }
            List stockDtos = (List)dubboResult.getResult();
            Map<Long, Long> stockIdWithNum = stockDtos.stream().collect(Collectors.toMap(StockDto::getStockID, StockDto::getStock));
            Map<Long, Long> itemIdWithAllStock = this.getAllStockAboutItem(itemIdWithStockIds, stockIdWithNum);
            List<Long> advertIds = this.getNeedStopAdvertIds(itemIdWithAllStock, itemIdsRule);
            if (CollectionUtils.isEmpty(advertIds)) {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            for (Long advertId : advertIds) {
                ArrayList list = Lists.newArrayList();
                list.add(advertId);
                DubboResult handlerResult = this.remoteAdvertStopService.batchStopAdvertByList((List)list);
                this.recordBusinessLog((DubboResult<Boolean>)handlerResult, advertId);
            }
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (Exception e2) {
            LOGGER.error("\u5b9a\u65f6\u4efb\u52a1\u626b\u63cf\u5546\u54c1\u9608\u503c\u4efb\u52a1error msg={}", (Throwable)e2);
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            this.closeAdList.clear();
        }
    }

    private void recordBusinessLog(DubboResult<Boolean> handlerResult, Long advertId) {
        Iterator<AdvertCloseLog> it = this.closeAdList.iterator();
        while (it.hasNext()) {
            AdvertCloseLog advertCloseLog = it.next();
            if (!Long.valueOf(advertCloseLog.getAdvertId()).equals(advertId)) continue;
            BusinessLogEntity businessLogEntity = new BusinessLogEntity();
            businessLogEntity.setBusinessType(Integer.valueOf(1));
            businessLogEntity.setBusinessUserId("sys_operate");
            businessLogEntity.setBusinessDesc("\u63a8\u554a\u5173\u95ed\u5e7f\u544a\u64cd\u4f5c\u7684\u65e5\u5fd7");
            if (((Boolean)handlerResult.getResult()).booleanValue()) {
                businessLogEntity.setBusinessResult(Integer.valueOf(0));
            } else {
                businessLogEntity.setBusinessResult(Integer.valueOf(1));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tuia_id", (Object)advertCloseLog.getAdvertId());
            jsonObject.put("threshold", (Object)advertCloseLog.getThreshold());
            jsonObject.put("itemId", (Object)advertCloseLog.getItemId());
            businessLogEntity.setBusinessLog(jsonObject.toJSONString());
            this.businessLogMapper.insert(businessLogEntity);
            it.remove();
        }
    }

    private boolean needStopAdvert(QihoItemExtEntity param) {
        JSONObject metaVal = JSONObject.parseObject((String)param.getExtParam());
        return StringUtils.isNotBlank((CharSequence)metaVal.getString("advertIds")) && StringUtils.isNotBlank((CharSequence)metaVal.getString("threshold"));
    }

    private KeyPair<String, Long> itemAboutAdvertRule(QihoItemExtEntity itemExtEntity) {
        KeyPair keyPair = new KeyPair();
        JSONObject extParam = JSONObject.parseObject((String)itemExtEntity.getExtParam());
        keyPair.setFirstKey((Object)extParam.getString("advertIds"));
        keyPair.setSecondKey((Object)extParam.getLong("threshold"));
        return keyPair;
    }

    private Map<Long, Long> getAllStockAboutItem(Map<Long, List<Long>> itemIdWithStockIds, Map<Long, Long> stockIdWithNum) {
        HashMap itemIdWithAllStock = Maps.newHashMap();
        itemIdWithStockIds.entrySet().stream().forEach(e -> {
            Long itemId = (Long)e.getKey();
            Long allStock = 0L;
            for (Long stockId : (List)e.getValue()) {
                if (null == stockIdWithNum.get(stockId)) continue;
                allStock = allStock + (Long)stockIdWithNum.get(stockId);
            }
            itemIdWithAllStock.put(itemId, allStock);
        });
        return itemIdWithAllStock;
    }

    private List<Long> getNeedStopAdvertIds(Map<Long, Long> itemStockMap, Map<Long, KeyPair<String, Long>> itemIdsRule) {
        if (null == itemIdsRule || null == itemStockMap) {
            return new ArrayList<Long>();
        }
        List advertIdList = itemIdsRule.entrySet().stream().filter(e -> {
            Long itemId = (Long)e.getKey();
            Long stock = (Long)itemStockMap.get(itemId);
            KeyPair rule = (KeyPair)e.getValue();
            Long threshold = (Long)rule.getSecondKey();
            if (threshold >= stock) {
                String[] advertIdStrs;
                String advertIdStr = (String)rule.getFirstKey();
                for (String idStr : advertIdStrs = advertIdStr.split(",")) {
                    AdvertCloseLog log = new AdvertCloseLog();
                    log.setAdvertId(idStr);
                    log.setItemId(itemId);
                    log.setThreshold(threshold);
                    this.closeAdList.add(log);
                }
            }
            return threshold >= stock;
        }).map(this::advertStrToLongList).collect(Collectors.toList());
        ArrayList advertIds = new ArrayList();
        for (List advertId : advertIdList) {
            advertIds.addAll(advertId);
        }
        return advertIds.stream().distinct().collect(Collectors.toList());
    }

    private List<Long> advertStrToLongList(Map.Entry<Long, KeyPair<String, Long>> pairEntry) {
        String advertIdStr = (String)pairEntry.getValue().getFirstKey();
        String[] advertIdStrs = advertIdStr.split(",");
        return Stream.of(advertIdStrs).map(Long::valueOf).collect(Collectors.toList());
    }
}

