/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.biz.service.monitor.MonitorReportService;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.common.dao.QihoConfigDAO;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorReportEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class LogisticsMonitorSmsSendJob
extends AbstractQihoSimpleElasticJob {
    @Resource
    MonitorReportService monitorReportService;
    @Resource
    private SmsService smsService;
    @Resource
    QihoTemplateDAO qihoTemplateDAO;
    @Resource
    QihoConfigDAO qihoConfigDAO;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LogisticsMonitorReportEntity entity = this.monitorReportService.selectMonitorReportForSMS();
        if (null == entity) {
            return;
        }
        QihoTemplateEntity template = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.MONITOR_REPORT.getCode());
        if (null == template || !template.getTemplateEnable().booleanValue()) {
            return;
        }
        HashMap context = Maps.newHashMap();
        context.put("monitorDay", String.valueOf(DateUtils.getDayNumber((Date)DateUtils.daysAddOrSub((Date)new Date(), (int)-1))));
        context.put("totalCount", null == entity.getOrderCountTotal() ? "0" : String.valueOf(entity.getOrderCountTotal()));
        context.put("normalCount", null == entity.getOrderCountNormal() ? "0" : String.valueOf(entity.getOrderCountNormal()));
        context.put("yellowCount", null == entity.getOrderCountYellow() ? "0" : String.valueOf(entity.getOrderCountYellow()));
        context.put("redCount", null == entity.getOrderCountRed() ? "0" : String.valueOf(entity.getOrderCountRed()));
        String mobiles = this.qihoConfigDAO.findByName("monitormobile");
        if (StringUtils.isBlank((String)mobiles)) {
            return;
        }
        List mobileList = Splitter.on((String)",").trimResults().splitToList((CharSequence)mobiles);
        mobileList.stream().forEach(mobile -> this.smsService.singleSend(template, context, (String)mobile));
    }
}

