/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.api.enums.ShotOrder.OrderProcessWayEnum;
import com.qiho.center.api.params.BatchOrderGainParams;
import com.qiho.center.api.params.OrderGainParams;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NoteGainProcessJob
extends AbstractQihoSimpleElasticJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoteGainProcessJob.class);
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.warn("NoteGainProcessJob \u5b9a\u65f6\u67e5\u8be2\u77ed\u4fe1\u635e\u5355   \u542f\u52a8\u6210\u529f");
        OrderGainParams queryParams = new OrderGainParams();
        queryParams.setOrderProcessWayEnum(OrderProcessWayEnum.NOTE_GAIN);
        queryParams.setProcessTime(this.getBeforeOneHour());
        try {
            List orders = this.qihoOrderSnapshotDAO.queryOrderByProcessWayAndTime(queryParams);
            if (CollectionUtils.isEmpty((Collection)orders)) {
                return;
            }
            List orderIds = orders.stream().map(QihoOrderSnapshotEntity::getOrderId).collect(Collectors.toList());
            BatchOrderGainParams updateParams = new BatchOrderGainParams();
            updateParams.setOrderIds(orderIds);
            updateParams.setOrderProcessWayEnum(OrderProcessWayEnum.MANUAL_GAIN);
            this.qihoOrderSnapshotDAO.batchUpdateOrderProcessWay(updateParams);
        }
        catch (Exception e) {
            LOGGER.error("\u5b9a\u65f6\u67e5\u8be2\u5931\u6548\u77ed\u4fe1\u635e\u5355\u8ba2\u5355\u5931\u8d25 msg={}", (Throwable)e);
        }
    }

    private Date getBeforeOneHour() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        return calendar.getTime();
    }
}

