/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.order.DeliveryRecordDto;
import com.qiho.center.api.enums.DeliveryRecordStateEnum;
import com.qiho.center.api.enums.DeliveryRecordTypeEnum;
import com.qiho.center.api.params.OrderFileDeliveryParam;
import com.qiho.center.api.util.BizLog;
import com.qiho.center.api.util.FileDeliveryUtil;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.biz.runnable.OrderFileCancelDeliveryRunnable;
import com.qiho.center.biz.runnable.OrderFileConfirmDeliveryRunnable;
import com.qiho.center.biz.service.OSSFileService;
import com.qiho.center.biz.service.logistics.LogisticsService;
import com.qiho.center.biz.service.order.OrderFileDeliveryService;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.entityd.qiho.order.DeliveryRecordEntity;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class OrderFileDeliveryJob
extends AbstractQihoSimpleElasticJob
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderFileDeliveryJob.class);
    private static final ExecutorService EXECUTOR_ORDER_DELIVERY = new ThreadPoolExecutor(20, 30, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(210));
    private final ConcurrentHashMap<String, Integer> COUNT_MAP_CONFIRM = new ConcurrentHashMap();
    private final ConcurrentHashSet<Integer> FAIL_ID_SET_CONFIRM = new ConcurrentHashSet();
    private volatile boolean PROCESSING_CONFIRM = false;
    private volatile boolean PROCESSING_CANCEL = false;
    private ApplicationContext context;
    @Autowired
    private OSSFileService ossFileService;
    @Resource
    private LogisticsService logisticsService;
    @Resource
    private OrderFileDeliveryService orderFileDeliveryService;
    private String failedCountKey = "FailedCount";
    private String succeedCountKey = "SucceedCount";
    private String updatedCountKey = "UpdatedCount";

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.info("start: \u6279\u91cf\u4e0a\u4f20\u53d1\u7269\u6d41\u5355\u53f7\u6279\u91cf\u53d1\u8d27");
        try {
            this.doStart();
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4e0a\u4f20\u53d1\u7269\u6d41\u5355\u53f7\u6279\u91cf\u53d1\u8d27\u9519\u8bef", (Throwable)e);
        }
        LOGGER.info("end: \u6279\u91cf\u4e0a\u4f20\u53d1\u7269\u6d41\u5355\u53f7\u6279\u91cf\u53d1\u8d27");
    }

    public void doStart() {
        DeliveryRecordDto recordDto = this.orderFileDeliveryService.getJob();
        if (null == recordDto) {
            LOGGER.info("\u6279\u91cf\u4e0a\u4f20\u53d1\u7269\u6d41\u5355\u53f7\uff0c\u6ca1\u6709\u8981\u6267\u884c\u7684\u4efb\u52a1");
            return;
        }
        if (DeliveryRecordTypeEnum.CONFIRM.getCode().equals(recordDto.getRecordType())) {
            this.confirmDeliveryStart(recordDto);
        } else if (DeliveryRecordTypeEnum.CANCEL.getCode().equals(recordDto.getRecordType())) {
            this.cancelDeliveryStart(recordDto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmDeliveryStart(DeliveryRecordDto recordDto) {
        if (this.PROCESSING_CONFIRM) {
            LOGGER.warn("[\u786e\u8ba4\u53d1\u8d27]\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\u4e2d\u3002{}", (Object)recordDto);
            return;
        }
        this.setConfirmRunning();
        InputStream input = null;
        try {
            input = this.ossFileService.getOssFileInputStream(recordDto.getFileUrl());
            if (Objects.equal(null, (Object)input)) {
                BizLog.log((String)"[\u786e\u8ba4\u53d1\u8d27]OSS\u6587\u4ef6\u4e0d\u5b58\u5728\u3002ossUrl:{}", (Object[])new Object[]{recordDto.getFileUrl()});
                this.orderFileDeliveryService.setStateError(recordDto.getId(), "OSS\u6587\u4ef6\u4e0d\u5b58\u5728");
                return;
            }
            List list = FileDeliveryUtil.getExcelContent((DeliveryRecordDto)recordDto, (InputStream)input);
            if (CollectionUtils.isEmpty((Collection)list)) {
                BizLog.log((String)"[\u786e\u8ba4\u53d1\u8d27]Excel\u6587\u4ef6\u5185\u5bb9\u9519\u8bef\u3002ossUrl:{}", (Object[])new Object[]{recordDto.getFileUrl()});
                this.orderFileDeliveryService.setStateError(recordDto.getId(), "Excel\u6587\u4ef6\u5185\u5bb9\u9519\u8bef\u3002");
                return;
            }
            int totalCount = list.size();
            if (10000 < totalCount) {
                BizLog.log((String)"[\u786e\u8ba4\u53d1\u8d27]\u7269\u6d41\u6570\u91cf\u5927\u4e8e1\u4e07\u6761\u3002ossUrl:{}", (Object[])new Object[]{recordDto.getFileUrl()});
                this.orderFileDeliveryService.setStateError(recordDto.getId(), "\u6570\u91cf\u5927\u4e8e1\u4e07\u6761\u3002");
                return;
            }
            if (!this.orderFileDeliveryService.setStateRunning(recordDto.getId(), totalCount).booleanValue()) {
                LOGGER.error("[\u786e\u8ba4\u53d1\u8d27]\u66f4\u65b0\u4efb\u52a1\u4e3a\u5904\u7406\u4e2d\u5931\u8d25\u3002id:{}", (Object)recordDto.getId());
            }
            String logisticsName = this.getLogisticsNameByCode(recordDto.getLogisticsCode());
            List parts = Lists.partition((List)list, (int)100);
            CountDownLatch countDownLatch = new CountDownLatch(parts.size());
            for (List data : parts) {
                this.addConfirmDeliveryJob(countDownLatch, recordDto, logisticsName, data);
            }
            countDownLatch.await();
            BizLog.log((String)"[\u786e\u8ba4\u53d1\u8d27]\u6240\u6709\u5de5\u4f5c\u7ebf\u7a0b\u90fd\u5df2\u5b8c\u6210, id:{}", (Object[])new Object[]{recordDto.getId()});
            DeliveryRecordEntity entity = new DeliveryRecordEntity();
            entity.setId(recordDto.getId());
            entity.setFailedCount(this.COUNT_MAP_CONFIRM.get(this.failedCountKey));
            entity.setSucceedCount(this.COUNT_MAP_CONFIRM.get(this.succeedCountKey));
            entity.setUpdatedCount(this.COUNT_MAP_CONFIRM.get(this.updatedCountKey));
            entity.setRemark(this.getConfirmFailMsg());
            entity.setState(DeliveryRecordStateEnum.COMPLETE.getCode());
            if (!this.orderFileDeliveryService.updateByIdSelective(entity).booleanValue()) {
                LOGGER.error("[\u786e\u8ba4\u53d1\u8d27]\u6279\u91cf\u4e0a\u4f20\u53d1\u7269\u6d41\u5355\u53f7-\u66f4\u65b0\u6570\u636e\u5931\u8d25, id:{}", (Object)entity.getId());
            }
        }
        catch (Exception e) {
            LOGGER.error("[\u786e\u8ba4\u53d1\u8d27]OSS\u6587\u4ef6Input\u9519\u8bef\u3002{}", (Object)recordDto, (Object)e);
            this.orderFileDeliveryService.setStateError(recordDto.getId(), "\u5bfc\u5165\u6587\u4ef6\u9519\u8bef");
        }
        finally {
            this.resetConfirmState();
            this.doStart();
            if (null != input) {
                this.ossFileService.closeInputStream(input);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDeliveryStart(DeliveryRecordDto recordDto) {
        if (this.PROCESSING_CANCEL) {
            LOGGER.warn("[\u53d6\u6d88\u53d1\u8d27]\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\u4e2d\u3002{}", (Object)recordDto);
            return;
        }
        this.setCancelRunning();
        InputStream input = null;
        try {
            input = this.ossFileService.getOssFileInputStream(recordDto.getFileUrl());
            if (Objects.equal(null, (Object)input)) {
                BizLog.log((String)"[\u53d6\u6d88\u53d1\u8d27]OSS\u6587\u4ef6\u4e0d\u5b58\u5728\u3002ossUrl:{}", (Object[])new Object[]{recordDto.getFileUrl()});
                this.orderFileDeliveryService.setStateError(recordDto.getId(), "OSS\u6587\u4ef6\u4e0d\u5b58\u5728");
                return;
            }
            List list = FileDeliveryUtil.getExcelContent((DeliveryRecordDto)recordDto, (InputStream)input);
            if (CollectionUtils.isEmpty((Collection)list)) {
                BizLog.log((String)"[\u53d6\u6d88\u53d1\u8d27]Excel\u6587\u4ef6\u5185\u5bb9\u9519\u8bef\u3002ossUrl:{}", (Object[])new Object[]{recordDto.getFileUrl()});
                this.orderFileDeliveryService.setStateError(recordDto.getId(), "Excel\u6587\u4ef6\u5185\u5bb9\u9519\u8bef");
                return;
            }
            int totalCount = list.size();
            if (10000 < totalCount) {
                BizLog.log((String)"[\u53d6\u6d88\u53d1\u8d27]\u7269\u6d41\u6570\u91cf\u5927\u4e8e1\u4e07\u6761\u3002ossUrl:{}", (Object[])new Object[]{recordDto.getFileUrl()});
                this.orderFileDeliveryService.setStateError(recordDto.getId(), "\u6570\u91cf\u5927\u4e8e1\u4e07\u6761\u3002");
                return;
            }
            if (!this.orderFileDeliveryService.setStateRunning(recordDto.getId(), totalCount).booleanValue()) {
                LOGGER.error("[\u53d6\u6d88\u53d1\u8d27]\u66f4\u65b0\u4efb\u52a1\u4e3a\u5904\u7406\u4e2d\u5931\u8d25\u3002id:{}", (Object)recordDto.getId());
            }
            this.addCancelDeliveryJob(recordDto, list);
        }
        catch (Exception e) {
            LOGGER.error("[\u53d6\u6d88\u53d1\u8d27]OSS\u6587\u4ef6Input\u9519\u8bef\u3002{}", (Object)recordDto, (Object)e);
            this.orderFileDeliveryService.setStateError(recordDto.getId(), "\u5bfc\u5165\u6587\u4ef6\u9519\u8bef");
        }
        finally {
            this.resetCancelState();
            this.doStart();
            if (null != input) {
                this.ossFileService.closeInputStream(input);
            }
        }
    }

    private void addConfirmDeliveryJob(CountDownLatch countDownLatch, DeliveryRecordDto recordDto, String logisticsName, List<OrderFileDeliveryParam> data) {
        OrderFileConfirmDeliveryRunnable runnable = (OrderFileConfirmDeliveryRunnable)this.context.getBean(OrderFileConfirmDeliveryRunnable.class, new Object[]{this, recordDto, logisticsName, countDownLatch, data});
        EXECUTOR_ORDER_DELIVERY.submit(runnable);
    }

    private void addCancelDeliveryJob(DeliveryRecordDto recordDto, List<OrderFileDeliveryParam> data) {
        OrderFileCancelDeliveryRunnable runnable = (OrderFileCancelDeliveryRunnable)this.context.getBean(OrderFileCancelDeliveryRunnable.class, new Object[]{recordDto, data});
        EXECUTOR_ORDER_DELIVERY.submit(runnable);
    }

    public void setConfirmFailedCount(int value) {
        if (this.COUNT_MAP_CONFIRM.containsKey(this.failedCountKey)) {
            this.COUNT_MAP_CONFIRM.put(this.failedCountKey, value + this.COUNT_MAP_CONFIRM.get(this.failedCountKey));
        } else {
            this.COUNT_MAP_CONFIRM.put(this.failedCountKey, value);
        }
    }

    public void setConfirmSucceedCount(int value) {
        if (this.COUNT_MAP_CONFIRM.containsKey(this.succeedCountKey)) {
            this.COUNT_MAP_CONFIRM.put(this.succeedCountKey, value + this.COUNT_MAP_CONFIRM.get(this.succeedCountKey));
        } else {
            this.COUNT_MAP_CONFIRM.put(this.succeedCountKey, value);
        }
    }

    public void setConfirmUpdatedCount(int value) {
        if (this.COUNT_MAP_CONFIRM.containsKey(this.updatedCountKey)) {
            this.COUNT_MAP_CONFIRM.put(this.updatedCountKey, value + this.COUNT_MAP_CONFIRM.get(this.updatedCountKey));
        } else {
            this.COUNT_MAP_CONFIRM.put(this.updatedCountKey, value);
        }
    }

    public void setConfirmFailId(Integer rowNumber) {
        this.FAIL_ID_SET_CONFIRM.add((Object)rowNumber);
    }

    private String getConfirmFailMsg() {
        String failMsg = StringUtils.join((Iterator)this.FAIL_ID_SET_CONFIRM.iterator(), (String)",");
        if (2040 < failMsg.length()) {
            failMsg = failMsg.substring(0, 2040) + "......";
        }
        return failMsg;
    }

    private void setConfirmRunning() {
        this.PROCESSING_CONFIRM = true;
    }

    private void resetConfirmState() {
        this.PROCESSING_CONFIRM = false;
        this.COUNT_MAP_CONFIRM.put(this.failedCountKey, 0);
        this.COUNT_MAP_CONFIRM.put(this.succeedCountKey, 0);
        this.COUNT_MAP_CONFIRM.put(this.updatedCountKey, 0);
        this.FAIL_ID_SET_CONFIRM.clear();
    }

    private void setCancelRunning() {
        this.PROCESSING_CANCEL = true;
    }

    private void resetCancelState() {
        this.PROCESSING_CANCEL = false;
    }

    private String getLogisticsNameByCode(String code) {
        BaiqiLogisticsEntity entity = this.logisticsService.findByCode(code);
        if (null == entity) {
            return "";
        }
        return entity.getLogisticsName();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

