/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.util.DingTalkUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OrderLogisticsMonitorJob
extends AbstractQihoSimpleElasticJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderLogisticsMonitorJob.class);
    @Autowired
    private QihoMerchantDAO qihoMerchantDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Value(value="${dingtalk.logistics.url}")
    private String dingUrl;
    private static final Integer FIVE_DAY = -5;
    private static final Integer FIVE_PERCENT = 5;
    private static final Integer TWO_DAY = -2;
    private static final Integer TEN_PERCENT = 10;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.info("\u8ba2\u5355\u7269\u6d41\u76d1\u63a7\u63d0\u9192\uff0c\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u3002\u3002\u3002");
        List merchantsList = this.qihoMerchantDAO.findAllIdAndNames();
        if (CollectionUtils.isEmpty((Collection)merchantsList)) {
            return;
        }
        List<String> alertMsgList = this.buildMsgList(merchantsList);
        if (CollectionUtils.isNotEmpty(alertMsgList)) {
            this.sendDingTalkMsg(alertMsgList);
        }
        LOGGER.info("\u8ba2\u5355\u7269\u6d41\u76d1\u63a7\u63d0\u9192\uff0c\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u3002\u3002\u3002");
    }

    private void sendDingTalkMsg(List<String> alertMsgList) {
        StringBuilder msg = new StringBuilder();
        msg.append("\u4ea7\u751f\u4e00\u6761\u65b0\u7684\u8ba2\u5355\u76d1\u63a7\u9884\u8b66\uff01\uff01\u9884\u8b66\u5185\u5bb9\u5982\u4e0b\uff1a\n").append("\u65e5\u671f\uff1a").append(OrderLogisticsMonitorJob.getDay(LocalDate.now().toDate())).append("\n").append(StringUtils.join(alertMsgList, (String)""));
        DingTalkUtil.sendTextMessageWith((String)String.valueOf(msg), (String)this.dingUrl, (boolean)true);
    }

    private List<String> buildMsgList(List<MerchantSimpleDto> merchantsList) {
        ArrayList alertMsgList = Lists.newArrayListWithExpectedSize((int)merchantsList.size());
        merchantsList.forEach(merchant -> {
            int fiveDayPercent;
            StringBuilder content = new StringBuilder();
            content.append("\u5546\u5bb6id: ").append(merchant.getId()).append(", \u5546\u5bb6\u540d\u79f0: ").append(merchant.getMerchantName()).append(", ");
            boolean needAlert = false;
            int twoDayPercent = this.searchPercent((MerchantSimpleDto)merchant, TWO_DAY);
            if (twoDayPercent > TEN_PERCENT) {
                needAlert = true;
                String date = OrderLogisticsMonitorJob.getDay(OrderLogisticsMonitorJob.getStartTime(TWO_DAY));
                content.append(date).append("\u672a\u5904\u7406\u8ba2\u5355").append(twoDayPercent).append("% ");
            }
            if ((fiveDayPercent = this.searchPercent((MerchantSimpleDto)merchant, FIVE_DAY)) > FIVE_PERCENT) {
                needAlert = true;
                String date = OrderLogisticsMonitorJob.getDay(OrderLogisticsMonitorJob.getStartTime(FIVE_DAY));
                content.append(date).append("\u672a\u5904\u7406\u8ba2\u5355").append(fiveDayPercent).append("% ");
            }
            if (needAlert) {
                alertMsgList.add(content.append("\n").toString());
            }
        });
        return alertMsgList;
    }

    private static Date getStartTime(int day) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    private static String getDay(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("MM\u6708dd\u65e5").format(date);
    }

    private int searchPercent(MerchantSimpleDto merchant, int day) {
        Long merchantId = merchant.getId();
        Date startDay = OrderLogisticsMonitorJob.getStartTime(day);
        Date endDay = OrderLogisticsMonitorJob.getStartTime(day + 1);
        int dayCountAll = this.qihoOrderSnapshotDAO.countByMerchantIdAndOrderStatusAndTime(merchantId, "", startDay, endDay);
        int dayCountAPPROVE = this.qihoOrderSnapshotDAO.countByMerchantIdAndOrderStatusAndTime(merchantId, "TO_APPROVE", startDay, endDay);
        int dayCountSend = this.qihoOrderSnapshotDAO.countByMerchantIdAndOrderStatusAndTime(merchantId, "TO_SEND", startDay, endDay);
        int execPercent = dayCountAll == 0 ? 0 : (dayCountAPPROVE + dayCountSend) * 100 / dayCountAll;
        return execPercent;
    }
}

