/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.biz.bo.EdbItemStockBo;
import com.qiho.center.biz.bo.SyncStockBo;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.biz.service.ConfigService;
import com.qiho.center.common.util.AppLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StockSyncJob
extends AbstractQihoSimpleElasticJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(StockSyncJob.class);
    @Autowired
    private SyncStockBo syncStockBo;
    @Autowired
    private EdbItemStockBo edbItemStockBo;
    @Autowired
    private ConfigService configService;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        AppLogUtil.info((Logger)LOGGER, (String)"\u5e93\u5b58\u540c\u6b65\u5f00\u59cb....");
        long startTime = System.currentTimeMillis();
        ErpManufacturerType erpType = this.configService.findErpSwitchesType();
        if (erpType == ErpManufacturerType.EDB) {
            this.edbItemStockBo.syncEdbStock();
        } else {
            this.syncStockBo.syncStock();
        }
        long endTime = System.currentTimeMillis();
        AppLogUtil.info((Logger)LOGGER, (String)"\u540c\u6b65\u7ed3\u675f...\u672c\u6b21\u540c\u6b65\u8017\u65f6{}", (Object[])new Object[]{endTime - startTime});
    }
}

