/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import cn.com.duiba.tuia.core.api.dto.rsp.baiqi.BaiQiAdvertDetailDto;
import cn.com.duiba.tuia.core.api.remoteservice.baiqi.RemoteBaiQiService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.finance.CashRebateAmountEnum;
import com.qiho.center.api.enums.finance.FinanceDetailStatusEnum;
import com.qiho.center.api.enums.finance.FinanceOptTypeEnum;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.enums.finance.ParterTypeEnum;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.biz.bo.MerchantAdvertBO;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.biz.service.advert.BaiqiTuiaAdvertConsumeService;
import com.qiho.center.biz.service.advert.BaiqiTuiaPlanService;
import com.qiho.center.biz.service.finance.FinanceService;
import com.qiho.center.biz.service.impl.finance.bean.CashRebateAmountBean;
import com.qiho.center.biz.service.merchant.BaiqiMerchantLinkService;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceDetailMapper;
import com.qiho.center.common.entityd.qiho.advert.BaiqiTuiaAdvertConsumeEntity;
import com.qiho.center.common.entityd.qiho.advert.BaiqiTuiaPlanEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceDetailEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import com.qiho.center.common.entityd.qiho.merchant.BaiqiMerchantLinkEntity;
import com.qiho.center.common.util.BaiqiSerialUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class TuiaAdvertConsumeJob
extends AbstractQihoSimpleElasticJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TuiaAdvertConsumeJob.class);
    @Resource
    private MerchantAdvertBO merchantAdvertBO;
    @Resource
    private BaiqiTuiaAdvertConsumeService tuiaAdvertConsumeService;
    @Resource
    private BaiqiMerchantLinkService merchantLinkService;
    @Resource
    private BaiqiFinanceDetailMapper financeDetailMapper;
    @Resource
    private FinanceService financeService;
    @Resource
    private RemoteBaiQiService remoteBaiQiService;
    @Resource
    private BaiqiTuiaPlanService tuiaPlanService;
    private Boolean isArchive = false;

    public void setArchive(Boolean archive) {
        this.isArchive = archive;
    }

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.info("fetch tuia advert consume start...");
        this.doStart(LocalDate.now(), LocalDate.now());
        LOGGER.info("fetch tuia advert consume end...");
    }

    public void doStart(LocalDate start, LocalDate end) {
        List<BaiqiTuiaAdvertConsumeEntity> consumeList = this.fetchConsumeList(start, end);
        if (CollectionUtils.isEmpty(consumeList)) {
            return;
        }
        this.saveConsumeList(consumeList);
        this.affectMerchantFinance(consumeList);
    }

    private void affectMerchantFinance(List<BaiqiTuiaAdvertConsumeEntity> consumeList) {
        Map<Long, List<BaiqiTuiaAdvertConsumeEntity>> advertConsumeListMap = consumeList.stream().collect(Collectors.groupingBy(BaiqiTuiaAdvertConsumeEntity::getAdvertId));
        advertConsumeListMap.forEach(this::executeAdvertConsume);
    }

    private void executeAdvertConsume(Long advertId, List<BaiqiTuiaAdvertConsumeEntity> eachConsumeList) {
        Long merchantId = this.findMerchantId(advertId);
        if (merchantId == null) {
            return;
        }
        Long financeId = this.findFinanceId(merchantId);
        if (financeId == null) {
            return;
        }
        Long totalConsume = eachConsumeList.stream().mapToLong(BaiqiTuiaAdvertConsumeEntity::getConsumeTotal).sum();
        Date date = LocalDate.now().toDate();
        if (this.isArchive.booleanValue()) {
            date = LocalDate.now().minusDays(1).toDate();
        }
        String serialNo = BaiqiSerialUtil.getAdCostSerialNo((FinanceOptTypeEnum)FinanceOptTypeEnum.AD_COST, (FinanceTypeEnum)FinanceTypeEnum.MAIN_ACCOUNT, (long)merchantId, (Date)date);
        BaiqiFinanceDetailEntity detailEntity = this.financeDetailMapper.selectBySerialNo(serialNo);
        HashMap mapBean = Maps.newHashMap();
        BaiqiFinanceDetailEntity resultEntity = this.processDetail(advertId, merchantId, financeId, totalConsume, detailEntity, mapBean);
        resultEntity.setSerialNo(serialNo);
        this.merchantAdvertBO.saveDetailAndReduceAmount(financeId, resultEntity, (CashRebateAmountBean)mapBean.get(merchantId));
    }

    private BaiqiFinanceDetailEntity processDetail(Long advertId, Long merchantId, Long financeId, Long totalConsume, BaiqiFinanceDetailEntity detailEntity, Map<Long, CashRebateAmountBean> mapBean) {
        BaiqiFinanceDetailEntity detailEntityTemp = detailEntity;
        if (detailEntityTemp != null) {
            this.handleFinanceDetailNotNull(advertId, merchantId, financeId, totalConsume, detailEntityTemp, mapBean);
        } else {
            detailEntityTemp = this.handleNotFinanceDetail(merchantId, financeId, totalConsume, mapBean);
        }
        detailEntityTemp.setOperator(Long.valueOf(0L));
        detailEntityTemp.setOperatorType(FinanceOptTypeEnum.AD_COST.getNum());
        detailEntityTemp.setState(this.isArchive != false ? FinanceDetailStatusEnum.SUCCESS.getNum() : FinanceDetailStatusEnum.PROCESSING.getNum());
        detailEntityTemp.setPartnerType(ParterTypeEnum.TUIA.getCode());
        return detailEntityTemp;
    }

    private BaiqiFinanceDetailEntity handleNotFinanceDetail(Long merchantId, Long financeId, Long totalConsume, Map<Long, CashRebateAmountBean> mapBean) {
        BaiqiFinanceDetailEntity detailEntity = new BaiqiFinanceDetailEntity();
        detailEntity.setFinanceId(financeId);
        detailEntity.setRelationType(Integer.valueOf(FinanceTypeEnum.MAIN_ACCOUNT.getCode()));
        detailEntity.setRelationId(merchantId);
        detailEntity.setExpenditureTotal(totalConsume);
        CashRebateAmountBean amountBean = this.financeService.calcCashAndRebateAmount(financeId, totalConsume, CashRebateAmountEnum.EXPENDITURE);
        if (amountBean != null) {
            detailEntity.setExpenditureTotal(totalConsume);
            detailEntity.setExpenditureCash(amountBean.getCashAmount());
            detailEntity.setExpenditureRebate(amountBean.getRebateAmount());
            mapBean.put(merchantId, amountBean);
        }
        return detailEntity;
    }

    private void handleFinanceDetailNotNull(Long advertId, Long merchantId, Long financeId, Long totalConsume, BaiqiFinanceDetailEntity detailEntity, Map<Long, CashRebateAmountBean> mapBean) {
        Long lastTotalConsume = detailEntity.getExpenditureTotal();
        Long rest = totalConsume - lastTotalConsume;
        if (rest == 0L) {
            return;
        }
        if (rest < 0L && !this.isArchive.booleanValue()) {
            LOGGER.error("\u672c\u6b21\u603b\u6d88\u8017\u5c0f\u4e8e\u4e0a\u6b21\u603b\u6d88\u8017\uff0c\u5e7f\u544a\u4e3b[{}], \u5546\u5bb6[{}]", (Object)advertId, (Object)merchantId);
            return;
        }
        CashRebateAmountEnum amountEnum = rest > 0L ? CashRebateAmountEnum.EXPENDITURE : CashRebateAmountEnum.INCOME;
        CashRebateAmountBean amountBean = this.financeService.calcCashAndRebateAmount(financeId, rest, amountEnum);
        if (amountBean != null) {
            Long originTotal = detailEntity.getExpenditureTotal();
            if (CashRebateAmountEnum.INCOME.equals((Object)amountEnum)) {
                detailEntity.setExpenditureTotal(Long.valueOf(originTotal - amountBean.getTotalAmount()));
                detailEntity.setExpenditureCash(Long.valueOf(detailEntity.getExpenditureCash() - amountBean.getCashAmount()));
                detailEntity.setExpenditureRebate(Long.valueOf(detailEntity.getExpenditureRebate() - amountBean.getRebateAmount()));
                this.handleException(detailEntity);
            }
            if (CashRebateAmountEnum.EXPENDITURE.equals((Object)amountEnum)) {
                detailEntity.setExpenditureTotal(Long.valueOf(originTotal + amountBean.getTotalAmount()));
                detailEntity.setExpenditureCash(Long.valueOf(detailEntity.getExpenditureCash() + amountBean.getCashAmount()));
                detailEntity.setExpenditureRebate(Long.valueOf(detailEntity.getExpenditureRebate() + amountBean.getRebateAmount()));
            }
            if (this.isArchive.booleanValue()) {
                StringBuilder remarkStr = new StringBuilder("\u9884\u8ba1\u6263\u6b3e: ");
                remarkStr.append(new BigDecimal(originTotal).movePointLeft(2)).append(" \u5143, \u5f52\u6863\u6263\u6b3e: ").append(new BigDecimal(detailEntity.getExpenditureTotal()).movePointLeft(2)).append(" \u5143");
                detailEntity.setRemark(remarkStr.toString());
            }
            mapBean.put(merchantId, amountBean);
        }
    }

    private void handleException(BaiqiFinanceDetailEntity detailEntity) {
        Long cash = detailEntity.getExpenditureCash();
        Long rebate = detailEntity.getExpenditureRebate();
        if (cash < 0L) {
            detailEntity.setExpenditureCash(Long.valueOf(0L));
            detailEntity.setExpenditureRebate(Long.valueOf(rebate - Math.abs(cash)));
        }
        if (rebate < 0L) {
            detailEntity.setExpenditureRebate(Long.valueOf(0L));
            detailEntity.setExpenditureCash(Long.valueOf(cash - Math.abs(rebate)));
        }
    }

    private Long findFinanceId(Long merchantId) {
        BaiqiFinanceEntity financeEntity = this.financeService.findByRelation(FinanceTypeEnum.MAIN_ACCOUNT, merchantId);
        return financeEntity != null ? financeEntity.getId() : null;
    }

    private Long findMerchantId(Long advertId) {
        BaiqiMerchantLinkEntity linkEntity = this.merchantLinkService.findByRelation(BaiqiMerchantLinkTypeEnum.TUI_A.getType(), advertId);
        return linkEntity != null ? linkEntity.getMerchantId() : null;
    }

    private List<BaiqiTuiaAdvertConsumeEntity> fetchConsumeList(LocalDate start, LocalDate end) {
        List detailDtoList;
        String startDate = start == null ? LocalDate.now().toString() : start.toString();
        String endDate = end == null ? LocalDate.now().toString() : end.toString();
        try {
            detailDtoList = this.remoteBaiQiService.findBaiQiDetail(startDate, endDate);
        }
        catch (Exception e2) {
            LOGGER.error("find tuia advert detail failed", (Throwable)e2);
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailDtoList)) {
            detailDtoList.forEach(e -> this.dto2Entity((BaiQiAdvertDetailDto)e, result));
        }
        return result;
    }

    private void dto2Entity(BaiQiAdvertDetailDto e, List<BaiqiTuiaAdvertConsumeEntity> result) {
        BaiqiTuiaAdvertConsumeEntity entity = (BaiqiTuiaAdvertConsumeEntity)BeanUtils.copy((Object)e, BaiqiTuiaAdvertConsumeEntity.class);
        entity.setState(e.getStatus());
        entity.setBelongDate(this.isArchive != false ? LocalDate.now().toDate() : LocalDate.now().minusDays(1).toDate());
        entity.setBudgetPerday(Long.valueOf(e.getBudgetPerDay() == null ? 0L : e.getBudgetPerDay()));
        entity.setConsumeTotal(Long.valueOf(e.getConsumeTotal() == null ? 0L : e.getConsumeTotal()));
        entity.setExposureCount(Long.valueOf(e.getExposureCount() == null ? 0L : e.getExposureCount()));
        entity.setClickCount(Long.valueOf(e.getClickCount() == null ? 0L : e.getClickCount()));
        result.add(entity);
    }

    private void saveConsumeList(List<BaiqiTuiaAdvertConsumeEntity> consumeList) {
        this.saveAdvert(consumeList);
        this.savePlan(consumeList);
        this.saveConsume(consumeList);
    }

    private void savePlan(List<BaiqiTuiaAdvertConsumeEntity> consumeList) {
        List<BaiqiTuiaPlanEntity> insertList = this.transferPlan(consumeList);
        this.tuiaPlanService.batchInsert(insertList);
    }

    private List<BaiqiTuiaPlanEntity> transferPlan(List<BaiqiTuiaAdvertConsumeEntity> consumeList) {
        return BeanUtils.copyList(consumeList, BaiqiTuiaPlanEntity.class);
    }

    private void saveAdvert(List<BaiqiTuiaAdvertConsumeEntity> consumeList) {
        Map advertIdAndNameMap = consumeList.stream().collect(Collectors.toMap(BaiqiTuiaAdvertConsumeEntity::getAdvertId, BaiqiTuiaAdvertConsumeEntity::getAdvertName, (oldValue, newValue) -> newValue, HashMap::new));
        ArrayList saveEntityList = Lists.newArrayListWithExpectedSize((int)advertIdAndNameMap.size());
        advertIdAndNameMap.forEach((advertId, advertName) -> {
            BaiqiMerchantLinkEntity linkEntity = new BaiqiMerchantLinkEntity();
            linkEntity.setRelationId(advertId);
            linkEntity.setRelationName(advertName);
            linkEntity.setRelationType(Integer.valueOf(BaiqiMerchantLinkTypeEnum.TUI_A.getType()));
            saveEntityList.add(linkEntity);
        });
        if (CollectionUtils.isNotEmpty((Collection)saveEntityList)) {
            this.merchantLinkService.batchInsertTuiaLink(saveEntityList);
        }
    }

    private void saveConsume(List<BaiqiTuiaAdvertConsumeEntity> consumeList) {
        Date today = this.isArchive != false ? LocalDate.now().minusDays(1).toDate() : LocalDate.now().toDate();
        consumeList.forEach(e -> {
            e.setBelongDate(today);
            this.tuiaAdvertConsumeService.insert((BaiqiTuiaAdvertConsumeEntity)e);
        });
    }
}

