/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.paychannel.pay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayFundTransToaccountTransferModel;
import com.alipay.api.domain.AlipayTradeFastpayRefundQueryModel;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.request.AlipayTradeFastpayRefundQueryRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.PayDto;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.center.api.util.AliPayAppUtil;
import com.qiho.center.biz.model.RefundResult;
import com.qiho.center.biz.paychannel.pay.PayChannelDecider;
import com.qiho.center.biz.paychannel.pay.PayChannelProcessor;
import com.qiho.center.common.params.AliPayParam;
import com.qiho.center.common.util.AppLogUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AlipayProcessor
extends PayChannelProcessor
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(AlipayProcessor.class);
    @Value(value="${alipay.serverUrl}")
    private String serverUrl;
    @Value(value="${alipay.appId}")
    private String appId;
    @Value(value="${alipay.privateKey}")
    private String privateKey;
    @Value(value="${alipay.publicKey}")
    private String alipayPulicKey;
    private static final String CHARSET = "UTF-8";
    private static final String SIGN_TYPE = "RSA";
    private static final String FORMAT = "json";
    private static final String PRODUCT_CODE = "QUICK_WAP_PAY";
    private static final String ACCOUNT_REGEX = "^2088\\d{12}$";
    @Autowired
    private AliPayParam aliPayParam;
    @Autowired
    private RemoteOrderService remoteOrderService;
    private AlipayClient alipayClient;

    @Override
    public String payExecute(String orderId, Map<String, String> params) {
        OrderDto dto = (OrderDto)this.remoteOrderService.findByOrderId(orderId).getResult();
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(dto.getOrderId());
        model.setSubject(dto.getOrderItem().getItemName());
        model.setTotalAmount(AliPayAppUtil.fenToYuan((Integer)dto.getOrderAmt()));
        model.setBody(dto.getOrderItem().getSkuName() + "*" + dto.getOrderItem().getQuantity());
        model.setProductCode(PRODUCT_CODE);
        alipayRequest.setReturnUrl(this.aliPayParam.getReturnUrl() + "?orderId=" + orderId);
        alipayRequest.setNotifyUrl(this.aliPayParam.getNotifyUrl());
        alipayRequest.setBizModel((AlipayObject)model);
        String form = "";
        try {
            AlipayTradeWapPayResponse response = (AlipayTradeWapPayResponse)this.alipayClient.pageExecute((AlipayRequest)alipayRequest);
            if (response.isSuccess()) {
                form = response.getBody();
                this.updateFundOrder(orderId, response);
            }
        }
        catch (AlipayApiException e) {
            AppLogUtil.error((Logger)LOG, (String)"\u652f\u4ed8\u5b9d\u53d1\u8d77\u4ed8\u6b3e\u5931\u8d25", (Object[])new Object[]{e});
        }
        return form;
    }

    private void updateFundOrder(String orderId, AlipayTradeWapPayResponse response) {
        List<FundOrderDto> list = this.fundOrderService.findByOrderIdAndBizType(orderId, FundBizTypeEnum.PAY.getCode());
        if (CollectionUtils.isNotEmpty(list)) {
            FundOrderDto fundOrder = list.get(0);
            fundOrder.setOutSeqNo(response.getTradeNo());
            this.fundOrderService.update(fundOrder);
        }
    }

    @Override
    public PayDto queryPayResult(String orderId) {
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(orderId);
        request.setBizModel((AlipayObject)model);
        PayDto result = new PayDto();
        result.setOrderId(orderId);
        try {
            AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)this.alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                result.setPayerId(response.getBuyerUserId());
                result.setPayAmt(AliPayAppUtil.yuanToFen((String)response.getTotalAmount()));
                result.setOutTradeNo(response.getTradeNo());
                result.setSuccess(StringUtils.containsAny((CharSequence)response.getTradeStatus(), (CharSequence[])new CharSequence[]{"TRADE_SUCCESS", "TRADE_FINISHED"}));
            } else {
                AppLogUtil.warn((Logger)LOG, (String)response.getSubMsg());
            }
        }
        catch (AlipayApiException e) {
            AppLogUtil.error((Logger)LOG, (String)"\u67e5\u8be2\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7ed3\u679c\u5931\u8d25", (Object[])new Object[]{e});
        }
        return result;
    }

    @Override
    public void refund(String orderId, String fundId, Integer refundAmt) {
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        FundOrderDto dto = this.fundOrderService.findByFundId(fundId);
        model.setOutTradeNo(orderId);
        model.setRefundAmount(AliPayAppUtil.fenToYuan((Integer)refundAmt));
        model.setOutRequestNo(fundId);
        request.setBizModel((AlipayObject)model);
        try {
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)this.alipayClient.execute((AlipayRequest)request);
            String code = response.getCode();
            if (response.isSuccess()) {
                dto.setFundStatus(FundStatusEnum.SUCCESS.getCode());
            } else if (!"10000".equals(code)) {
                dto.setFundStatus(FundStatusEnum.FAILED.getCode());
                AppLogUtil.warn((Logger)LOG, (String)"\u8ba2\u5355\u3010orderId={}\u3011\u8bf7\u6c42\u9000\u6b3e\u5931\u8d25 msg={}", (Object[])new Object[]{orderId, response.getSubMsg()});
            }
            dto.setAccount(response.getBuyerUserId());
            dto.setOutSeqNo(response.getTradeNo());
            this.fundOrderService.update(dto);
        }
        catch (AlipayApiException e) {
            AppLogUtil.error((Logger)LOG, (String)"\u8ba2\u5355\u3010orderId={}\u3011\u8bf7\u6c42\u9000\u6b3e\u5f02\u5e38", (Object[])new Object[]{orderId, e});
        }
    }

    @Override
    public RefundResult refundQuery(String orderId, String fundId) {
        AlipayTradeFastpayRefundQueryRequest request = new AlipayTradeFastpayRefundQueryRequest();
        AlipayTradeFastpayRefundQueryModel model = new AlipayTradeFastpayRefundQueryModel();
        FundOrderDto dto = this.fundOrderService.findByFundId(fundId);
        model.setOutTradeNo(orderId);
        model.setOutRequestNo(fundId);
        request.setBizModel((AlipayObject)model);
        RefundResult result = new RefundResult();
        result.setFundId(fundId);
        result.setOrderId(orderId);
        try {
            AlipayTradeFastpayRefundQueryResponse response = (AlipayTradeFastpayRefundQueryResponse)this.alipayClient.execute((AlipayRequest)request);
            result.setRefundAmt(AliPayAppUtil.yuanToFen((String)response.getRefundAmount()));
            if (response.isSuccess() && StringUtils.equals((CharSequence)response.getRefundAmount(), (CharSequence)AliPayAppUtil.fenToYuan((Integer)dto.getAmt()))) {
                result.setIsSuccess(true);
                result.setRefundStatus("success");
                result.setOutTradeNo(response.getTradeNo());
            } else {
                result.setIsSuccess(false);
                AppLogUtil.warn((Logger)LOG, (String)"\u652f\u4ed8\u5b9d\u67e5\u8be2\u9000\u6b3e\u5931\u8d25msg={}", (Object[])new Object[]{response.getSubMsg()});
            }
        }
        catch (AlipayApiException e) {
            AppLogUtil.error((Logger)LOG, (String)"\u652f\u4ed8\u5b9d\u67e5\u8be2\u9000\u6b3e\u5f02\u5e38,fundId={}", (Object[])new Object[]{fundId, e});
        }
        return result;
    }

    @Override
    PayTypeEnum getPayType() {
        return PayTypeEnum.ALIPAY;
    }

    public void afterPropertiesSet() throws Exception {
        PayChannelDecider.registPaychannel(this.getPayType(), this);
        this.alipayClient = new DefaultAlipayClient(this.serverUrl, this.appId, this.privateKey, FORMAT, CHARSET, this.alipayPulicKey, SIGN_TYPE);
    }

    @Override
    public boolean verify(Map<String, String> params) {
        boolean verifyResult = false;
        try {
            verifyResult = AlipaySignature.rsaCheckV1(params, (String)this.alipayPulicKey, (String)CHARSET, (String)SIGN_TYPE);
        }
        catch (AlipayApiException e) {
            AppLogUtil.warn((Logger)LOG, (String)"\u652f\u4ed8\u5b9d\u9a8c\u7b7e\u5931\u8d25\uff0cparams={}", (Object[])new Object[]{params, e});
        }
        return verifyResult;
    }

    @Override
    public String getOpenIdByCode(String code) {
        return null;
    }

    @Override
    public void transAccount(String account, String fundId, Integer amount) {
        if (amount < 10) {
            throw new QihoException("\u652f\u4ed8\u5b9d\u5355\u7b14\u8f6c\u8d26\u91d1\u989d\u81f3\u5c110.1\u5143");
        }
        FundOrderDto dto = this.fundOrderService.findByFundId(fundId);
        if (dto == null) {
            throw new QihoException("\u8d44\u91d1\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        AlipayFundTransToaccountTransferRequest request = new AlipayFundTransToaccountTransferRequest();
        AlipayFundTransToaccountTransferModel model = new AlipayFundTransToaccountTransferModel();
        model.setAmount(AliPayAppUtil.fenToYuan((Integer)amount));
        model.setOutBizNo(fundId);
        model.setPayeeAccount(account);
        if (account.matches(ACCOUNT_REGEX)) {
            model.setPayeeType("ALIPAY_USERID");
        } else {
            model.setPayeeType("ALIPAY_LOGONID");
        }
        request.setBizModel((AlipayObject)model);
        try {
            AlipayFundTransToaccountTransferResponse response = (AlipayFundTransToaccountTransferResponse)this.alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                dto.setOutSeqNo(response.getOrderId());
                dto.setFundStatus(FundStatusEnum.SUCCESS.getCode());
            } else {
                dto.setFundStatus(FundStatusEnum.FAILED.getCode());
                AppLogUtil.warn((Logger)LOG, (String)"\u652f\u4ed8\u5b9d\u8f6c\u8d26\u5931\u8d25\uff0cfundId={} ", (Object[])new Object[]{fundId, response.getSubMsg()});
            }
            this.fundOrderService.update(dto);
        }
        catch (AlipayApiException e) {
            AppLogUtil.warn((Logger)LOG, (String)"\u652f\u4ed8\u5b9d\u8f6c\u8d26\u5f02\u5e38\uff0cfundId={}", (Object[])new Object[]{fundId, e});
        }
    }
}

