/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.paychannel.pay;

import com.google.common.collect.Maps;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.PayDto;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.util.StringRandUtil;
import com.qiho.center.api.util.WechatPayAppUtil;
import com.qiho.center.api.util.XmlTranformUtil;
import com.qiho.center.biz.model.RefundResult;
import com.qiho.center.biz.paychannel.pay.PayChannelDecider;
import com.qiho.center.biz.paychannel.pay.WechatPayBaseProcessor;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class WeChatPayProcessor
extends WechatPayBaseProcessor
implements InitializingBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String suffix = "w";

    public void afterPropertiesSet() throws Exception {
        PayChannelDecider.registPaychannel(this.getPayType(), this);
    }

    @Override
    public String payExecute(String orderId, Map<String, String> params) {
        try {
            Map<String, String> data = this.buildPayParams(orderId, params);
            String parmaStr = XmlTranformUtil.mapToXml(data);
            String httpResultStr = HttpClientUtil.postData((String)"https://api.mch.weixin.qq.com/pay/unifiedorder", (String)parmaStr);
            Map resultMap = XmlTranformUtil.xmlToMap((String)httpResultStr);
            if ("SUCCESS".equals(resultMap.get("return_code"))) {
                if ("SUCCESS".equals(resultMap.get("result_code"))) {
                    return (String)resultMap.get("mweb_url");
                }
                AppLogUtil.error((Logger)this.logger, (String)"\u5fae\u4fe1\u652f\u4ed8\u53d1\u8d77\u5931\u8d25,\u652f\u4ed8\u62a5\u6587\u8bf7\u6c42\u62a5\u6587={},\u8fd4\u56de\u62a5\u6587={}", (Object[])new Object[]{parmaStr, httpResultStr});
            } else {
                AppLogUtil.error((Logger)this.logger, (String)"\u5fae\u4fe1\u652f\u4ed8\u53d1\u8d77\u5931\u8d25,\u652f\u4ed8\u62a5\u6587\u8bf7\u6c42\u62a5\u6587={},\u8fd4\u56de\u62a5\u6587={}", (Object[])new Object[]{parmaStr, httpResultStr});
            }
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u5524\u8d77\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38,orderId = {}", (Object[])new Object[]{orderId, e});
        }
        return "";
    }

    private Map<String, String> buildPayParams(String orderId, Map<String, String> params) {
        OrderDto orderDto = this.orderService.findByOrderId(orderId);
        if (null == orderDto) {
            throw new QihoException("\u65e0\u6548\u7684\u8ba2\u5355ID");
        }
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("appid", WechatPayAppUtil.getAppId());
        dataMap.put("mch_id", WechatPayAppUtil.getMchId());
        dataMap.put("nonce_str", StringRandUtil.getRandomString((int)32));
        dataMap.put("body", "\u5947\u8d27\u2014" + StringUtils.trim((String)orderDto.getOrderItem().getItemName()));
        dataMap.put("out_trade_no", orderId + suffix);
        dataMap.put("total_fee", orderDto.getOrderAmt().toString());
        dataMap.put("spbill_create_ip", params.get("ip"));
        dataMap.put("notify_url", WechatPayAppUtil.getNotifyUrl());
        dataMap.put("trade_type", "MWEB");
        dataMap.put("scene_info", "{\"h5_info\": {\"type\":\"Wap\",\"wap_url\": \"http://www.7ho.com/\",\"wap_name\": \"\u5947\u8d27\"}}");
        dataMap.put("sign", this.sign(dataMap, WechatPayAppUtil.getSecret()));
        return dataMap;
    }

    @Override
    PayTypeEnum getPayType() {
        return PayTypeEnum.WECHATPAY;
    }

    @Override
    public RefundResult refundQuery(String orderId, String fundId) {
        RefundResult result = super.refundQuery(orderId + suffix, fundId);
        result.setOrderId(orderId);
        return result;
    }

    @Override
    public PayDto queryPayResult(String orderId) {
        return super.queryPayResult(orderId + suffix);
    }

    @Override
    public void refund(String orderId, String fundId, Integer refundAmt) {
        super.refund(orderId + suffix, fundId, refundAmt);
    }
}

