/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.process.note.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.biz.process.note.SmsProcess;
import com.qiho.center.biz.process.note.SmsProcessFactory;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.SimpleTemplateUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CLSmsProcessImpl
implements SmsProcess,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(CLSmsProcessImpl.class);
    @Value(value="${chuanglan.sms.url}")
    private String smsUrl;
    @Value(value="${chuanglan.sms.account}")
    private String account;
    @Value(value="${chuanglan.sms.password}")
    private String password;
    private static final String SUCCESS_CODE = "0";
    private static final String CODE_NAME = "code";

    @Override
    public boolean smsSendByParam(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = this.getStrTemplate(template, param);
        String res = this.smsSend(context, mobile, template.getReport());
        if (StringUtils.isNotBlank((CharSequence)res)) {
            JSONObject clObject = JSON.parseObject((String)res);
            return StringUtils.equals((CharSequence)SUCCESS_CODE, (CharSequence)((String)clObject.get((Object)CODE_NAME)));
        }
        return false;
    }

    @Override
    public String smsSendByParamRetCode(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = this.getStrTemplate(template, param);
        return this.smsSend(context, mobile, template.getReport());
    }

    @Override
    public boolean smsSend(QihoTemplateEntity template, String mobile) {
        String res = this.smsSend(template.getTemplateContext(), mobile, template.getReport());
        JSONObject clObject = JSON.parseObject((String)res);
        return StringUtils.equals((CharSequence)((String)clObject.get((Object)CODE_NAME)), (CharSequence)SUCCESS_CODE);
    }

    @Override
    public String smsSendRetCode(QihoTemplateEntity template, String mobile) {
        return this.smsSend(template.getTemplateContext(), mobile, template.getReport());
    }

    public String smsSend(String content, String mobile, Boolean report) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("account", this.account);
        params.put("password", this.password);
        params.put("phone", mobile);
        params.put("msg", content);
        params.put("report", String.valueOf(report));
        String jsonData = JSONObject.toJSONString(params);
        try {
            String resp = HttpClientUtil.sendPostJson((String)this.smsUrl, (String)jsonData);
            if (StringUtils.isNotBlank((CharSequence)resp)) {
                JSONObject clObject = JSON.parseObject((String)resp);
                if (!StringUtils.equals((CharSequence)((String)clObject.get((Object)CODE_NAME)), (CharSequence)SUCCESS_CODE)) {
                    AppLogUtil.warn((Logger)LOGGER, (String)"\u521b\u84dd\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff0c mobile={}, content={}, resp={}", (Object[])new Object[]{mobile, content, resp});
                }
                return resp;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u84dd\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1amobile={}", (Object)mobile, (Object)e);
        }
        return "";
    }

    private String getStrTemplate(QihoTemplateEntity template, Map<String, String> param) {
        return SimpleTemplateUtil.render((String)template.getTemplateContext(), param);
    }

    public void afterPropertiesSet() throws Exception {
        SmsProcessFactory.registPaychannel(SmsTypeEnum.CHUANG_LAN, this);
    }
}

