/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.process.note.impl;

import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.biz.process.note.SmsProcess;
import com.qiho.center.biz.process.note.SmsProcessFactory;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.SimpleTemplateUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MLSmsProcessImpl
implements SmsProcess,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MLSmsProcessImpl.class);
    @Value(value="${meilian.sms.url}")
    private String smsUrl;
    @Value(value="${meilian.sms.username}")
    private String username;
    @Value(value="${meilian.sms.password}")
    private String passwordMd5;
    @Value(value="${meilian.sms.apiKey}")
    private String apiKey;

    @Override
    public boolean smsSendByParam(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = this.getStrTemplate(template, param);
        return this.smsSend(context, mobile);
    }

    @Override
    public String smsSendByParamRetCode(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        if (this.smsSendByParam(template, param, mobile)) {
            return "000000";
        }
        return "300002";
    }

    @Override
    public boolean smsSend(QihoTemplateEntity template, String mobile) {
        return this.smsSend(template.getTemplateContext(), mobile);
    }

    @Override
    public String smsSendRetCode(QihoTemplateEntity template, String mobile) {
        if (this.smsSend(template.getTemplateContext(), mobile)) {
            return "000000";
        }
        return "300002";
    }

    public void afterPropertiesSet() throws Exception {
        SmsProcessFactory.registPaychannel(SmsTypeEnum.MEI_LIAN, this);
    }

    private boolean smsSend(String content, String mobile) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", this.username);
        params.put("password_md5", this.passwordMd5);
        params.put("apikey", this.apiKey);
        params.put("mobile", mobile);
        try {
            params.put("content", URLEncoder.encode(content, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u77ed\u4fe1\u5185\u5bb9\u7f16\u7801\u5931\u8d25\uff0ccontent:{}", (Object)content, (Object)e);
            return Boolean.FALSE;
        }
        params.put("encode", "UTF-8");
        String respCode = "";
        try {
            String[] resps;
            String resp = HttpClientUtil.sendPost((String)this.smsUrl, params);
            if (StringUtils.isNotBlank((CharSequence)resp) && !StringUtils.equals((CharSequence)(respCode = (resps = resp.split(":"))[0]), (CharSequence)"success")) {
                AppLogUtil.warn((Logger)logger, (String)"\u7f8e\u8054\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff0c mobile={}, content={}, resp={}", (Object[])new Object[]{mobile, content, resp});
            }
        }
        catch (Exception e) {
            logger.error("\u7f8e\u8054\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1amobile={}", (Object)mobile, (Object)e);
        }
        return StringUtils.equals((CharSequence)respCode, (CharSequence)"success");
    }

    private String getStrTemplate(QihoTemplateEntity template, Map<String, String> param) {
        return SimpleTemplateUtil.render((String)template.getTemplateContext(), param);
    }
}

