/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.process.note.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.biz.process.note.SmsProcess;
import com.qiho.center.biz.process.note.SmsProcessFactory;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.SimpleTemplateUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class YPSmsProcessImpl
implements SmsProcess,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(YPSmsProcessImpl.class);
    @Value(value="${yunpian.sms.url}")
    private String smsUrl;
    @Value(value="${yunpian.apikey}")
    private String apikey;

    @Override
    public boolean smsSendByParam(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = this.getStrTemplate(template, param);
        return this.smsSend(context, mobile);
    }

    @Override
    public String smsSendByParamRetCode(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        if (this.smsSendByParam(template, param, mobile)) {
            return "000000";
        }
        return "300002";
    }

    @Override
    public boolean smsSend(QihoTemplateEntity template, String mobile) {
        return this.smsSend(template.getTemplateContext(), mobile);
    }

    @Override
    public String smsSendRetCode(QihoTemplateEntity template, String mobile) {
        if (this.smsSend(template.getTemplateContext(), mobile)) {
            return "000000";
        }
        return "300002";
    }

    private boolean smsSend(String context, String mobile) {
        HashMap params = Maps.newHashMap();
        params.put("apikey", this.apikey);
        params.put("text", context);
        params.put("mobile", mobile);
        Integer returnCode = -1;
        try {
            JSONObject json;
            String resp = HttpClientUtil.sendPost((String)this.smsUrl, (Map)params);
            if (StringUtils.isNotBlank((CharSequence)resp) && (returnCode = (json = JSON.parseObject((String)resp)).getInteger("code")) != 0) {
                AppLogUtil.warn((Logger)LOGGER, (String)"\u4e91\u7247\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff0c mobile={}, text={}, resp={}", (Object[])new Object[]{mobile, context, resp});
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u4e91\u7247\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1amobile={}", (Object)mobile, (Object)e);
        }
        return returnCode == 0;
    }

    private String getStrTemplate(QihoTemplateEntity template, Map<String, String> param) {
        return SimpleTemplateUtil.render((String)template.getTemplateContext(), param);
    }

    public void afterPropertiesSet() throws Exception {
        SmsProcessFactory.registPaychannel(SmsTypeEnum.YUNPIAN, this);
    }
}

