/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.process.note.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.biz.process.note.SmsProcess;
import com.qiho.center.biz.process.note.SmsProcessFactory;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.YZHUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class YZXSmsProcessImpl
implements SmsProcess,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(YZXSmsProcessImpl.class);
    @Value(value="${yunzhixun.sms.server}")
    private String server;
    @Value(value="${yunzhixun.sms.version}")
    private String version;
    @Value(value="${yunzhixun.sms.accountSid}")
    private String accountSid;
    @Value(value="${yunzhixun.sms.authToken}")
    private String authToken;
    @Value(value="${yunzhixun.sms.appId}")
    private String appId;

    private String smsSendRetCode(QihoTemplateEntity template, String context, String mobile) {
        try {
            HttpPost httpPost = YZHUtil.createHttpPost((String)template.getNoteTemplateId(), (String)mobile, (String)context, (String)this.accountSid, (String)this.authToken, (String)this.server, (String)this.version, (String)this.appId);
            String resultBase = HttpClientUtil.postUseSelfBody((HttpPost)httpPost, (String)"utf-8");
            if (StringUtils.isNotBlank((CharSequence)resultBase)) {
                JSONObject json = JSON.parseObject((String)resultBase);
                JSONObject firstCode = json.getJSONObject("resp");
                String returnCode = firstCode.getString("respCode");
                if (!"000000".equals(returnCode)) {
                    AppLogUtil.warn((Logger)LOGGER, (String)"\u4e91\u4e4b\u8baf\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff0c mobile={}, text={}, resp={}", (Object[])new Object[]{mobile, context, resultBase});
                }
                return returnCode;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u4e91\u4e4b\u8baf\u77ed\u4fe1\u5931\u8d25 msg={}", (Throwable)e);
        }
        return "300002";
    }

    @Override
    public boolean smsSendByParam(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = this.getStrParam(template, param);
        return this.smsSend(template, context, mobile);
    }

    @Override
    public String smsSendByParamRetCode(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = this.getStrParam(template, param);
        return this.smsSendRetCode(template, context, mobile);
    }

    @Override
    public boolean smsSend(QihoTemplateEntity template, String mobile) {
        return this.smsSend(template, "", mobile);
    }

    @Override
    public String smsSendRetCode(QihoTemplateEntity template, String mobile) {
        return this.smsSendRetCode(template, "", mobile);
    }

    private boolean smsSend(QihoTemplateEntity template, String context, String mobile) {
        String returnCode = "";
        try {
            JSONObject json;
            JSONObject firstCode;
            HttpPost httpPost = YZHUtil.createHttpPost((String)template.getNoteTemplateId(), (String)mobile, (String)context, (String)this.accountSid, (String)this.authToken, (String)this.server, (String)this.version, (String)this.appId);
            String resultBase = HttpClientUtil.postUseSelfBody((HttpPost)httpPost, (String)"utf-8");
            if (StringUtils.isNotBlank((CharSequence)resultBase) && !"000000".equals(returnCode = (firstCode = (json = JSON.parseObject((String)resultBase)).getJSONObject("resp")).getString("respCode"))) {
                AppLogUtil.warn((Logger)LOGGER, (String)"\u4e91\u4e4b\u8baf\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff0c mobile={}, text={}, resp={}", (Object[])new Object[]{mobile, context, resultBase});
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u4e91\u4e4b\u8baf\u77ed\u4fe1\u5931\u8d25 msg={}", (Throwable)e);
        }
        return "000000".equals(returnCode);
    }

    private String getStrParam(QihoTemplateEntity template, Map<String, String> param) {
        String templateContext = template.getTemplateContext();
        List<String> variateList = this.getVariateStr(templateContext);
        if (CollectionUtils.isEmpty(variateList)) {
            return "";
        }
        List vals = variateList.stream().map(param::get).collect(Collectors.toList());
        return YZHUtil.getSmsParam(vals);
    }

    private List<String> getVariateStr(String context) {
        ArrayList<String> resultBase = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)context)) {
            return resultBase;
        }
        Matcher m = Pattern.compile("#(.*?)#").matcher(context);
        while (m.find()) {
            resultBase.add(m.group().replaceAll("#", "").trim());
        }
        return resultBase;
    }

    public void afterPropertiesSet() throws Exception {
        SmsProcessFactory.registPaychannel(SmsTypeEnum.YUNZHIXUN, this);
    }
}

