/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.BannerDto;
import com.qiho.center.api.remoteservice.RemoteBannerService;
import com.qiho.center.biz.service.BannerService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteBannerServiceImpl
implements RemoteBannerService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteBannerServiceImpl.class);
    @Autowired
    private BannerService bannerService;

    public DubboResult<BannerDto> getBannerById(Long id) {
        try {
            return DubboResult.successResult((Object)this.bannerService.findById(id));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteBannerImpl.getBannerById failed, bannerId={}", (Object)id, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<BannerDto>> getAllBanners(String bannerType) {
        try {
            return DubboResult.successResult(this.bannerService.findAllBanners(bannerType));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteBannerImpl.getAllBanners failed", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<BannerDto>> getValidBanners(String bannerType) {
        try {
            return DubboResult.successResult(this.bannerService.findValidBanners(bannerType));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteBannerImpl.getValidBanners failed", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> saveBanner(BannerDto dto) {
        try {
            return DubboResult.successResult((Object)(this.bannerService.saveBanner(dto) > 0 ? 1 : 0));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteBannerImpl.saveBanner failed, bannerDto={}", (Object)dto, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteBanner(Long id) {
        try {
            return DubboResult.successResult((Object)(this.bannerService.deleteBanner(id) > 0 ? 1 : 0));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteBannerImpl.deleteBanner failed, bannerId={}", (Object)id, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> sortBanner(String idList) {
        try {
            return DubboResult.successResult((Object)this.bannerService.sortBanner(idList));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteBannerImpl.sortBanner failed", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> findMaxPayload() {
        try {
            return DubboResult.successResult((Object)this.bannerService.findMaxPayload());
        }
        catch (Exception e) {
            LOG.error("invoke RemoteBannerImpl.findMaxPayload failed", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

