/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.AsyncAcceptParams;
import com.qiho.center.api.remoteservice.RemotePayService;
import com.qiho.center.biz.paychannel.pay.PayChannelDecider;
import com.qiho.center.biz.paychannel.pay.PayChannelProcessor;
import com.qiho.center.common.util.AppLogUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemotePayServiceImpl
implements RemotePayService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private PayChannelDecider payChannelDecider;

    public DubboResult<String> submitPay(String orderId, String payType) {
        if (StringUtils.isBlank((CharSequence)orderId) || StringUtils.isBlank((CharSequence)payType)) {
            return DubboResult.failResult((String)"\u53c2\u6570\u975e\u6cd5,\u8ba2\u5355id\u6216\u8005\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayChannelProcessor payChannelProcessor = this.payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode((String)payType));
        try {
            return DubboResult.successResult((Object)payChannelProcessor.payExecute(orderId, null));
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u63d0\u4ea4\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25 msg={} orderId={} payTpye={}", (Object[])new Object[]{e.getMessage(), orderId, payType});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> notifyCheck(AsyncAcceptParams params) {
        if (StringUtils.isBlank((CharSequence)params.getPayType())) {
            return DubboResult.failResult((String)"\u53c2\u6570\u975e\u6cd5,\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayChannelProcessor payChannelProcessor = this.payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode((String)params.getPayType()));
        try {
            payChannelProcessor.processNotify(params);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u63d0\u4ea4\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25 reportContent={}", (Object[])new Object[]{params, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> checkSign(String map, String payType) {
        PayChannelProcessor payChannelProcessor = this.payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode((String)payType));
        try {
            Map maps = (Map)JSON.parseObject((String)map, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            return DubboResult.successResult((Object)payChannelProcessor.verify(maps));
        }
        catch (Exception e) {
            return DubboResult.successResult((Object)Boolean.FALSE);
        }
    }

    public DubboResult<String> submitPayWithParams(String orderId, String payType, Map<String, String> params) {
        if (StringUtils.isBlank((CharSequence)orderId) || StringUtils.isBlank((CharSequence)payType)) {
            return DubboResult.failResult((String)"\u53c2\u6570\u975e\u6cd5,\u8ba2\u5355id\u6216\u8005\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayChannelProcessor payChannelProcessor = this.payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode((String)payType));
        try {
            return DubboResult.successResult((Object)payChannelProcessor.payExecute(orderId, params));
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u63d0\u4ea4\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25 msg={} orderId={} payTpye={}", (Object[])new Object[]{e.getMessage(), orderId, payType});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<String> getOpenIdByCode(String code) {
        PayChannelProcessor payChannelProcessor = this.payChannelDecider.decidePayChannel(PayTypeEnum.WECHATPAY_PUB);
        try {
            return DubboResult.successResult((Object)payChannelProcessor.getOpenIdByCode(code));
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u83b7\u53d6openId\u5931\u8d25 msg={},code={}", (Object[])new Object[]{e.getMessage(), code});
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

