/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.collect.Sets;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.remoteservice.RemoteRecommendItemService;
import com.qiho.center.biz.bo.ItemRecommendBo;
import com.qiho.center.biz.service.ItemRecommendService;
import com.qiho.center.biz.service.ItemService;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteRecommendItemServiceImpl
implements RemoteRecommendItemService {
    private Logger logger = LoggerFactory.getLogger(RemoteRecommendItemServiceImpl.class);
    @Autowired
    private ItemRecommendService itemRecommendService;
    @Autowired
    private ItemRecommendBo itemRecommendBo;
    @Autowired
    private ItemService itemService;

    public DubboResult<Void> recommendBatch(List<Long> itemIds) {
        try {
            this.itemRecommendService.recommendBatch(itemIds);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            this.logger.error("invoke RemoteItemService.recommendBatch failed, itemIds={}", itemIds, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ItemDto>> findRecommendItemList() {
        return DubboResult.successResult(this.itemRecommendBo.findRecommendItemList());
    }

    public DubboResult<Boolean> deleteItemRecommend(Long itemId) {
        HashSet idset = Sets.newHashSet();
        idset.add(itemId);
        this.itemRecommendService.deleteItemRecommend(idset);
        return DubboResult.successResult((Object)true);
    }

    public DubboResult<Integer> sortItemRecommend(List<Long> itemIds) {
        return DubboResult.successResult((Object)this.itemRecommendService.sortItemRecommend(itemIds));
    }

    public DubboResult<List<ItemDto>> findRecommendIndex() {
        try {
            List<ItemDto> list = this.itemService.findRecommendIndex();
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            this.logger.error("invoke RemoteRecommendItemService.findRecommendIndex failed", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

