/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.blackList;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.blackList.BlackListDto;
import com.qiho.center.api.dto.blackList.BlacklistCheckDto;
import com.qiho.center.api.enums.QueryBlackListTypeEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.BlackListCheckParams;
import com.qiho.center.api.params.BlackListOperationParams;
import com.qiho.center.api.params.BlackListParams;
import com.qiho.center.api.params.BlackStrategyParams;
import com.qiho.center.api.remoteservice.blackList.RemoteBlackListService;
import com.qiho.center.biz.bo.BlackListBo;
import com.qiho.center.biz.service.BlackListService;
import com.qiho.center.biz.service.order.OrderStrategyService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteBlackListServiceImpl
implements RemoteBlackListService {
    private Logger logger = LoggerFactory.getLogger(RemoteBlackListServiceImpl.class);
    @Autowired
    private BlackListService blackListService;
    @Autowired
    private OrderStrategyService orderStrategyService;
    @Autowired
    private BlackListBo blackListBo;

    public DubboResult<Integer> findBlackListCount(BlackListParams params) {
        try {
            return DubboResult.successResult((Object)this.blackListService.findBlackListCount(params));
        }
        catch (Exception e) {
            this.logger.error("invoke RemoteBlackListService.findBlackListCount failed, params={}", (Object)params.toString(), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PagenationDto<BlackListDto>> queryBlackListPage(BlackListParams params) {
        try {
            return DubboResult.successResult(this.blackListService.queryBlackListPage(params));
        }
        catch (Exception e) {
            this.logger.error("invoke RemoteBlackListService.queryBlackListPage failed, params={}", (Object)params.toString(), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> batchBlackList(String progressKey, List<BlackListOperationParams> paramList) {
        try {
            return DubboResult.successResult((Object)this.blackListBo.batchBlackList(progressKey, paramList));
        }
        catch (Exception e) {
            this.logger.error("invoke RemoteLogisticsOrderService.batchBlackList failed, progressKey={}, paramList={}", new Object[]{progressKey, paramList, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> delete(Long id, QueryBlackListTypeEnum type) {
        try {
            return DubboResult.successResult((Object)this.blackListService.deleteById(id, type));
        }
        catch (Exception e) {
            this.logger.error("invoke RemoteBlackListService.batchBlackList failed, id={}", (Object)id, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateBlackStrategy(BlackStrategyParams blackStrategyParams) {
        try {
            OrderStrategyDto orderStrategyDto = this.orderStrategyService.findStrategyById(blackStrategyParams.getId());
            orderStrategyDto.setUpdator(blackStrategyParams.getUpdator());
            orderStrategyDto.setRulevalue(JSONObject.toJSONString((Object)blackStrategyParams));
            return DubboResult.successResult((Object)this.orderStrategyService.updateStrategy(orderStrategyDto));
        }
        catch (Exception e) {
            this.logger.error("invoke RemoteBlackListService.updateBlackStrategy failed, blackStrategyParams={}", (Object)blackStrategyParams.toString(), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<BlacklistCheckDto> blackListCheck(BlackListCheckParams params) {
        try {
            BlacklistCheckDto dto = this.blackListService.blacklistCheck(params);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            this.logger.error("invoke RemoteBlackListService.blackListCheck failed, params={}", (Object)params, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<OrderStrategyDto> findBlackStrategy(StrategyType strategyType) {
        try {
            return DubboResult.successResult((Object)this.orderStrategyService.findStrategyByStrategyType(strategyType));
        }
        catch (Exception e) {
            this.logger.error("invoke RemoteBlackListService.updateBlackStrategy failed, strategyType={}", (Object)strategyType.getMessage(), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

