/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.finance;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.FinanceDetailDto;
import com.qiho.center.api.dto.finance.HistoricalBalanceDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.params.finance.BaiqiMerchantFreetextParam;
import com.qiho.center.api.remoteservice.finance.RemoteFinanceDetailService;
import com.qiho.center.biz.service.finance.FinanceDetailService;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteFinanceDetailServiceImpl
implements RemoteFinanceDetailService {
    @Resource
    FinanceDetailService financeDetailService;

    public PagenationDto<FinanceDetailDto> findByParams(BaiqiMerchantFreetextParam params) {
        return this.financeDetailService.findByParams(params);
    }

    public Long insert(FinanceDetailDto financeDetailDto) {
        return this.financeDetailService.insert(financeDetailDto);
    }

    public PagenationDto<FinanceDetailDto> findFinanceDetailByMerchantId(BaiqiMerchantFreetextParam pageParam) {
        if (BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode() == pageParam.getRelationType().intValue()) {
            return this.financeDetailService.findFinanceDetailByAgentId(pageParam);
        }
        return this.financeDetailService.findFinanceDetailByMerchantId(pageParam);
    }

    public PagenationDto<HistoricalBalanceDto> findHistoricalBalanceByPara(BaiqiMerchantFreetextParam params) {
        return this.financeDetailService.findHistoricalBalanceByPara(params);
    }

    public Integer findIncomeInfoCount() {
        return this.financeDetailService.findIncomeInfoCount();
    }

    public Integer findHistoricalBalanceCount() {
        return this.financeDetailService.findHistoricalBalanceCount();
    }

    public Boolean historicalBalanceSync() {
        return this.financeDetailService.historicalBalanceSync();
    }
}

