/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.finance;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.AllocateAmountDto;
import com.qiho.center.api.dto.finance.FinanceDto;
import com.qiho.center.api.enums.finance.FinanceStatusEnum;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.enums.finance.PartnerResultStateEnum;
import com.qiho.center.api.params.finance.FinanceBasePageParam;
import com.qiho.center.api.remoteservice.finance.RemoteFinanceService;
import com.qiho.center.biz.service.finance.AllocateAmountService;
import com.qiho.center.biz.service.finance.FinanceService;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteFinanceServiceImpl
implements RemoteFinanceService {
    @Autowired
    FinanceService financeService;
    @Resource
    private AllocateAmountService allocateAmountService;

    public PagenationDto<FinanceDto> findAll(FinanceBasePageParam pageParam) {
        return this.financeService.findAll(pageParam);
    }

    public PartnerResultStateEnum allocateAmountRecharge(AllocateAmountDto allocateAmountDto) throws BizException {
        return this.allocateAmountService.allocateAmountRecharge(allocateAmountDto);
    }

    public PartnerResultStateEnum allocateAmountReverse(AllocateAmountDto allocateAmountDto) throws BizException {
        return this.allocateAmountService.allocateAmountReverse(allocateAmountDto);
    }

    public FinanceDto findFinanceByMerchantId(long merchantId) {
        return this.financeService.findFinanceByMerchantId(merchantId);
    }

    public FinanceDto findByRelation(FinanceTypeEnum typeEnum, Long relationId) {
        BaiqiFinanceEntity entity = this.financeService.findByRelation(typeEnum, relationId);
        return this.transformEntityToDto(entity);
    }

    private FinanceDto transformEntityToDto(BaiqiFinanceEntity entity) {
        if (entity == null) {
            return null;
        }
        FinanceDto financeDto = new FinanceDto();
        financeDto.setRelationType(FinanceTypeEnum.getByCode((Integer)entity.getRelationType()));
        financeDto.setRelationId(entity.getRelationId());
        financeDto.setName(entity.getName());
        financeDto.setTotalAmount(entity.getTotalAmount());
        financeDto.setCashAmount(entity.getCashAmount());
        financeDto.setRebateAmount(entity.getRebateAmount());
        financeDto.setState(FinanceStatusEnum.getByCode((int)entity.getState()));
        financeDto.setDeleted(entity.getDeleted());
        financeDto.setId(entity.getId());
        financeDto.setGmtCreate(entity.getGmtCreate());
        financeDto.setGmtModified(entity.getGmtModified());
        return financeDto;
    }

    public Integer findBaseInfoCount() {
        return this.financeService.findBaseInfoCount();
    }
}

