/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.logistics;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsDto;
import com.qiho.center.api.dto.logistics.LogisticsNicknameDto;
import com.qiho.center.api.params.logitics.LogisticsQueryParam;
import com.qiho.center.api.remoteservice.logistics.RemoteLogisticsService;
import com.qiho.center.biz.service.logistics.LogisticsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteLogisticsServiceImpl
implements RemoteLogisticsService {
    @Autowired
    private LogisticsService logisticsService;

    public List<LogisticsDto> findAll() {
        return BeanUtils.copyList(this.logisticsService.findAllByCache(), LogisticsDto.class);
    }

    public PagenationDto<LogisticsDto> queryPage(LogisticsQueryParam param) {
        return this.logisticsService.queryPage(param);
    }

    public List<LogisticsNicknameDto> findNickname(Long logisticsId) {
        return this.logisticsService.findNickname(logisticsId);
    }

    public Boolean addNickname(LogisticsNicknameDto dto) throws BizException {
        return this.logisticsService.addNickname(dto);
    }

    public Boolean deleteNickname(Long logisticsId) throws BizException {
        return this.logisticsService.deleteNickname(logisticsId);
    }

    public LogisticsDto findByCode(String logisticsCode) {
        return (LogisticsDto)BeanUtils.copy((Object)this.logisticsService.findByCode(logisticsCode), LogisticsDto.class);
    }

    public Boolean insertLogistics(LogisticsDto dto) {
        return this.logisticsService.insertLogistics(dto);
    }

    public Boolean deleteLogistics(Long id) {
        return this.logisticsService.deleteLogistics(id);
    }
}

