/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.merchant;

import cn.com.duiba.boot.exception.BizException;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.merchant.MerchantAdvertDto;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantAdvertBackendService;
import com.qiho.center.biz.service.advert.BaiqiTuiaAdvertConsumeService;
import com.qiho.center.biz.service.merchant.BaiqiMerchantLinkService;
import com.qiho.center.common.entityd.qiho.merchant.BaiqiMerchantLinkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteMerchantAdvertBackendServiceImpl
implements RemoteMerchantAdvertBackendService {
    @Resource
    private BaiqiMerchantLinkService merchantLinkService;
    @Resource
    private BaiqiTuiaAdvertConsumeService tuiaAdvertConsumeService;

    public List<MerchantAdvertDto> findAll(Long merchantId) {
        return this.merchantLinkService.findAllWithUnlinked(merchantId);
    }

    public List<SimpleIdAndNameDto> findUnLinkedAdvert() {
        List<BaiqiMerchantLinkEntity> allLinkList = this.merchantLinkService.findByType(BaiqiMerchantLinkTypeEnum.TUI_A);
        if (CollectionUtils.isEmpty(allLinkList)) {
            return Collections.emptyList();
        }
        List<BaiqiMerchantLinkEntity> unLinkedList = allLinkList.stream().filter(e -> e.getMerchantId() == null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(unLinkedList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)unLinkedList.size());
        unLinkedList.forEach(e -> {
            SimpleIdAndNameDto idAndNameDto = new SimpleIdAndNameDto();
            idAndNameDto.setId(e.getRelationId());
            idAndNameDto.setName(e.getRelationName());
            result.add(idAndNameDto);
        });
        return result;
    }

    public Boolean insertMerchantAdvert(MerchantAdvertDto merchantAdvertDto) throws BizException {
        Long relationId = this.merchantLinkService.findRelationIdByMerchantIdAndRelationType(merchantAdvertDto.getMerchantId(), BaiqiMerchantLinkTypeEnum.TUI_A);
        if (relationId != null && relationId != 0L) {
            throw new BizException("\u8be5\u5546\u5bb6\u5df2\u5173\u8054\u5e7f\u544a\u4e3b");
        }
        return this.merchantLinkService.insert(merchantAdvertDto);
    }

    public List<MerchantAdvertDto> findAdvertConsume(Long merchantId, Date startDate, Date endDate) {
        return this.tuiaAdvertConsumeService.findAdvertConsume(merchantId, startDate, endDate);
    }
}

