/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.merchant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.OpenInterfaceDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.dto.merchant.MerchantSpacialDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.api.params.MerchantQueryParams;
import com.qiho.center.api.params.OpenInterfaceQueryParams;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantService;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.biz.service.merchant.BaiqiMerchantLinkService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.biz.service.merchant.MerchantUndeliveryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteMerchantServiceImpl
implements RemoteMerchantService {
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private BaiqiAccountService baiqiAccountService;
    @Autowired
    private BaiqiMerchantLinkService merchantLinkService;
    @Resource
    private MerchantUndeliveryService merchantUndeliveryService;

    public MerchantDto findById(Long merchantId) {
        return this.merchantService.findById(merchantId);
    }

    public Boolean saveMerchant(MerchantDto dto) throws BizException {
        return this.merchantService.saveMerchant(dto);
    }

    public PagenationDto<MerchantDto> querypage(MerchantQueryParams params) {
        return this.merchantService.queryPage(params);
    }

    public List<MerchantDto> findListByName(String name) {
        return this.merchantService.findByName(name);
    }

    public MerchantDto findByItemId(Long itemId) {
        return this.merchantService.findByItemId(itemId);
    }

    public List<SimpleIdAndNameDto> findAllMerchantSimple() {
        List<MerchantSimpleDto> merchantSimpleDtos = this.merchantService.findAllIdAndNames();
        if (CollectionUtils.isEmpty(merchantSimpleDtos)) {
            return Collections.emptyList();
        }
        ArrayList<SimpleIdAndNameDto> idAndNameDtos = new ArrayList<SimpleIdAndNameDto>(merchantSimpleDtos.size());
        for (MerchantSimpleDto simpleDto : merchantSimpleDtos) {
            SimpleIdAndNameDto idAndNameDto = new SimpleIdAndNameDto();
            idAndNameDto.setId(simpleDto.getId());
            idAndNameDto.setName(simpleDto.getMerchantName());
            idAndNameDtos.add(idAndNameDto);
        }
        return idAndNameDtos;
    }

    public List<SimpleIdAndNameDto> findAllIdAndNames() {
        List<Long> merchantIds = this.baiqiAccountService.findRelationIdsByAccountType(BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode());
        List<MerchantSimpleDto> merchantSimpleDtos = this.merchantService.findAllIdAndNames();
        if (CollectionUtils.isEmpty(merchantSimpleDtos)) {
            return Collections.emptyList();
        }
        ArrayList<SimpleIdAndNameDto> filterDtos = new ArrayList<SimpleIdAndNameDto>();
        for (MerchantSimpleDto simpleDto : merchantSimpleDtos) {
            if (merchantIds.contains(simpleDto.getId())) continue;
            SimpleIdAndNameDto simple = new SimpleIdAndNameDto();
            simple.setId(simpleDto.getId());
            simple.setName(simpleDto.getMerchantName());
            filterDtos.add(simple);
        }
        return filterDtos;
    }

    public List<MerchantSpacialDto> findAll() {
        return BeanUtils.copyList(this.merchantService.findAll(), MerchantSpacialDto.class);
    }

    public Long findRelationIdByMerchantIdAndRelationType(Long merchantId, BaiqiMerchantLinkTypeEnum relationType) {
        return this.merchantLinkService.findRelationIdByMerchantIdAndRelationType(merchantId, relationType);
    }

    public List<String> findUndelivery(Long merchantId) {
        return this.merchantUndeliveryService.findUndelivery(merchantId);
    }

    public PagenationDto<OpenInterfaceDto> openInterfacePageQuery(OpenInterfaceQueryParams params) {
        return this.merchantService.openInterfacePageQuery(params);
    }

    public Boolean saveOpenInterface(OpenInterfaceDto dto) {
        return this.merchantService.saveOpenInterface(dto);
    }

    public Boolean updateOpenInterface(OpenInterfaceDto dto) {
        return this.merchantService.updateOpenInterface(dto);
    }

    public OpenInterfaceDto findByMerchantId(Long merchantId) {
        return this.merchantService.findByMerchantId(merchantId);
    }

    public OpenInterfaceDto findByAppKey(String appKey) {
        return this.merchantService.findByAppKey(appKey);
    }

    public List<MerchantSimpleDto> findNoOpenInterface(String merchantName) {
        return this.merchantService.findNoOpenInterface(merchantName);
    }

    public Boolean initOpenInterface(OpenInterfaceDto dto) {
        return this.merchantService.updateOpenInterface(dto);
    }

    public Integer findHasAppKeyCount() {
        return this.merchantService.findHasAppKeyCount();
    }

    public OpenInterfaceDto checkedAppKey(String appKey, String appSecret) {
        return this.merchantService.checkedAppKey(appKey, appSecret);
    }

    public boolean updateVersionSign(String versionSign, Long id) {
        return this.merchantService.updateVersionSign(versionSign, id);
    }
}

