/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.order;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.params.BatchResolveErpDeliverParams;
import com.qiho.center.api.params.ErpOrderPageParams;
import com.qiho.center.api.params.ResolveDeliverParams;
import com.qiho.center.api.params.WdtOrderAuditParams;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.center.biz.bo.ErpOrderBo;
import com.qiho.center.biz.bo.OrderBo;
import com.qiho.center.biz.runnable.BatchReviewFaildErpOrderRunnable;
import com.qiho.center.biz.runnable.DealWithErpOrderDeliverRunnable;
import com.qiho.center.biz.service.order.ErpOrderService;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteErpOrderServiceImpl
implements RemoteErpOrderService,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteErpOrderServiceImpl.class);
    @Autowired
    private ErpOrderService erpOrderService;
    @Autowired
    private ErpOrderBo erpOrderBo;
    @Resource
    private ExecutorService executorService;
    private ApplicationContext applicationContext;
    @Autowired
    OrderBo orderBo;

    public DubboResult<List<ErpOrderDto>> findByOrderId(String orderId) {
        try {
            List<ErpOrderDto> list = this.erpOrderService.findByOrderId(orderId);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteErpOrderService.findByOrderId failed,orderId={}", (Object)orderId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ErpOrderDto>> findByOrderIds(List<String> orderIds) {
        try {
            List<ErpOrderDto> list = this.erpOrderService.findByOrderIds(orderIds);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteErpOrderService.findByOrderIds failed,orderIds={}", orderIds, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<OrderSnapshotDto>> findWdtExportErpOrder(ErpOrderPageParams params) {
        return DubboResult.successResult(this.erpOrderService.findWdtExportErpOrder(params));
    }

    public DubboResult<PagenationDto<ErpOrderDto>> findErpOrderPage(ErpOrderPageParams params) {
        return DubboResult.successResult(this.erpOrderService.findErpOrderPage(params));
    }

    public DubboResult<Integer> findErpOrderPageCount(ErpOrderPageParams params) {
        return DubboResult.successResult((Object)this.erpOrderService.findErpOrderPageCount(params));
    }

    public DubboResult<Boolean> cancelDeliver(String erpId) {
        try {
            this.erpOrderBo.cancelDeliver(erpId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> resolveDeliver(ResolveDeliverParams params) {
        try {
            this.erpOrderBo.resolveDeliver(params);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> batchResolveErpDeliver(String progressKey, List<BatchResolveErpDeliverParams> paramList) {
        try {
            DealWithErpOrderDeliverRunnable runnable = (DealWithErpOrderDeliverRunnable)this.applicationContext.getBean(DealWithErpOrderDeliverRunnable.class);
            runnable.setProgressKey(progressKey);
            runnable.setParamsList(paramList);
            int size = runnable.init();
            this.executorService.submit(runnable);
            return DubboResult.successResult((Object)size);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public DubboResult<Integer> batchReviewFaildErpOrder(String progressKey, List<ErpOrderDto> list) {
        try {
            BatchReviewFaildErpOrderRunnable runnable = (BatchReviewFaildErpOrderRunnable)this.applicationContext.getBean(BatchReviewFaildErpOrderRunnable.class);
            runnable.setProgressKey(progressKey);
            runnable.setParams(list);
            int size = runnable.enableFilter();
            this.executorService.submit(runnable);
            return DubboResult.successResult((Object)size);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateStatus(String erpId, String erpStatus) {
        try {
            this.erpOrderService.updateErpStatus(erpId, ErpStatusEnum.getByCode((String)erpStatus), null, null);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteErpOrderService.updateStatus failed,erpId={},erpStatus={}", new Object[]{erpId, erpStatus, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateErpId(Long id, String erpId) {
        try {
            this.erpOrderService.updateErpId(id, erpId);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteErpOrderService.updateErpId failed,id={},erpId={}", new Object[]{id, erpId, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> wdtBatchAuditOrder(String progressKey, List<WdtOrderAuditParams> list) {
        int result = this.orderBo.wdtBatchAuditOrder(progressKey, list);
        return DubboResult.successResult((Object)result);
    }
}

