/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.order.BatchOrderCancelDto;
import com.qiho.center.api.dto.order.BatchOrderConfirmDto;
import com.qiho.center.api.dto.order.OpenBatchOrderCancelDto;
import com.qiho.center.api.dto.order.OpenBatchOrderConfirmDto;
import com.qiho.center.api.dto.order.OrderCancelDto;
import com.qiho.center.api.dto.order.OrderConfirmDto;
import com.qiho.center.api.dto.task.BatchOrderTaskDto;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.ShotOrder.OrderProcessWayEnum;
import com.qiho.center.api.params.MeiLianPushParams;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.OrderConsumerParam;
import com.qiho.center.api.params.OrderGainParams;
import com.qiho.center.api.params.OrderItemParam;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.api.params.YunPianPushParams;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.center.biz.bo.NoteGainBo;
import com.qiho.center.biz.bo.OrderBo;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.biz.service.order.SmsService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteOrderServiceImpl
implements RemoteOrderService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteOrderServiceImpl.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private OrderSnapshotService orderSnapshotService;
    @Autowired
    private OrderBo orderBo;
    @Resource
    private NoteGainBo noteGainBo;

    public DubboResult<String> submit(OrderDto order, ChannelInfoDto channelInfo, String payType) {
        try {
            String orderId = this.orderService.createOrder(order, channelInfo, payType);
            return DubboResult.successResult((Object)orderId);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.submit failed, order={}, channelInfo={}", new Object[]{order, channelInfo, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> sendSmsCode(String mobile, String smsCode) {
        try {
            boolean result = this.smsService.sendSmsCode(mobile, smsCode);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.sendSmsCode failed, mobile={}, smsCode={}", new Object[]{mobile, smsCode, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PagenationDto<OrderSnapshotDto>> findAllPage(OrderPageParams params) {
        return DubboResult.successResult(this.orderSnapshotService.findOrderPage(params));
    }

    public DubboResult<Integer> findAllPageCount(OrderPageParams params) {
        return DubboResult.successResult((Object)this.orderSnapshotService.findAllPageCount(params));
    }

    public DubboResult<List<OrderSnapshotDto>> exportAllOrderPage(OrderPageParams params) {
        return DubboResult.successResult(this.orderSnapshotService.findOrderPageForExport(params));
    }

    public DubboResult<Integer> exportOrderPageCount(OrderPageParams params) {
        return DubboResult.successResult((Object)this.orderSnapshotService.exportOrderPageCount(params));
    }

    public DubboResult<Integer> batchAuditOrder(String progressKey, List<OrderAuditParams> paramList) {
        return DubboResult.successResult((Object)this.orderBo.batchAuditOrder(progressKey, paramList));
    }

    public DubboResult<Boolean> auditOrder(OrderAuditParams params) {
        try {
            return DubboResult.successResult((Object)this.orderService.auditOrder(params));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.auditOrder failed,orderId={}", (Object)params.getOrderId(), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<OrderDto> findByOrderId(String orderId) {
        try {
            OrderDto orderDto = this.orderService.findByOrderId(orderId);
            return DubboResult.successResult((Object)orderDto);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.findByOrderId failed,orderId={}", (Object)orderId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<OrderSnapshotDto> findOrderSnapshot(String orderId) {
        try {
            OrderSnapshotDto orderSnapshotDto = this.orderSnapshotService.findByOrderId(orderId);
            return DubboResult.successResult((Object)orderSnapshotDto);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.findOrderSnapshot failed,orderId={}", (Object)orderId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateOrderItem(OrderItemParam param) {
        try {
            this.orderService.updateOrderItem(param);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderItem failed,param={}", (Object)param, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateOrderItemInfo(OrderItemParam param) {
        try {
            this.orderService.updateOrderItemInfo(param);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderItemInfo failed,param={}", (Object)param, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateOrderConsumer(OrderConsumerParam param) {
        try {
            this.orderService.updateOrderConsumer(param);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderConsumer failed,param={}", (Object)param, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateOrderConsumerInfo(OrderConsumerParam param) {
        try {
            this.orderService.updateOrderConsumerInfo(param);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderConsumerInfo failed,param={}", (Object)param, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateOrderStatus(String orderId, String orderStatus) {
        try {
            this.orderService.updateOrderStatus(orderId, OrderStatusEnum.getByCode((String)orderStatus));
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderStatus failed, orderId={}, orderStatus={}", new Object[]{orderId, orderStatus, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateByOrderId(OrderDto orderDto) {
        try {
            this.orderService.updateByOrderId(orderDto);
            OrderSnapshotDto orderSnapshotDto = (OrderSnapshotDto)BeanUtils.copy((Object)orderDto, OrderSnapshotDto.class);
            this.orderSnapshotService.updateByOrderId(orderSnapshotDto);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateByOrderId failed, orderDto={}", (Object)orderDto, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<OrderSnapshotDto>> findByMobile(String mobile, List<String> statusList) {
        try {
            List<OrderSnapshotDto> list = this.orderSnapshotService.findByMobile(mobile, statusList);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.findByMobile failed,mobile={}, statusList={}", new Object[]{mobile, statusList, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateOrderWithProcessWay(List<OrderGainParams> orderGainParams) {
        if (CollectionUtils.isEmpty(orderGainParams)) {
            return DubboResult.successResult(null);
        }
        List noteGains = orderGainParams.stream().filter(e -> null != e.getOrderProcessWayEnum() && e.getOrderProcessWayEnum() == OrderProcessWayEnum.NOTE_GAIN).peek(e -> e.setProcessTime(new Date())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(noteGains)) {
            orderGainParams.removeAll(noteGains);
            List<String> orderIds = noteGains.stream().peek(this.orderSnapshotService::updateOrderProcessWayByOrderId).map(OrderGainParams::getOrderId).collect(Collectors.toList());
            List<OrderSnapshotDto> noteGainOrders = this.orderSnapshotService.queryOrderByOrderIds(orderIds);
            this.noteGainBo.sendGainNote(noteGainOrders);
        }
        try {
            if (CollectionUtils.isEmpty(orderGainParams)) {
                return DubboResult.successResult(null);
            }
            List orderAuditParams = orderGainParams.stream().map(this::gainParamToAudit).collect(Collectors.toList());
            for (OrderAuditParams orderAuditParam : orderAuditParams) {
                this.orderService.auditOrder(orderAuditParam);
            }
            return DubboResult.successResult(null);
        }
        catch (Exception e2) {
            LOG.error("invoke RemoteOrderService.updateOrderWithProcessWay failed,params={}", orderGainParams, (Object)e2);
            return DubboResult.failResult((String)e2.getMessage());
        }
    }

    public DubboResult<Boolean> notePushProcessByYunPain(YunPianPushParams params) {
        try {
            boolean checkResult = this.smsService.checkSign(params);
            if (!checkResult) {
                LOG.warn("\u77ed\u4fe1\u63a8\u9001\u9a8c\u7b7e\u5931\u8d25 param={}", (Object)params);
                return DubboResult.failResult((String)"\u77ed\u4fe1\u63a8\u9001\u9a8c\u7b7e\u5931\u8d25");
            }
            OrderSnapshotDto resultBase = this.orderSnapshotService.queryByMobileAsNewMost(params.getMobile(), OrderStatusEnum.TO_APPROVE.getCode());
            if (null == resultBase || StringUtils.isBlank((String)resultBase.getOrderId())) {
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            OrderAuditParams orderAuditParams = new OrderAuditParams();
            orderAuditParams.setOrderId(resultBase.getOrderId());
            if (StringUtils.equalsIgnoreCase((String)params.getText(), (String)"Y")) {
                orderAuditParams.setAuditResult(Integer.valueOf(1));
            } else if (StringUtils.equalsIgnoreCase((String)params.getText(), (String)"X")) {
                orderAuditParams.setAuditResult(Integer.valueOf(0));
                orderAuditParams.setRemark("\u77ed\u4fe1\u635e\u5355-\u53d6\u6d88\u8ba2\u5355");
            }
            return DubboResult.successResult((Object)this.orderService.auditOrder(orderAuditParams));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.notePushProcessByYunPain failed,param={}", (Object)params.toString(), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public List<OrderSnapshotDto> queryOrderByOrderIds(List<String> orderIds) {
        if (CollectionUtils.isEmpty(orderIds)) {
            return new ArrayList<OrderSnapshotDto>();
        }
        return this.orderSnapshotService.queryOrderByOrderIds(orderIds);
    }

    public List<OrderSnapshotDto> queryOrderAsNewMost(OrderPageParams pageParams) {
        return this.orderSnapshotService.queryOrderAsNewMost(pageParams);
    }

    private OrderAuditParams gainParamToAudit(OrderGainParams params) {
        OrderAuditParams orderAuditParams = new OrderAuditParams();
        if (null == params) {
            return orderAuditParams;
        }
        orderAuditParams.setOrderId(params.getOrderId());
        orderAuditParams.setAuditResult(params.getOrderStatus());
        if (0 == params.getOrderStatus()) {
            orderAuditParams.setRemark(params.getRemark());
        }
        return orderAuditParams;
    }

    public ItemDetailDto getOrderItemSnapshot(String orderId, Long itemId) {
        return this.orderService.getOrderItemSnapshot(orderId, itemId);
    }

    public OrderDto getLastOrderByMoblie(String mobile) {
        return this.orderService.getLastOrderByMobile(mobile);
    }

    public OrderDto getLastOrderByAcid(String acid) {
        return this.orderService.getLastOrderByAcid(acid);
    }

    public Boolean isExistOrderByMobileAndItem(String mobile, Long itemId) {
        return CollectionUtils.isNotEmpty(this.orderSnapshotService.findByMobileAndItem(mobile, itemId));
    }

    public Boolean batchAudit(List<OrderAuditParams> paramList) throws BizException {
        if (CollectionUtils.isEmpty(paramList)) {
            throw new BizException("\u6ca1\u6709\u9700\u8981\u5ba1\u6838\u7684\u8ba2\u5355");
        }
        int success = 0;
        for (OrderAuditParams params : paramList) {
            Boolean res = this.orderService.auditOrder(params);
            if (!res.booleanValue()) continue;
            ++success;
        }
        return success == paramList.size();
    }

    public DubboResult<Boolean> notePushProcessByMeiLian(MeiLianPushParams params) {
        try {
            OrderSnapshotDto resultBase = this.orderSnapshotService.queryByMobileAsNewMost(params.getMobile(), OrderStatusEnum.TO_APPROVE.getCode());
            if (null == resultBase || StringUtils.isBlank((String)resultBase.getOrderId())) {
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            OrderAuditParams orderAuditParams = new OrderAuditParams();
            orderAuditParams.setOrderId(resultBase.getOrderId());
            if (StringUtils.equalsIgnoreCase((String)params.getContent(), (String)"Y")) {
                orderAuditParams.setAuditResult(Integer.valueOf(1));
            } else if (StringUtils.equalsIgnoreCase((String)params.getContent(), (String)"X")) {
                orderAuditParams.setAuditResult(Integer.valueOf(0));
                orderAuditParams.setRemark("\u77ed\u4fe1\u635e\u5355-\u53d6\u6d88\u8ba2\u5355");
            }
            return DubboResult.successResult((Object)this.orderService.auditOrder(orderAuditParams));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.notePushProcessByYunPain failed,param={}", (Object)params.toString(), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> notePushProcessByChuangLan(Map<String, String> params) {
        try {
            OrderSnapshotDto resultBase = this.orderSnapshotService.queryByMobileAsNewMost(params.get("mobile"), OrderStatusEnum.TO_APPROVE.getCode());
            if (null == resultBase || StringUtils.isBlank((String)resultBase.getOrderId())) {
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            OrderAuditParams orderAuditParams = new OrderAuditParams();
            orderAuditParams.setOrderId(resultBase.getOrderId());
            if (StringUtils.equalsIgnoreCase((String)params.get("msg"), (String)"Y")) {
                orderAuditParams.setAuditResult(Integer.valueOf(1));
            }
            return DubboResult.successResult((Object)this.orderService.auditOrder(orderAuditParams));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.notePushProcessByChuangLan failed,param={}", (Object)params.toString(), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public OrderSnapshotDto findOrderByIdAndMobile(String orderId, String mobile) {
        return this.orderSnapshotService.findByOderIdAndMobile(orderId, mobile);
    }

    public Boolean orderConfirm(OrderConfirmDto orderConfirmDto) throws BizException {
        return this.orderService.orderConfirm(orderConfirmDto);
    }

    public Boolean orderUpdate(OrderConfirmDto orderConfirmDto) throws BizException {
        return this.orderService.orderUpdate(orderConfirmDto);
    }

    public Boolean orderCancel(OrderCancelDto orderCancelDto) throws BizException {
        return this.orderService.orderCancel(orderCancelDto.getOrderId());
    }

    public BatchOrderTaskDto batchOrderConfirm(BatchOrderConfirmDto batchOrderConfirmDto) {
        return this.orderService.batchOrderConfirm(batchOrderConfirmDto);
    }

    public BatchOrderTaskDto batchOrderUpdate(BatchOrderConfirmDto batchOrderConfirmDto) {
        return this.orderService.batchOrderUpdate(batchOrderConfirmDto);
    }

    public BatchOrderTaskDto batchOrderCancel(BatchOrderCancelDto batchOrderCancelDto) {
        return this.orderService.batchOrderCancel(batchOrderCancelDto);
    }

    public BatchOrderTaskDto openBatchOrderConfirm(OpenBatchOrderConfirmDto confirmDto) {
        return this.orderService.openBatchOrderConfirm(confirmDto);
    }

    public BatchOrderTaskDto openBatchOrderCancel(OpenBatchOrderCancelDto cancelDto) {
        return this.orderService.openBatchOrderCancel(cancelDto);
    }
}

