/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.sms;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.sms.ChuangLanSmsCommitDto;
import com.qiho.center.api.dto.sms.ChuangLanSmsReportDto;
import com.qiho.center.api.enums.ordersms.OrderSmsReceiveStatus;
import com.qiho.center.api.remoteservice.sms.RemoteChuangLanService;
import com.qiho.center.api.util.OrderSmsUtil;
import com.qiho.center.biz.event.ChuangLanReportReceiveEvent;
import com.qiho.center.biz.service.sms.ChuangLanService;
import com.qiho.center.biz.service.sms.ChuangLanSmsCommitService;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsCommitMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsCommitEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.support.BizEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteChuangLanServiceImpl
implements RemoteChuangLanService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChuangLanServiceImpl.class);
    @Autowired
    ChuangLanSmsCommitService chuangLanSmsCommitService;
    @Autowired
    ChuangLanService chuangLanService;
    @Autowired
    ChuangLanSmsCommitMapper chuangLanSmsCommitMapper;
    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;

    public ChuangLanSmsCommitDto selectByMsgId(String msgId) {
        ChuangLanSmsCommitEntity commitEntity = this.chuangLanSmsCommitMapper.selectByMsgId(msgId);
        return (ChuangLanSmsCommitDto)BeanUtils.copy((Object)commitEntity, ChuangLanSmsCommitDto.class);
    }

    public void reportHandler(ChuangLanSmsReportDto dto) {
        DBTimeProfile.enter((String)"RemoteChuangLanServiceImpl.reportHandler");
        BaiqiOrderSmsEntity baiqiOrderSmsEntity = this.updateOrderSms(dto);
        ChuangLanReportReceiveEvent event = new ChuangLanReportReceiveEvent();
        event.setOrderSmsEntity(baiqiOrderSmsEntity);
        event.setChuangLanSmsReportDto(dto);
        this.eventBus.post((Object)event);
        ChuangLanSmsCommitEntity commitEntity = this.chuangLanSmsCommitService.getChuangLanSmsCommitEntity(dto);
        if (commitEntity == null) {
            DBTimeProfile.release();
            return;
        }
        DBTimeProfile.enter((String)"invoke ChuangLanService.processReport");
        this.chuangLanService.processReport(commitEntity, dto);
        DBTimeProfile.release();
        DBTimeProfile.release();
    }

    private BaiqiOrderSmsEntity updateOrderSms(ChuangLanSmsReportDto smsReport) {
        BaiqiOrderSmsEntity param = new BaiqiOrderSmsEntity();
        param.setMobileStatus(Integer.valueOf(OrderSmsUtil.getReturnCodeByChuangLanStatus((String)smsReport.getStatus()).getNum()));
        param.setMsgId(smsReport.getMsgId());
        param.setMobile(smsReport.getMobile());
        param.setReceiveStatus(Integer.valueOf(OrderSmsReceiveStatus.PROCESSES.getNum()));
        int row = this.baiqiOrderSmsMapper.updateMobileStatus(param);
        if (row == 1) {
            BaiqiOrderSmsEntity orderSmsEntity = this.baiqiOrderSmsMapper.findByMsgId(smsReport.getMsgId());
            return orderSmsEntity;
        }
        return null;
    }
}

