/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.biz.service.order.OrderService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class AuditOrderRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(AuditOrderRunnable.class);
    @Autowired
    private OrderService orderService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private List<OrderAuditParams> params = Lists.newArrayList();
    private BoundHashOperations<String, String, Object> ops;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long failCount = 0L;
        try {
            for (OrderAuditParams param : this.params) {
                try {
                    Boolean result = this.orderService.auditOrder(param);
                    if (result.booleanValue()) continue;
                    ++failCount;
                }
                catch (Exception e) {
                    ++failCount;
                    this.logger.error("\u8ba2\u5355\u5ba1\u6838\u5931\u8d25", (Throwable)e);
                }
                finally {
                    this.ops.increment((Object)"successCount", 1L);
                }
            }
        }
        finally {
            this.ops.increment((Object)"failCount", failCount);
            this.ops.increment((Object)"taskCount", -1L);
        }
    }

    public void setProgressKey(String progressKey) {
        this.ops = this.redisTemplate.boundHashOps((Object)progressKey);
    }

    public void setParams(List<OrderAuditParams> params) {
        this.params.addAll(params);
    }

    public Integer enableFilter() {
        ArrayList newList = Lists.newArrayList();
        for (OrderAuditParams param : this.params) {
            if (StringUtils.isBlank((String)param.getOrderId()) || Objects.equal(null, (Object)param.getAuditResult())) continue;
            newList.add(param);
        }
        this.params.clear();
        this.params.addAll(newList);
        return newList.size();
    }
}

