/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.DealTypeEnum;
import com.qiho.center.api.enums.blacklist.BaiqiBlackListTypeEnum;
import com.qiho.center.api.enums.blacklist.BlackListUseTypeEnum;
import com.qiho.center.api.enums.blacklist.SourceTypeEnum;
import com.qiho.center.api.params.blacklist.BlackListBatchDealParam;
import com.qiho.center.common.daoh.qiho.blacklist.BaiqiBlackListMapper;
import com.qiho.center.common.entityd.qiho.blacklist.BaiqiBlackListEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BaiqiBlackListRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(BaiqiBlackListRunnable.class);
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private List<BlackListBatchDealParam> params = Lists.newArrayList();
    private BoundHashOperations<String, String, Object> ops;
    private Map<String, String> remarkMap = Maps.newHashMap();
    private Long merchantId;
    private String operator;
    @Resource
    private BaiqiBlackListMapper baiqiBlackListMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int failCount = 0;
        try {
            List<String> valueList = this.params.stream().map(BlackListBatchDealParam::getBkValue).collect(Collectors.toList());
            List existValueList = this.baiqiBlackListMapper.findByValueAndMerchantId(valueList, this.merchantId);
            if (CollectionUtils.isNotEmpty((Collection)existValueList)) {
                failCount += existValueList.size();
                valueList.removeAll(existValueList);
            }
            if (CollectionUtils.isEmpty(valueList)) {
                return;
            }
            List<BaiqiBlackListEntity> insertData = this.bulidInsertParam(valueList);
            int successResult = this.baiqiBlackListMapper.insertBatch(insertData);
            this.ops.increment((Object)"successCount", (long)successResult);
        }
        catch (Exception e) {
            this.logger.warn("\u6279\u91cf\u6dfb\u52a0\u9ed1\u540d\u5355\u5f02\u5e38,\u9ed1\u540d\u5355\u6570\u636e\u4e3a:" + this.params.toString(), (Throwable)e);
        }
        finally {
            this.ops.increment((Object)"failCount", (long)failCount);
            this.ops.increment((Object)"taskCount", -1L);
        }
    }

    private List<BaiqiBlackListEntity> bulidInsertParam(List<String> list) {
        return Lists.transform(list, e -> {
            BaiqiBlackListEntity entity = new BaiqiBlackListEntity();
            entity.setBkType(Integer.valueOf(BaiqiBlackListTypeEnum.PHONE.getNum()));
            entity.setBkValue(e);
            entity.setDealType(Integer.valueOf(DealTypeEnum.FORBID_SUBMIT.getNum()));
            entity.setOperator(this.operator);
            entity.setMerchantId(this.merchantId);
            entity.setRemark(this.remarkMap.get(e));
            entity.setUseType(Integer.valueOf(this.merchantId == 0L ? BlackListUseTypeEnum.ALL.getNum() : BlackListUseTypeEnum.PART.getNum()));
            entity.setSourceType(Integer.valueOf(SourceTypeEnum.MANUAL.getNum()));
            return entity;
        });
    }

    public void setProgressKey(String progressKey) {
        this.ops = this.redisTemplate.boundHashOps((Object)progressKey);
    }

    public void setParams(List<BlackListBatchDealParam> params) {
        this.params.addAll(params);
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Integer enableFilter() {
        ArrayList newList = Lists.newArrayList();
        for (BlackListBatchDealParam param : this.params) {
            if (StringUtils.isBlank((String)param.getBkValue())) continue;
            newList.add(param);
            this.remarkMap.put(param.getBkValue(), param.getRemarks());
        }
        this.params.clear();
        this.params.addAll(newList);
        return newList.size();
    }
}

