/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import com.google.common.collect.Lists;
import com.qiho.center.api.params.BatchResolveErpDeliverParams;
import com.qiho.center.api.params.ResolveDeliverParams;
import com.qiho.center.biz.bo.ErpOrderBo;
import com.qiho.center.biz.service.order.ErpOrderService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DealWithErpOrderDeliverRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(DealWithErpOrderDeliverRunnable.class);
    @Autowired
    private ErpOrderBo erpOrderBo;
    @Autowired
    private ErpOrderService erpOrderService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private List<BatchResolveErpDeliverParams> paramsList = Lists.newArrayList();
    private BoundHashOperations<String, String, Object> ops;

    public Integer init() {
        return this.paramsList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        failCount = 0L;
        failErpIdSet = new HashSet<String>();
        failRowSet = new HashSet<Integer>();
        try {
            index = 0;
lbl6:
            // 6 sources

            block12: for (BatchResolveErpDeliverParams param : this.paramsList) {
                ++index;
                try {
                    switch (param.getDealResult()) {
                        case 1: {
                            this.resolveDeliver(param);
                            ** break;
                        }
                        case 0: {
                            this.rejectDeliver(param);
                            ** break;
                        }
                        ** default:
lbl17:
                        // 1 sources

                        continue block12;
                    }
                }
                catch (Exception e) {
                    ++failCount;
                    failErpIdSet.add(param.getErpId());
                    failRowSet.add(index);
                }
                finally {
                    this.ops.increment((Object)"successCount", 1L);
                }
            }
        }
        finally {
            this.ops.increment((Object)"failCount", failCount);
            this.ops.increment((Object)"taskCount", -1L);
            this.setFailErpIdsToredis(failErpIdSet);
            this.setFailRow(failRowSet);
        }
    }

    private void setFailErpIdsToredis(Set<String> failErpIdSet) {
        if (failErpIdSet.isEmpty()) {
            return;
        }
        String failErpIds = StringUtils.join(failErpIdSet, (String)",");
        String exFailErpIds = this.ops.get((Object)"failIds").toString();
        if (StringUtils.isBlank((CharSequence)exFailErpIds)) {
            this.ops.put((Object)"failIds", (Object)failErpIds);
        } else {
            this.ops.put((Object)"failIds", (Object)(exFailErpIds + "," + failErpIds));
        }
    }

    private void setFailRow(Set<Integer> set) {
        if (set.isEmpty()) {
            return;
        }
        String failRows = StringUtils.join(set, (String)",");
        this.ops.put((Object)"failMsg", (Object)failRows);
    }

    private void resolveDeliver(BatchResolveErpDeliverParams params) {
        ResolveDeliverParams pp = new ResolveDeliverParams();
        pp.setBaiqiLogisticsName(params.getBaiqiLogisticsName());
        pp.setBaiqiLogisticsCode(params.getBaiqiLogisticsCode());
        pp.setExpressCode(params.getExpressCode());
        pp.setErpId(params.getErpId());
        this.erpOrderBo.resolveDeliver(pp);
    }

    private void rejectDeliver(BatchResolveErpDeliverParams params) {
        this.erpOrderBo.cancelDeliver(params.getErpId());
    }

    public void setProgressKey(String progressKey) {
        this.ops = this.redisTemplate.boundHashOps((Object)progressKey);
    }

    public void setParamsList(List<BatchResolveErpDeliverParams> paramsList) {
        this.paramsList.addAll(paramsList);
    }
}

