/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.enums.QueryBlackListTypeEnum;
import com.qiho.center.api.params.BlackListOperationParams;
import com.qiho.center.api.params.ExpressBlackListOperationParams;
import com.qiho.center.biz.service.BlackListService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ExpressBlackListRunnable
implements Runnable {
    private Logger log = LoggerFactory.getLogger(ExpressBlackListRunnable.class);
    @Autowired
    private BlackListService blackListService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private List<ExpressBlackListOperationParams> params = Lists.newArrayList();
    private BoundHashOperations<String, String, Object> ops;
    private static Map<ExpressCompanyEnum, QueryBlackListTypeEnum> map = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int failCount = 0;
        for (ExpressBlackListOperationParams param : this.params) {
            int result = 0;
            try {
                if (param.getDataType() == 1) {
                    if (null == param.getCompanyEnum()) {
                        ++failCount;
                        continue;
                    }
                    Long recordId = this.blackListService.findOneBlack(param.getCompanyEnum(), param.getBkValue());
                    if (null == recordId) {
                        BlackListOperationParams para = (BlackListOperationParams)BeanUtils.copy((Object)param, BlackListOperationParams.class);
                        para.setType(map.get(param.getCompanyEnum()));
                        result = this.blackListService.addBlackValue(para);
                    }
                } else if (param.getDataType() == 0) {
                    BlackListOperationParams para = (BlackListOperationParams)BeanUtils.copy((Object)param, BlackListOperationParams.class);
                    para.setType(map.get(param.getCompanyEnum()));
                    result = this.blackListService.deleteByValue(para);
                }
                if (result != 0) continue;
                ++failCount;
            }
            catch (Exception e) {
                ++failCount;
                this.log.error("ExpressBlackListRunnable run error,param =>{},error=>{}", (Object)JSON.toJSONString((Object)param), (Object)e.getMessage());
            }
            finally {
                this.ops.increment((Object)"successCount", 1L);
            }
        }
        this.ops.increment((Object)"failCount", (long)failCount);
        this.ops.increment((Object)"taskCount", -1L);
    }

    public void setProgressKey(String progressKey) {
        this.ops = this.redisTemplate.boundHashOps((Object)progressKey);
    }

    public void setParams(List<ExpressBlackListOperationParams> params) {
        this.params = params;
    }

    public Integer enableFilter() {
        ArrayList newList = Lists.newArrayList();
        for (ExpressBlackListOperationParams param : this.params) {
            if (StringUtils.isBlank((String)param.getBkValue())) continue;
            newList.add(param);
        }
        this.params.clear();
        this.params.addAll(newList);
        return newList.size();
    }

    static {
        map.put(ExpressCompanyEnum.YTO, QueryBlackListTypeEnum.EXPRESS_COMPANY);
        map.put(ExpressCompanyEnum.YTO_PAID, QueryBlackListTypeEnum.EXPRESS_COMPANY_PUTO);
    }
}

