/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.biz.service.LogisticsOrderService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class LogisticsOrderSignRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(LogisticsOrderSignRunnable.class);
    @Autowired
    private LogisticsOrderService logisticsOrderService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private List<LogisticsOrderDto> params = Lists.newArrayList();
    private BoundHashOperations<String, String, Object> ops;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long failCount = 0L;
        try {
            for (LogisticsOrderDto param : this.params) {
                try {
                    Integer result = this.logisticsOrderService.update(param);
                    if (result == 1) continue;
                    ++failCount;
                }
                catch (Exception e) {
                    ++failCount;
                    this.logger.error("\u7269\u6d41\u8ba2\u5355\u7b7e\u6536\u6279\u91cf\u5931\u8d25", (Throwable)e);
                }
                finally {
                    this.ops.increment((Object)"successCount", 1L);
                }
            }
        }
        finally {
            this.ops.increment((Object)"failCount", failCount);
            this.ops.increment((Object)"taskCount", -1L);
        }
    }

    public void setProgressKey(String progressKey) {
        this.ops = this.redisTemplate.boundHashOps((Object)progressKey);
    }

    public void setParams(List<LogisticsOrderDto> params) {
        this.params.addAll(params);
    }

    public Integer enableFilter() {
        ArrayList newList = Lists.newArrayList();
        for (LogisticsOrderDto param : this.params) {
            if (StringUtils.isBlank((String)param.getLogisticsName()) || Objects.equal(null, (Object)param.getPostId()) || Objects.equal(null, (Object)ExpressCompanyEnum.getByName((String)param.getLogisticsName())) || StringUtils.isEmpty((String)param.getOrderStatus())) continue;
            param.setLogisticsCode(ExpressCompanyEnum.getByName((String)param.getLogisticsName()).getCode());
            newList.add(param);
        }
        this.params.clear();
        this.params.addAll(newList);
        return newList.size();
    }
}

