/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import com.qiho.center.api.dto.order.DeliveryRecordDto;
import com.qiho.center.api.enums.DeliveryRecordStateEnum;
import com.qiho.center.api.params.OrderFileDeliveryParam;
import com.qiho.center.api.util.BizLog;
import com.qiho.center.biz.bo.ErpOrderBo;
import com.qiho.center.biz.service.order.OrderFileDeliveryService;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.order.DeliveryRecordEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrderFileCancelDeliveryRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderFileCancelDeliveryRunnable.class);
    private final Long recordId;
    private final Long merchantId;
    private final Integer totalCount;
    private final List<OrderFileDeliveryParam> deliveryBeanList;
    @Autowired
    private ErpOrderBo erpOrderBo;
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Resource
    private OrderFileDeliveryService orderFileDeliveryService;

    public OrderFileCancelDeliveryRunnable(DeliveryRecordDto recordDto, List<OrderFileDeliveryParam> deliveryBeanList) {
        this.recordId = recordDto.getId();
        this.merchantId = recordDto.getMerchantId();
        this.totalCount = recordDto.getTotalCount();
        this.deliveryBeanList = deliveryBeanList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (CollectionUtils.isEmpty(this.deliveryBeanList) || Objects.equals(null, this.recordId) || Objects.equals(null, this.merchantId)) {
            BizLog.log((String)"[\u53d6\u6d88\u53d1\u8d27]\u53c2\u6570\u9519\u8bef\uff0c\u6570\u636e\u3001\u4efb\u52a1ID\u3001\u5546\u5bb6ID\u4e3a\u7a7a", (Object[])new Object[0]);
            return;
        }
        if (Objects.equals(null, this.totalCount) || this.totalCount.equals(0)) {
            BizLog.log((String)"[\u53d6\u6d88\u53d1\u8d27]\u53c2\u6570\u9519\u8bef\uff0c\u603b\u6761\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
            return;
        }
        int failedCount = 0;
        int succeedCount = 0;
        HashSet<Integer> failIds = new HashSet<Integer>();
        try {
            for (OrderFileDeliveryParam bean : this.deliveryBeanList) {
                try {
                    boolean checkFlag = this.checkParam(bean);
                    if (!checkFlag) {
                        ++failedCount;
                        failIds.add(bean.getRowNumber());
                        continue;
                    }
                    this.erpOrderBo.cancelDeliver(bean.getErpId());
                    ++succeedCount;
                    BizLog.log((String)"[\u53d6\u6d88\u53d1\u8d27]\u6210\u529f. {}, recordId:{}, merchantId:{}, {}", (Object[])new Object[]{Thread.currentThread().getName(), this.recordId, this.merchantId, bean});
                }
                catch (Exception e) {
                    ++failedCount;
                    failIds.add(bean.getRowNumber());
                    LOGGER.error("[\u53d6\u6d88\u53d1\u8d27]\u5931\u8d25. {}, recordId:{}, merchantId:{}, {}", new Object[]{Thread.currentThread().getName(), this.recordId, this.merchantId, bean, e});
                }
            }
        }
        finally {
            this.completeHandler(failedCount, succeedCount, failIds);
        }
    }

    public boolean checkParam(OrderFileDeliveryParam bean) {
        if (StringUtils.isBlank((CharSequence)bean.getErpId()) || Objects.isNull(bean.getRowNumber())) {
            BizLog.log((String)"[\u53d6\u6d88\u53d1\u8d27]\u5931\u8d25\uff0c\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Object[])new Object[0]);
            return false;
        }
        if (!this.isMerchantByOrderId(bean.getErpId(), String.valueOf(this.merchantId))) {
            BizLog.log((String)"[\u53d6\u6d88\u53d1\u8d27]\u8ba2\u5355\u4e0e\u5546\u5bb6\u4e0d\u5bf9\u5e94\uff0cerpId:{}, merchantId:{}", (Object[])new Object[]{bean.getErpId(), this.merchantId});
            return false;
        }
        return true;
    }

    private boolean isMerchantByOrderId(String erpId, String merchantId) {
        QihoErpOrderEntity erpOrderEntity = this.qihoErpOrderDAO.findByErpId(erpId);
        if (Objects.isNull(erpOrderEntity) || Objects.isNull(erpOrderEntity.getOrderId())) {
            return Boolean.FALSE;
        }
        QihoOrderSnapshotEntity entity = this.qihoOrderSnapshotDAO.findByOrderId(erpOrderEntity.getOrderId());
        if (null == entity) {
            return Boolean.FALSE;
        }
        if (!StringUtils.equals((CharSequence)String.valueOf(entity.getMerchantId()), (CharSequence)merchantId)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void completeHandler(int failedCount, int succeedCount, Set<Integer> failIds) {
        DeliveryRecordEntity entity = new DeliveryRecordEntity();
        entity.setId(this.recordId);
        entity.setFailedCount(Integer.valueOf(failedCount));
        entity.setSucceedCount(Integer.valueOf(succeedCount));
        entity.setUpdatedCount(Integer.valueOf(0));
        entity.setRemark(this.getCancelFailMsg(failIds));
        entity.setState(DeliveryRecordStateEnum.COMPLETE.getCode());
        if (!this.orderFileDeliveryService.updateByIdSelective(entity).booleanValue()) {
            LOGGER.error("[\u53d6\u6d88\u53d1\u8d27]\u6279\u91cf\u4e0a\u4f20\u53d1\u7269\u6d41\u5355\u53f7-\u66f4\u65b0\u6570\u636e\u5931\u8d25, id:{}", (Object)entity.getId());
        }
    }

    private String getCancelFailMsg(Set<Integer> failIds) {
        String failMsg = StringUtils.join(failIds.iterator(), (String)",");
        if (2040 < failMsg.length()) {
            failMsg = failMsg.substring(0, 2040) + "......";
        }
        return failMsg;
    }
}

