/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.order.DeliveryRecordDto;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderBatchDeliveryEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.OrderFileDeliveryParam;
import com.qiho.center.api.util.BizLog;
import com.qiho.center.biz.bo.ExpressBo;
import com.qiho.center.biz.bo.KuaiDi100Bo;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.job.OrderFileDeliveryJob;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.order.ErpOrderService;
import com.qiho.center.biz.service.order.OrderFileDeliveryService;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.daoh.qiho.order.DeliveryRecordMapper;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.order.DeliveryRecordEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.SequenceNoBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class OrderFileConfirmDeliveryRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderFileConfirmDeliveryRunnable.class);
    private static final String NUM_AND_LETTER_REG_EX = "^[A-Za-z0-9]{1,40}$";
    private final Long recordId;
    private final Long merchantId;
    private final Integer totalCount;
    private final String logisticsCode;
    private final String logisticsName;
    private final CountDownLatch countDownLatch;
    private final List<OrderFileDeliveryParam> deliveryBeanList;
    private final OrderFileDeliveryJob orderFileDeliveryJob;
    @Autowired
    private SequenceNoBuilder builder;
    @Autowired
    private KuaiDi100Bo kuaiDi100Bo;
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    @Autowired
    private ErpOrderService erpOrderService;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;
    @Autowired
    private LogisticsOrderService logisticsOrderService;
    @Resource
    private ExpressBo expressBo;
    @Resource
    private OrderFileDeliveryService orderFileDeliveryService;
    @Resource
    private DeliveryRecordMapper deliveryRecordMapper;
    private final ThreadLocal<List<LogisticsOrderEntity>> logisticsOrderEntityListLocal = new ThreadLocal(){

        protected List<LogisticsOrderEntity> initialValue() {
            return new ArrayList<LogisticsOrderEntity>();
        }
    };

    public OrderFileConfirmDeliveryRunnable(OrderFileDeliveryJob job, DeliveryRecordDto recordDto, String logisticsName, CountDownLatch countDownLatch, List<OrderFileDeliveryParam> deliveryBeanList) {
        this.orderFileDeliveryJob = job;
        this.countDownLatch = countDownLatch;
        this.recordId = recordDto.getId();
        this.merchantId = recordDto.getMerchantId();
        this.totalCount = recordDto.getTotalCount();
        this.logisticsCode = recordDto.getLogisticsCode();
        this.logisticsName = logisticsName;
        this.deliveryBeanList = deliveryBeanList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.checkCommonParam()) {
            return;
        }
        int failedCount = 0;
        int updatedCount = 0;
        int succeedCount = 0;
        try {
            for (OrderFileDeliveryParam bean : this.deliveryBeanList) {
                try {
                    boolean checkFlag = this.checkParam(bean);
                    if (!checkFlag) {
                        ++failedCount;
                        this.orderFileDeliveryJob.setConfirmFailId(bean.getRowNumber());
                        continue;
                    }
                    OrderBatchDeliveryEnum result = this.auditOrder(bean);
                    if (OrderBatchDeliveryEnum.UPDATED == result) {
                        ++updatedCount;
                    } else if (OrderBatchDeliveryEnum.SUCCEED == result) {
                        ++succeedCount;
                    } else if (OrderBatchDeliveryEnum.FAILED == result) {
                        ++failedCount;
                        this.orderFileDeliveryJob.setConfirmFailId(bean.getRowNumber());
                    }
                    BizLog.log((String)"[\u786e\u8ba4\u53d1\u8d27] {} recordId:{}, merchantId:{}, result:{}, {}", (Object[])new Object[]{Thread.currentThread().getName(), this.recordId, this.merchantId, result.getName(), bean});
                }
                catch (Exception e) {
                    ++failedCount;
                    this.orderFileDeliveryJob.setConfirmFailId(bean.getRowNumber());
                    LOGGER.error("[\u786e\u8ba4\u53d1\u8d27]\u9519\u8bef\u3002{}, recordId:{}, merchantId:{}, {}", new Object[]{Thread.currentThread().getName(), this.recordId, this.merchantId, bean, e});
                }
            }
        }
        finally {
            this.orderFileDeliveryJob.setConfirmFailedCount(failedCount);
            this.orderFileDeliveryJob.setConfirmSucceedCount(succeedCount);
            this.orderFileDeliveryJob.setConfirmUpdatedCount(updatedCount);
            this.completeHandler(failedCount, succeedCount, updatedCount);
            try {
                this.expressBo.subscribeExpress(BeanUtils.copyList(this.logisticsOrderEntityListLocal.get(), LogisticsOrderDo.class));
            }
            catch (Exception e) {
                LOGGER.error("[\u786e\u8ba4\u53d1\u8d27]\u8ba2\u9605\u5feb\u9012100\u63a5\u53e3\u9519\u8bef", (Throwable)e);
            }
            this.countDownLatch.countDown();
        }
    }

    public boolean checkCommonParam() {
        if (CollectionUtils.isEmpty(this.deliveryBeanList) || Objects.equals(null, this.recordId) || Objects.equals(null, this.merchantId)) {
            BizLog.log((String)"[\u786e\u8ba4\u53d1\u8d27]\u53c2\u6570\u9519\u8bef\uff0c\u6570\u636e\u3001\u4efb\u52a1ID\u3001\u5546\u5bb6ID\u4e3a\u7a7a", (Object[])new Object[0]);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.logisticsCode) || StringUtils.isBlank((CharSequence)this.logisticsName) || Objects.equals(null, this.totalCount) || this.totalCount.equals(0)) {
            BizLog.log((String)"[\u786e\u8ba4\u53d1\u8d27]\u53c2\u6570\u9519\u8bef\uff0c\u7269\u6d41\u7f16\u7801\u3001\u7269\u6d41\u540d\u79f0\u3001\u603b\u6761\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public boolean checkParam(OrderFileDeliveryParam bean) {
        if (StringUtils.isBlank((CharSequence)bean.getPostId()) || StringUtils.isBlank((CharSequence)bean.getErpId()) || Objects.isNull(bean.getRowNumber())) {
            return false;
        }
        Pattern pattern = Pattern.compile(NUM_AND_LETTER_REG_EX, 2);
        Matcher matcher = pattern.matcher(bean.getPostId().trim());
        return matcher.matches();
    }

    @Transactional(rollbackFor={Exception.class})
    public OrderBatchDeliveryEnum auditOrder(OrderFileDeliveryParam bean) {
        QihoErpOrderEntity erpOrderEntity = this.qihoErpOrderDAO.findByErpId(bean.getErpId());
        if (null == erpOrderEntity) {
            BizLog.log((String)"[\u786e\u8ba4\u53d1\u8d27]\u67e5\u8be2ERP\u8ba2\u5355\u4fe1\u606f, erpId:{}", (Object[])new Object[]{bean.getErpId()});
            return OrderBatchDeliveryEnum.FAILED;
        }
        if (!this.isMerchantByOrderId(erpOrderEntity.getOrderId(), String.valueOf(this.merchantId))) {
            BizLog.log((String)"[\u786e\u8ba4\u53d1\u8d27]\u8ba2\u5355\u4e0e\u5546\u5bb6\u4e0d\u5bf9\u5e94, orderId:{}, merchantId:{}", (Object[])new Object[]{erpOrderEntity.getOrderId(), this.merchantId});
            return OrderBatchDeliveryEnum.FAILED;
        }
        LogisticsOrderEntity logisticsOrderEntity = this.qihoLogisticsOrderDAO.findByErpId(bean.getErpId());
        if (logisticsOrderEntity != null) {
            LogisticsOrderEntity entity = new LogisticsOrderEntity();
            entity.setLogisticsCode(this.logisticsCode);
            entity.setLogisticsName(this.logisticsName);
            entity.setPostId(bean.getPostId());
            entity.setErpId(bean.getErpId());
            if (0 == this.qihoLogisticsOrderDAO.updateLogistics(entity)) {
                throw new QihoException("\u66f4\u65b0\u7269\u6d41\u8868\u548c\u5feb\u7167\u8868\u7684\u4fe1\u606f\u5931\u8d25");
            }
            QihoOrderSnapshotEntity orderSnapshot = new QihoOrderSnapshotEntity();
            orderSnapshot.setLogisticsCode(this.logisticsCode);
            orderSnapshot.setLogisticsName(this.logisticsName);
            orderSnapshot.setPostId(bean.getPostId());
            orderSnapshot.setOrderId(logisticsOrderEntity.getOrderId());
            if (0 == this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot)) {
                throw new QihoException("\u66f4\u65b0\u8ba2\u5355\u5feb\u7167\u4fe1\u606f");
            }
            LogisticsOrderEntity logisticsOrderEntity1 = new LogisticsOrderEntity();
            logisticsOrderEntity1.setLogisticsCode(this.logisticsCode);
            logisticsOrderEntity1.setPostId(bean.getPostId());
            this.logisticsOrderEntityListLocal.get().add(logisticsOrderEntity1);
            return OrderBatchDeliveryEnum.UPDATED;
        }
        LogisticsOrderEntity entity = this.getLogisticsEntity(bean, erpOrderEntity);
        try {
            this.erpOrderService.updateErpStatus(entity.getErpId(), ErpStatusEnum.SUCCESS, ErpStatusEnum.TO_NOTIFY, null);
            this.logisticsOrderService.createLogisticsOrderBatchDelivery(entity);
            LogisticsOrderEntity logisticsOrderEntity1 = new LogisticsOrderEntity();
            logisticsOrderEntity1.setLogisticsCode(this.logisticsCode);
            logisticsOrderEntity1.setPostId(bean.getPostId());
            this.logisticsOrderEntityListLocal.get().add(logisticsOrderEntity1);
        }
        catch (Exception e) {
            throw new QihoException("[\u786e\u8ba4\u53d1\u8d27]\u5904\u7406\u9519\u8bef");
        }
        return OrderBatchDeliveryEnum.SUCCEED;
    }

    private LogisticsOrderEntity getLogisticsEntity(OrderFileDeliveryParam bean, QihoErpOrderEntity erpOrder) {
        LogisticsOrderEntity entity = new LogisticsOrderEntity();
        entity.setErpId(bean.getErpId());
        String postId = bean.getPostId();
        int num = postId.indexOf(44);
        if (num > -1) {
            bean.setPostId(postId.substring(0, num).trim());
        } else {
            entity.setPostId(postId.trim());
        }
        entity.setLogisticsCode(this.logisticsCode);
        entity.setLogisticsName(this.logisticsName);
        entity.setLogisticsStatus(YTOLogisticsStatusEnum.ACCEPT.getDesc());
        entity.setOrderStatus(LogisticsOrderStatusEnum.ACCEPT.getCode());
        entity.setConsumerName(erpOrder.getConsumerName());
        entity.setItemId(erpOrder.getItemId());
        entity.setItemName(erpOrder.getItemName());
        entity.setItemNo(erpOrder.getItemNo());
        entity.setLogisticsId(this.builder.createSeqNo(SeqBizTypeEnum.LOGISTICS, erpOrder.getItemId()));
        entity.setMobile(erpOrder.getMobile());
        entity.setOrderId(erpOrder.getOrderId());
        entity.setSkuNo(erpOrder.getSkuNo());
        entity.setProvince(erpOrder.getProvince());
        return entity;
    }

    private boolean isMerchantByOrderId(String orderId, String merchantId) {
        QihoOrderSnapshotEntity entity = this.qihoOrderSnapshotDAO.findByOrderId(orderId);
        if (null == entity) {
            return Boolean.FALSE;
        }
        if (!StringUtils.equals((CharSequence)String.valueOf(entity.getMerchantId()), (CharSequence)merchantId)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void completeHandler(int failedCount, int succeedCount, int updatedCount) {
        DeliveryRecordEntity recordEntity = this.getRecordEntity(this.recordId);
        DeliveryRecordEntity entity = new DeliveryRecordEntity();
        entity.setId(this.recordId);
        if (null == recordEntity) {
            entity.setFailedCount(Integer.valueOf(failedCount));
            entity.setSucceedCount(Integer.valueOf(succeedCount));
            entity.setUpdatedCount(Integer.valueOf(updatedCount));
        } else {
            entity.setFailedCount(Integer.valueOf(failedCount + recordEntity.getFailedCount()));
            entity.setSucceedCount(Integer.valueOf(succeedCount + recordEntity.getSucceedCount()));
            entity.setUpdatedCount(Integer.valueOf(updatedCount + recordEntity.getUpdatedCount()));
        }
        if (!this.orderFileDeliveryService.updateByIdSelective(entity).booleanValue()) {
            LOGGER.error("[\u786e\u8ba4\u53d1\u8d27]\u66f4\u65b0\u5931\u8d25, id:{}", (Object)entity.getId());
        }
    }

    private DeliveryRecordEntity getRecordEntity(Long id) {
        return this.deliveryRecordMapper.selectById(id);
    }
}

