/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.WdtOrderAuditParams;
import com.qiho.center.biz.bo.ExpressBo;
import com.qiho.center.biz.bo.KuaiDi100Bo;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.order.ErpOrderService;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.dao.QihoItemMerchantDAO;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.SequenceNoBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class WdtAuditOrderRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WdtAuditOrderRunnable.class);
    private static final String NUM_AND_LETTER_REG_EX = "^[A-Za-z0-9]{1,40}$";
    private final List<WdtOrderAuditParams> params = Lists.newArrayList();
    private BoundHashOperations<String, String, String> ops;
    private final ThreadLocal<List<LogisticsOrderEntity>> logisticsOrderEntityListLocal = new ThreadLocal(){

        protected List<LogisticsOrderEntity> initialValue() {
            return new ArrayList<LogisticsOrderEntity>();
        }
    };
    private final ThreadLocal<StringBuffer> failIdsLocal = new ThreadLocal(){

        protected StringBuffer initialValue() {
            return new StringBuffer();
        }
    };
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    @Autowired
    private LogisticsOrderService logisticsOrderService;
    @Autowired
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;
    @Autowired
    private SequenceNoBuilder builder;
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    @Autowired
    private ErpOrderService erpOrderService;
    @Autowired
    private QihoItemMerchantDAO qihoItemMerchantDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private KuaiDi100Bo kuaiDi100Bo;
    @Autowired
    private ExpressBo expressBo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long failCount = 0L;
        long updateCount = 0L;
        long successCount = 0L;
        try {
            int paramsSize = this.params.size();
            String failRowMsg = null;
            WdtOrderAuditParams param = null;
            for (int i = 0; i < paramsSize; ++i) {
                try {
                    param = this.params.get(i);
                    failRowMsg = String.valueOf(param.getRowNum());
                    boolean checkFlag = this.checkParam(param);
                    if (!checkFlag) {
                        ++failCount;
                        this.failIdsLocal.get().append(",").append(failRowMsg);
                        continue;
                    }
                    int result = this.auditOrder(param);
                    if (0 == result) {
                        ++updateCount;
                        continue;
                    }
                    if (1 == result) {
                        ++failCount;
                        this.failIdsLocal.get().append(",").append(failRowMsg);
                        continue;
                    }
                    if (2 != result) continue;
                    ++successCount;
                    continue;
                }
                catch (Exception e) {
                    ++failCount;
                    this.failIdsLocal.get().append(",").append(failRowMsg);
                    LOGGER.error("\u65fa\u5e97\u901a\u8ba2\u5355\u5ba1\u6838\u5931\u8d25", (Throwable)e);
                }
            }
        }
        finally {
            this.updateCacheOps(failCount, updateCount, successCount, this.failIdsLocal.get().toString());
        }
    }

    private void updateCacheOps(long failCount, long updateCount, long successCount, String failIds) {
        this.ops.increment((Object)"failCount", failCount);
        this.ops.increment((Object)"updateCount", updateCount);
        this.ops.increment((Object)"deliveryCount", successCount);
        this.ops.increment((Object)"taskCurrent", 1L);
        String failMsgKey = "failMsg";
        if (StringUtils.isNotBlank((CharSequence)failIds)) {
            String fm = (String)this.ops.get((Object)failMsgKey);
            if (StringUtils.isBlank((CharSequence)fm)) {
                this.ops.put((Object)failMsgKey, (Object)failIds.substring(1));
            } else {
                this.ops.put((Object)failMsgKey, (Object)(fm + "," + failIds.substring(1)));
            }
        }
        int totalCount = Integer.parseInt((String)this.ops.get((Object)"totalCount"));
        int proCount = Integer.parseInt((String)this.ops.get((Object)"deliveryCount")) + Integer.parseInt((String)this.ops.get((Object)"failCount")) + Integer.parseInt((String)this.ops.get((Object)"updateCount"));
        if (proCount >= totalCount) {
            this.ops.put((Object)"success", (Object)"true");
            long endTime = System.currentTimeMillis();
            this.ops.put((Object)"endTime", (Object)String.valueOf(endTime));
            long startTime = Long.parseLong((String)this.ops.get((Object)"startTime"));
            if (endTime - startTime > 1000L) {
                this.ops.put((Object)"useTime", (Object)((endTime - startTime) / 1000L + "\u79d2"));
            } else {
                this.ops.put((Object)"useTime", (Object)(endTime - startTime + "\u6beb\u79d2"));
            }
        }
        try {
            this.expressBo.subscribeExpress(BeanUtils.copyList(this.logisticsOrderEntityListLocal.get(), LogisticsOrderDo.class));
        }
        catch (Exception e) {
            LOGGER.error("\u8ba2\u9605\u5feb\u9012\u63a5\u53e3\u9519\u8bef", (Throwable)e);
        }
    }

    public boolean checkParam(WdtOrderAuditParams param) {
        if (StringUtils.isBlank((CharSequence)param.getPostId()) || StringUtils.isBlank((CharSequence)param.getErpId()) || StringUtils.isBlank((CharSequence)param.getMerchantId())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)param.getLogisticsCode()) || StringUtils.isBlank((CharSequence)param.getLogisticsName())) {
            return false;
        }
        Pattern pat = Pattern.compile(NUM_AND_LETTER_REG_EX, 2);
        Matcher matcher = pat.matcher(param.getPostId().trim());
        boolean rs = matcher.matches();
        if (!rs) {
            return false;
        }
        int count = this.qihoItemMerchantDAO.findErpOrderMerchant(param.getErpId(), param.getMerchantId());
        return count != 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public int auditOrder(WdtOrderAuditParams param) throws QihoException {
        QihoErpOrderEntity erpOrderEntity = this.qihoErpOrderDAO.findByErpId(param.getErpId());
        if (null == erpOrderEntity) {
            LOGGER.warn("\u67e5\u8be2ERP\u8ba2\u5355\u4fe1\u606f,ErpId:{}", (Object)param.getErpId());
            return 1;
        }
        LogisticsOrderEntity logisticsOrderEntity = this.qihoLogisticsOrderDAO.findByErpId(param.getErpId());
        if (logisticsOrderEntity != null) {
            LogisticsOrderEntity entity = new LogisticsOrderEntity();
            entity.setLogisticsCode(param.getLogisticsCode());
            entity.setLogisticsName(param.getLogisticsName());
            entity.setPostId(param.getPostId());
            entity.setErpId(param.getErpId());
            if (0 == this.qihoLogisticsOrderDAO.updateLogistics(entity)) {
                throw new QihoException("\u66f4\u65b0\u7269\u6d41\u8868\u548c\u5feb\u7167\u8868\u7684\u4fe1\u606f\u5931\u8d25");
            }
            QihoOrderSnapshotEntity orderSnapshot = new QihoOrderSnapshotEntity();
            orderSnapshot.setPostId(param.getPostId());
            orderSnapshot.setLogisticsName(param.getLogisticsName());
            orderSnapshot.setLogisticsCode(param.getLogisticsCode());
            orderSnapshot.setOrderId(logisticsOrderEntity.getOrderId());
            if (0 == this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot)) {
                throw new QihoException("\u66f4\u65b0\u8ba2\u5355\u5feb\u7167\u4fe1\u606f");
            }
            LogisticsOrderEntity logisticsOrderEntity1 = new LogisticsOrderEntity();
            logisticsOrderEntity1.setLogisticsCode(param.getLogisticsCode());
            logisticsOrderEntity1.setPostId(param.getPostId());
            this.logisticsOrderEntityListLocal.get().add(logisticsOrderEntity1);
            return 0;
        }
        LogisticsOrderEntity entity = this.getLogisticsEntity(param, erpOrderEntity);
        try {
            this.erpOrderService.updateErpStatus(entity.getErpId(), ErpStatusEnum.SUCCESS, ErpStatusEnum.TO_NOTIFY, null);
            this.logisticsOrderService.createLogisticsOrderBatchDelivery(entity);
            LogisticsOrderEntity logisticsOrderEntity1 = new LogisticsOrderEntity();
            logisticsOrderEntity1.setLogisticsCode(param.getLogisticsCode());
            logisticsOrderEntity1.setPostId(param.getPostId());
            this.logisticsOrderEntityListLocal.get().add(logisticsOrderEntity1);
        }
        catch (Exception e) {
            throw new QihoException("\u786e\u8ba4\u53d1\u8d27\u5904\u7406\u9519\u8bef");
        }
        return 2;
    }

    private LogisticsOrderEntity getLogisticsEntity(WdtOrderAuditParams wdtOrderAuditParam, QihoErpOrderEntity erpOrder) {
        LogisticsOrderEntity entity = new LogisticsOrderEntity();
        entity.setErpId(wdtOrderAuditParam.getErpId());
        String postId = wdtOrderAuditParam.getPostId();
        int num = postId.indexOf(44);
        if (num > -1) {
            wdtOrderAuditParam.setPostId(postId.substring(0, num).trim());
        } else {
            entity.setPostId(postId.trim());
        }
        entity.setLogisticsCode(wdtOrderAuditParam.getLogisticsCode());
        entity.setLogisticsName(wdtOrderAuditParam.getLogisticsName());
        entity.setLogisticsStatus(YTOLogisticsStatusEnum.ACCEPT.getDesc());
        entity.setOrderStatus(LogisticsOrderStatusEnum.ACCEPT.getCode());
        entity.setConsumerName(erpOrder.getConsumerName());
        entity.setItemId(erpOrder.getItemId());
        entity.setItemName(erpOrder.getItemName());
        entity.setItemNo(erpOrder.getItemNo());
        entity.setLogisticsId(this.builder.createSeqNo(SeqBizTypeEnum.LOGISTICS, erpOrder.getItemId()));
        entity.setMobile(erpOrder.getMobile());
        entity.setOrderId(erpOrder.getOrderId());
        entity.setSkuNo(erpOrder.getSkuNo());
        entity.setProvince(erpOrder.getProvince());
        return entity;
    }

    public void setProgressKey(String progressKey) {
        this.ops = this.redisTemplate.boundHashOps((Object)progressKey);
    }

    public void setParams(List<WdtOrderAuditParams> params) {
        this.params.addAll(params);
    }
}

