/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.advert.impl;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.merchant.MerchantAdvertDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.biz.service.advert.BaiqiTuiaAdvertConsumeService;
import com.qiho.center.biz.service.merchant.BaiqiMerchantLinkService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.daoh.qiho.advert.BaiqiTuiaAdvertConsumeMapper;
import com.qiho.center.common.entityd.qiho.advert.BaiqiTuiaAdvertConsumeEntity;
import com.qiho.center.common.entityd.qiho.merchant.BaiqiMerchantLinkEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.joda.time.LocalDate;
import org.springframework.stereotype.Service;

@Service(value="baiqiTuiaAdvertConsumeService")
public class BaiqiTuiaAdvertConsumeServiceImpl
implements BaiqiTuiaAdvertConsumeService {
    @Resource
    private BaiqiTuiaAdvertConsumeMapper baiqiTuiaAdvertConsumeMapper;
    @Resource
    private BaiqiMerchantLinkService baiqiMerchantLinkService;
    @Resource
    private MerchantService merchantService;

    @Override
    public void insert(BaiqiTuiaAdvertConsumeEntity consumeEntity) {
        this.baiqiTuiaAdvertConsumeMapper.insert(consumeEntity);
    }

    @Override
    public List<MerchantAdvertDto> findAdvertConsume(Long merchantId, Date startDate, Date endDate) {
        List<MerchantAdvertDto> dtoList;
        Date start = startDate;
        Date end = endDate;
        if (start == null) {
            start = LocalDate.now().toDate();
        }
        if (end == null) {
            end = LocalDate.now().toDate();
        }
        if (CollectionUtils.isEmpty(dtoList = this.fetchMerchant(merchantId))) {
            return Collections.emptyList();
        }
        List<BaiqiMerchantLinkEntity> linkEntityList = this.baiqiMerchantLinkService.findByTypeWithLinked(BaiqiMerchantLinkTypeEnum.TUI_A);
        if (CollectionUtils.isEmpty(linkEntityList)) {
            return dtoList;
        }
        this.mergeAdvert(dtoList, linkEntityList);
        List<Long> advertIdList = linkEntityList.stream().map(BaiqiMerchantLinkEntity::getRelationId).collect(Collectors.toList());
        this.mergeAdvertConsume(dtoList, advertIdList, start, end);
        return this.sortDtoList(dtoList);
    }

    private List<MerchantAdvertDto> sortDtoList(List<MerchantAdvertDto> dtoList) {
        List<MerchantAdvertDto> frontList = dtoList.stream().filter(e -> e.getAdvertConsume() != null).collect(Collectors.toList());
        List backList = dtoList.stream().filter(e -> e.getAdvertConsume() == null).collect(Collectors.toList());
        frontList.addAll(backList);
        return frontList;
    }

    private void mergeAdvert(List<MerchantAdvertDto> dtoList, List<BaiqiMerchantLinkEntity> linkEntityList) {
        Map merchantIdEntityMap = (Map)linkEntityList.stream().collect(Collectors.toMap(BaiqiMerchantLinkEntity::getMerchantId, Function.identity(), (n, o) -> o, HashedMap::new));
        dtoList.forEach(e -> {
            BaiqiMerchantLinkEntity linkEntity = (BaiqiMerchantLinkEntity)merchantIdEntityMap.get(e.getMerchantId());
            if (linkEntity != null) {
                e.setAdvertId(linkEntity.getRelationId());
                e.setAdvertName(linkEntity.getRelationName());
            }
        });
    }

    private List<MerchantAdvertDto> fetchMerchant(Long merchantId) {
        List<MerchantSimpleDto> allMerchantList = merchantId != null ? this.merchantService.findIdAndNamesByIds(Lists.newArrayList((Object[])new Long[]{merchantId})) : this.merchantService.findAllIdAndNames();
        if (CollectionUtils.isEmpty(allMerchantList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)allMerchantList.size());
        allMerchantList.forEach(e -> {
            MerchantAdvertDto dto = new MerchantAdvertDto();
            dto.setMerchantName(e.getMerchantName());
            dto.setMerchantId(e.getId());
            result.add(dto);
        });
        return result;
    }

    private void mergeAdvertConsume(List<MerchantAdvertDto> result, List<Long> advertIdList, Date startDate, Date endDate) {
        List advertConsumeList = this.baiqiTuiaAdvertConsumeMapper.findAdvertConsume(advertIdList, startDate, endDate);
        if (CollectionUtils.isEmpty((Collection)advertConsumeList)) {
            return;
        }
        Map<Long, List<BaiqiTuiaAdvertConsumeEntity>> advertIdMap = advertConsumeList.stream().collect(Collectors.groupingBy(BaiqiTuiaAdvertConsumeEntity::getAdvertId));
        result.forEach(e -> {
            List consumeList = (List)advertIdMap.get(e.getAdvertId());
            if (CollectionUtils.isNotEmpty((Collection)consumeList)) {
                Long sum = consumeList.stream().mapToLong(BaiqiTuiaAdvertConsumeEntity::getConsumeTotal).sum();
                e.setAdvertConsume(sum);
            }
        });
    }
}

