/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.AbTestSkuDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.params.TestMetadataQueryParam;
import com.qiho.center.biz.service.AbTestSkuService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.ItemSkuService;
import com.qiho.center.biz.service.abtest.TestMetadataService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.daoh.qiho.QihoTestMetadataMapper;
import com.qiho.center.common.daoh.qiho.QihoTestPlanMapper;
import com.qiho.center.common.entity.item.QihoItemDetailEntity;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestMetadataEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AbTestSkuServiceImpl
implements AbTestSkuService {
    @Autowired
    QihoTestMetadataMapper qihoTestMetadataMapper;
    @Autowired
    ItemSkuService itemSkuService;
    @Autowired
    ItemService itemService;
    @Autowired
    QihoTestPlanMapper qihoTestPlanMapper;
    @Autowired
    QihoItemSkuDAO qihoItemSkuDAO;
    @Autowired
    QihoItemDAO qihoItemDAO;
    @Autowired
    TestMetadataService testMetadataService;

    @Override
    public void save(List<ItemSkuDto> list, AbTestSkuDto abTestSkuDto) throws BizException {
        QihoTestMetadataEntity entity = new QihoTestMetadataEntity();
        entity.setId(abTestSkuDto.getId());
        entity.setDataName(abTestSkuDto.getName());
        entity.setDataDesc(abTestSkuDto.getDescription());
        entity.setItemId(abTestSkuDto.getItemId());
        entity.setMetadataKey(MetadataTypeEnum.PRICE.getCode());
        this.testMetadataService.validateInfo(entity);
        JSONArray jsonArray = new JSONArray();
        for (ItemSkuDto itemSkuDto : list) {
            JSONObject object = new JSONObject();
            object.put("skuId", (Object)itemSkuDto.getId());
            object.put("price", (Object)itemSkuDto.getSellingPrice());
            object.put("orgPrice", (Object)itemSkuDto.getOriginalPrice());
            jsonArray.add((Object)object);
        }
        entity.setMetadataValue(jsonArray.toJSONString());
        if (abTestSkuDto.getId() == null) {
            entity.setSkinType(0);
            this.qihoTestMetadataMapper.insert(entity);
        } else {
            this.qihoTestMetadataMapper.update(entity);
        }
    }

    @Override
    public void delete(Long id) throws BizException {
        List list = this.qihoTestPlanMapper.selectValidPlanCountByMetadataId(id);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BizException("\u672c\u8be6\u60c5\u5df2\u88ab\u7528\u4e8e\u6d4b\u8bd5\u65b9\u6848\u3010\u6d4b\u8bd5\u65b9\u6848\u540d\u79f0\u3011\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.qihoTestMetadataMapper.deleteById(id);
    }

    @Override
    public PagenationDto<AbTestSkuDto> queryList(TestMetadataQueryParam testMetadataQueryParam) throws BizException {
        ItemDetailDto detailDto = this.itemService.queryItemDetail(testMetadataQueryParam.getItemId());
        PagenationDto pagenationDto = new PagenationDto();
        if (detailDto == null) {
            throw new BizException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        testMetadataQueryParam.setMetadataKey(MetadataTypeEnum.PRICE.getCode());
        List list = this.qihoTestMetadataMapper.selectListByPage(testMetadataQueryParam);
        ArrayList result = Lists.newArrayList();
        for (QihoTestMetadataEntity qihoTestMetadataEntity : list) {
            AbTestSkuDto abTestSkuDto = new AbTestSkuDto();
            abTestSkuDto.setDescription(qihoTestMetadataEntity.getDataDesc());
            abTestSkuDto.setName(qihoTestMetadataEntity.getDataName());
            abTestSkuDto.setId(qihoTestMetadataEntity.getId());
            abTestSkuDto.setItemId(qihoTestMetadataEntity.getItemId());
            String value = qihoTestMetadataEntity.getMetadataValue();
            List maps = JSONArray.parseArray((String)value, HashMap.class);
            ArrayList skus = Lists.newArrayList();
            this.opsItemSku(maps, skus);
            abTestSkuDto.setSkus((List)skus);
            result.add(abTestSkuDto);
        }
        int count = this.qihoTestMetadataMapper.selectListCountByPage(testMetadataQueryParam);
        pagenationDto.setTotal(Integer.valueOf(count));
        pagenationDto.setList((List)result);
        return pagenationDto;
    }

    private void opsItemSku(List<HashMap> maps, List<ItemSkuDto> skus) {
        for (int i = 0; i < maps.size(); ++i) {
            String skuId = maps.get(i).get("skuId").toString();
            ItemSkuDto dto = this.itemSkuService.querySku(Long.valueOf(skuId));
            if (dto == null) continue;
            String price = maps.get(i).get("price").toString();
            String originalPrice = null;
            if (null != maps.get(i).get("orgPrice")) {
                originalPrice = maps.get(i).get("orgPrice").toString();
                dto.setOriginalPrice(Integer.valueOf(originalPrice));
            }
            dto.setSellingPrice(Integer.valueOf(price));
            skus.add(dto);
        }
    }

    @Override
    public AbTestSkuDto queryDetail(Long id) {
        ItemSkuDto dto;
        AbTestSkuDto result = new AbTestSkuDto();
        QihoTestMetadataEntity qihoTestMetadataEntity = this.qihoTestMetadataMapper.selectById(id);
        if (qihoTestMetadataEntity == null) {
            return null;
        }
        String value = qihoTestMetadataEntity.getMetadataValue();
        ArrayList skus = Lists.newArrayList();
        List list = JSONArray.parseArray((String)value, HashMap.class);
        List<ItemSkuDto> normalSku = this.itemSkuService.getSkuByItemId(qihoTestMetadataEntity.getItemId());
        Map<String, ItemSkuDto> normalMaps = this.toConvert(normalSku);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            for (int i = 0; i < list.size(); ++i) {
                String skuId = ((HashMap)list.get(i)).get("skuId").toString();
                if (normalMaps.containsKey(skuId)) {
                    normalMaps.remove(skuId);
                }
                if ((dto = this.itemSkuService.querySku(Long.valueOf(skuId))) == null) continue;
                String price = ((HashMap)list.get(i)).get("price").toString();
                if (null != ((HashMap)list.get(i)).get("orgPrice")) {
                    String originalPrice = ((HashMap)list.get(i)).get("orgPrice").toString();
                    dto.setOriginalPrice(Integer.valueOf(originalPrice));
                }
                dto.setSellingPrice(Integer.valueOf(price));
                skus.add(dto);
            }
        }
        for (Map.Entry<String, ItemSkuDto> entry : normalMaps.entrySet()) {
            dto = entry.getValue();
            dto.setSellingPrice(null);
            skus.add(dto);
        }
        result.setSkus((List)skus);
        result.setItemId(qihoTestMetadataEntity.getItemId());
        result.setId(qihoTestMetadataEntity.getId());
        result.setName(qihoTestMetadataEntity.getDataName());
        result.setDescription(qihoTestMetadataEntity.getDataDesc());
        return result;
    }

    private Map<String, ItemSkuDto> toConvert(List<ItemSkuDto> normalSku) {
        HashMap<String, ItemSkuDto> itemSkuDtoMap = new HashMap<String, ItemSkuDto>();
        for (ItemSkuDto dto : normalSku) {
            itemSkuDtoMap.put(String.valueOf(dto.getId()), dto);
        }
        return itemSkuDtoMap;
    }

    @Override
    public void syncToItemSku(Long id, Long userId) throws BizException {
        QihoTestMetadataEntity qihoTestMetadataEntity = this.qihoTestMetadataMapper.selectById(id);
        if (null == qihoTestMetadataEntity) {
            throw new BizException("\u540c\u6b65\u5931\u8d25:sku\u7ec4\u4e0d\u5b58\u5728!");
        }
        QihoItemDetailEntity qihoItemDetailEntity = this.qihoItemDAO.findById(qihoTestMetadataEntity.getItemId());
        if (null == qihoItemDetailEntity) {
            throw new BizException("\u540c\u6b65\u5931\u8d25!");
        }
        if (qihoTestMetadataEntity.getIsDelete() == 1) {
            throw new BizException("\u540c\u6b65\u5931\u8d25:sku\u7ec4\u4e0d\u5b58\u5728!");
        }
        String value = qihoTestMetadataEntity.getMetadataValue();
        List maps = JSONArray.parseArray((String)value, HashMap.class);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < maps.size(); ++i) {
            String skuId = ((HashMap)maps.get(i)).get("skuId").toString();
            String price = ((HashMap)maps.get(i)).get("price").toString();
            QihoItemSkuEntity dto = new QihoItemSkuEntity();
            dto.setId(Long.valueOf(skuId));
            dto.setSellingPrice(Integer.valueOf(price));
            if (null != ((HashMap)maps.get(i)).get("orgPrice")) {
                String originalPrice = ((HashMap)maps.get(i)).get("orgPrice").toString();
                dto.setOriginalPrice(Integer.valueOf(originalPrice));
            }
            list.add(dto);
        }
        List<ItemSkuDto> itemSkuDtos = this.itemSkuService.getSkuByItemId(qihoTestMetadataEntity.getItemId());
        if (maps.size() != itemSkuDtos.size()) {
            throw new BizException("\u540c\u6b65\u5931\u8d25:\u6b63\u5e38sku\u6709\u53d8\u66f4!");
        }
        QihoItemEntity itemEntity = new QihoItemEntity();
        itemEntity.setId(qihoTestMetadataEntity.getItemId());
        itemEntity.setGmtModifier(userId);
        itemEntity.setGmtModified(new Date());
        this.qihoItemDAO.update(itemEntity);
        this.qihoItemSkuDAO.updateBatch((List)list);
    }
}

