/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.BannerDto;
import com.qiho.center.api.enums.BannerTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.service.BannerService;
import com.qiho.center.common.dao.QihoBannerDAO;
import com.qiho.center.common.entity.item.QihoBannerEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BannerServiceImpl
implements BannerService {
    @Autowired
    private QihoBannerDAO qihoBannerDAO;

    @Override
    public BannerDto findById(Long id) {
        QihoBannerEntity entity = this.qihoBannerDAO.findById(id);
        if (entity == null) {
            return new BannerDto();
        }
        BannerDto banner = (BannerDto)BeanUtils.copy((Object)entity, BannerDto.class);
        banner.setBannerType(BannerTypeEnum.getByCode((String)entity.getBannerType()));
        return banner;
    }

    @Override
    public List<BannerDto> findAllBanners(String bannerType) {
        BannerTypeEnum bannerTypeEnum = BannerTypeEnum.getByCode((String)bannerType);
        if (bannerTypeEnum == null) {
            throw new QihoException("\u4f20\u5165\u7684Banner\u7c7b\u578b\u9519\u8bef");
        }
        List entityList = this.qihoBannerDAO.findAllBanners(bannerType);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Lists.newArrayList();
        }
        return this.listTransform(entityList, bannerTypeEnum);
    }

    @Override
    public List<BannerDto> findValidBanners(String bannerType) {
        BannerTypeEnum bannerTypeEnum = BannerTypeEnum.getByCode((String)bannerType);
        if (bannerTypeEnum == null) {
            throw new QihoException("\u4f20\u5165\u7684Banner\u7c7b\u578b\u9519\u8bef");
        }
        List entityList = this.qihoBannerDAO.findValidBanners(bannerType);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Lists.newArrayList();
        }
        return this.listTransform(entityList, bannerTypeEnum);
    }

    private List<BannerDto> listTransform(List<QihoBannerEntity> entityList, BannerTypeEnum bannerTypeEnum) {
        return Lists.transform(entityList, entity -> {
            BannerDto dto = (BannerDto)BeanUtils.copy((Object)entity, BannerDto.class);
            dto.setBannerType(bannerTypeEnum);
            return dto;
        });
    }

    @Override
    public int saveBanner(BannerDto dto) {
        QihoBannerEntity entity = (QihoBannerEntity)BeanUtils.copy((Object)dto, QihoBannerEntity.class);
        entity.setBannerType(dto.getBannerType().getCode());
        int result = dto.getId() == null ? this.qihoBannerDAO.createBanner(entity) : this.qihoBannerDAO.updateBanner(entity);
        return result;
    }

    @Override
    public int deleteBanner(Long id) {
        return this.qihoBannerDAO.deleteBanner(id);
    }

    @Override
    public int sortBanner(String idList) {
        List ids = Arrays.asList(idList.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        if (ids.size() != this.qihoBannerDAO.countBanner(BannerTypeEnum.CAROUSEL.getCode())) {
            throw new QihoException("\u4f20\u5165Id\u6570\u4e0eBanner\u6570\u4e0d\u4e00\u81f4");
        }
        List entityList = this.qihoBannerDAO.findAllBanners(BannerTypeEnum.CAROUSEL.getCode());
        int index = 0;
        for (Long id : ids) {
            ((QihoBannerEntity)entityList.get(index)).setId(id);
            ((QihoBannerEntity)entityList.get(index)).setPayload(Integer.valueOf(ids.size() - index));
            ++index;
        }
        return this.qihoBannerDAO.updatePayloadBatch(entityList);
    }

    @Override
    public int countBanner(String bannerType) {
        return this.qihoBannerDAO.countBanner(bannerType);
    }

    @Override
    public int findMaxPayload() {
        Integer maxPayload = this.qihoBannerDAO.findMaxPayload();
        if (null == maxPayload) {
            return 0;
        }
        return maxPayload;
    }
}

