/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.enums.BaseStatusEmun;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.api.params.ConfigParams;
import com.qiho.center.biz.service.ConfigService;
import com.qiho.center.common.dao.QihoConfigDAO;
import com.qiho.center.common.entity.QihoConfigEntity;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ConfigServiceImpl
implements ConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigServiceImpl.class);
    @Autowired
    private QihoConfigDAO qihoConfigDAO;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private static final String QIHO_CONFIG_REDIS_PREFIX = "QIHO_CONFIG_";

    @Override
    public int saveConfig(ConfigParams param) {
        QihoConfigEntity entity = new QihoConfigEntity();
        entity.setConfigName(param.getConfigName());
        entity.setConfigValue(param.getConfigValue());
        entity.setDeleted(param.getDeleted());
        if (param.getId() == null) {
            return this.qihoConfigDAO.insert(entity);
        }
        entity.setId(param.getId());
        entity.setGmtModified(param.getGmtModified());
        return this.qihoConfigDAO.update(entity);
    }

    @Override
    public QihoConfigEntity findConfigByName(String name) {
        return this.qihoConfigDAO.findConfigByName(name);
    }

    @Override
    public ResultDto<Boolean> insertOrUpdateConfig(ConfigParams params) {
        String configName = params.getConfigName();
        String configValue = params.getConfigValue();
        if (StringUtils.isBlank((CharSequence)configName) || StringUtils.isBlank((CharSequence)configValue)) {
            return ResultDto.failResult((String)"\u914d\u7f6e\u9879\u540d\u79f0\u6216\u914d\u7f6e\u9879\u6570\u636e\u4e3a\u7a7a");
        }
        QihoConfigEntity entity = new QihoConfigEntity();
        entity.setConfigName(configName.trim());
        entity.setConfigValue(configValue.trim());
        entity.setDeleted(Boolean.valueOf(BaseStatusEmun.ENABLED.isStatus()));
        QihoConfigEntity currentConfig = this.qihoConfigDAO.findConfigByName(configName.trim());
        if (currentConfig == null) {
            this.qihoConfigDAO.insert(entity);
        } else {
            this.qihoConfigDAO.updateByName(entity);
        }
        return ResultDto.successResult();
    }

    @Override
    public String findByName(String name) {
        String configValue = (String)this.redisTemplate.opsForValue().get((Object)(QIHO_CONFIG_REDIS_PREFIX + name));
        if (StringUtils.isBlank((CharSequence)configValue) && StringUtils.isNotBlank((CharSequence)(configValue = this.qihoConfigDAO.findByName(name)))) {
            this.redisTemplate.opsForValue().set((Object)(QIHO_CONFIG_REDIS_PREFIX + name), (Object)configValue, 1L, TimeUnit.MINUTES);
        }
        return configValue;
    }

    @Override
    public int updateByName(ConfigParams param) {
        QihoConfigEntity entity = new QihoConfigEntity();
        entity.setConfigName(param.getConfigName());
        entity.setConfigValue(param.getConfigValue());
        entity.setDeleted(param.getDeleted());
        int update = this.qihoConfigDAO.updateByName(entity);
        this.redisTemplate.opsForValue().set((Object)(QIHO_CONFIG_REDIS_PREFIX + param.getConfigName()), (Object)param.getConfigValue(), 1L, TimeUnit.MINUTES);
        return update;
    }

    @Override
    public ErpManufacturerType findErpSwitchesType() {
        String erpSwitchConfig = this.findByName("ERP_MANUFACTURER_TYPE");
        if (null == (erpSwitchConfig = StringUtils.trimToNull((String)erpSwitchConfig))) {
            return ErpManufacturerType.EDB;
        }
        ErpManufacturerType manufacturerType = ErpManufacturerType.getErpTypeByCode((String)erpSwitchConfig.toUpperCase());
        if (null == manufacturerType) {
            LOGGER.error("EPR \u5f00\u5173\u914d\u7f6eerror,\u8bf7\u53ca\u65f6\u68c0\u67e5,\u5f00\u5173\u5df2\u5207\u6210\u9ed8\u8ba4\u6a21\u5f0f,{}", (Object)ErpManufacturerType.EDB.getDesc());
            return ErpManufacturerType.EDB;
        }
        return manufacturerType;
    }
}

