/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.biz.service.ItemDetailRecordService;
import com.qiho.center.common.daoh.qiho.QihoItemDetailRecordMapper;
import com.qiho.center.common.daoh.qiho.QihoTestPlanDetailMapper;
import com.qiho.center.common.entityd.qiho.QihoItemDetailRecordEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ItemDetailRecordServiceImpl
implements ItemDetailRecordService {
    @Resource
    QihoTestPlanDetailMapper qihoTestPlanDetailMapper;
    @Resource
    QihoItemDetailRecordMapper qihoItemDetailRecordMapper;

    @Override
    public Long getDetailRecordId(Long itemId, String planCode) {
        HashMap map = Maps.newHashMap();
        map.put("itemId", itemId);
        if (StringUtils.isBlank((String)planCode)) {
            map.put("sourceType", 1);
        } else {
            map.put("sourceType", 2);
            List detailEntityList = this.qihoTestPlanDetailMapper.selectListByCode(planCode);
            detailEntityList.stream().forEach(detail -> {
                if (detail.getMetadataKey().equals(MetadataTypeEnum.DETAIL.getCode())) {
                    map.put("sourceId", detail.getMetadataId());
                }
            });
        }
        QihoItemDetailRecordEntity entity = this.qihoItemDetailRecordMapper.selectByField((Map)map);
        return null != entity ? entity.getId() : null;
    }

    @Override
    public int addDetailRecord(QihoItemDetailRecordEntity entity) {
        return this.qihoItemDetailRecordMapper.insert(entity);
    }

    @Override
    public QihoItemDetailRecordEntity selectById(Long id) {
        return this.qihoItemDetailRecordMapper.selectById(id);
    }
}

