/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.biz.service.ItemDaySaleService;
import com.qiho.center.biz.service.ItemSaleCountService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Service;

@Service
public class ItemSaleCountServiceImpl
implements ItemSaleCountService {
    @Resource(name="stringRedisTemplate")
    private HashOperations<String, String, String> ops;
    @Resource
    private OrderSnapshotService orderSnapshotService;
    @Resource
    private ItemDaySaleService itemDaySaleService;
    public static final String ITEM_SALE_NUM_COUNT = "QIHO_ITEM_SALENUM";

    @Override
    public void syncItemHistorySaleNum() {
        Date endTime = DateUtils.getStartTime((Date)new Date());
        Map<Long, Integer> map = this.orderSnapshotService.queryItemSaleCountBatch(Lists.newArrayList(), null, endTime);
        if (null == map) {
            return;
        }
        for (Map.Entry<Long, Integer> t : map.entrySet()) {
            this.ops.put((Object)ITEM_SALE_NUM_COUNT, (Object)(t.getKey() + ""), (Object)(t.getValue() + ""));
        }
        this.ops.getOperations().expireAt((Object)ITEM_SALE_NUM_COUNT, DateUtils.getEndTime((Date)new Date()));
    }

    @Override
    public void newSyncItemHistorySaleNum() {
        Date endTime;
        ArrayList itemIdList = Lists.newArrayList();
        Map<Long, Long> map = this.itemDaySaleService.queryItemSaleCountBatch(itemIdList, null, endTime = DateUtils.getStartTime((Date)new Date()));
        if (null == map) {
            return;
        }
        for (Map.Entry<Long, Long> t : map.entrySet()) {
            this.ops.put((Object)ITEM_SALE_NUM_COUNT, (Object)(t.getKey() + ""), (Object)(t.getValue() + ""));
        }
        this.ops.getOperations().expireAt((Object)ITEM_SALE_NUM_COUNT, DateUtils.getEndTime((Date)new Date()));
    }

    @Override
    public Map<Long, Integer> queryItemSaleNum(List<Long> itemIdList) {
        HashMap hisStoryMap = Maps.newHashMap();
        Map history = this.ops.entries((Object)ITEM_SALE_NUM_COUNT);
        itemIdList.stream().forEach(itemId -> {
            Integer historyNum;
            String itemIdStr = itemId.toString();
            String result = (String)history.get(itemIdStr);
            Integer n = historyNum = StringUtils.isBlank((String)result) ? null : Integer.valueOf(result);
            if (null == historyNum) {
                historyNum = this.orderSnapshotService.queryItemSaleCount((Long)itemId, null, DateUtils.getStartTime((Date)new Date()));
                this.ops.put((Object)ITEM_SALE_NUM_COUNT, (Object)itemIdStr, (Object)historyNum.toString());
                this.ops.getOperations().expireAt((Object)ITEM_SALE_NUM_COUNT, DateUtils.getEndTime((Date)new Date()));
            }
            hisStoryMap.put(itemId, historyNum);
        });
        Map<Long, Integer> map = this.orderSnapshotService.queryItemSaleCountBatch(itemIdList, DateUtils.getStartTime((Date)new Date()), null);
        for (Map.Entry<Long, Integer> t : map.entrySet()) {
            map.put(t.getKey(), t.getValue() + (Integer)hisStoryMap.get(t.getKey()));
        }
        return map;
    }

    public static void main(String[] args) {
        Date endTime = DateUtils.getStartTime((Date)new Date());
        System.err.println(DateFormatUtils.format((Date)endTime, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
    }
}

