/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.MainItemDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.service.ItemSaleCountService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.MainItemService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.daoh.qiho.QihoMainItemMapper;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.entityd.qiho.QihoMainItemEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.javatuples.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MainItemServiceImpl
implements MainItemService {
    @Resource
    QihoMainItemMapper qihoMainItemMapper;
    @Resource
    QihoItemSkuDAO qihoItemSkuDAO;
    @Resource
    RemoteStockService remoteStockService;
    @Resource
    private ItemService itemService;
    @Autowired
    OrderSnapshotService orderSnapshotService;
    @Autowired
    ItemSaleCountService itemSaleCountService;

    @Override
    public int addMainItem(MainItemDto mainItemDto) {
        QihoMainItemEntity mainItemEntity = (QihoMainItemEntity)BeanUtils.copy((Object)mainItemDto, QihoMainItemEntity.class);
        int records = this.qihoMainItemMapper.selectByItemId(mainItemEntity);
        if (records > 0) {
            throw new QihoException("\u8be5\u5546\u54c1\u4e3b\u63a8\u5df2\u5b58\u5728!");
        }
        ItemSimpleDto itemSimpleDto = this.itemService.queryItemSimpleDto(mainItemDto.getItemId());
        if (itemSimpleDto == null) {
            throw new QihoException("\u8be5\u5546\u54c1\u4e0d\u5b58\u5728!");
        }
        int payload = this.qihoMainItemMapper.findMaxPlayload();
        mainItemEntity.setPayload(Integer.valueOf(payload + 1));
        return this.qihoMainItemMapper.insert(mainItemEntity);
    }

    @Override
    public int deleteMainItems(List<Long> ids) {
        return this.qihoMainItemMapper.deleteByPrimaryKeys(ids);
    }

    @Override
    public int editMainItem(MainItemDto mainItemDto) {
        QihoMainItemEntity mainItemEntiy = (QihoMainItemEntity)BeanUtils.copy((Object)mainItemDto, QihoMainItemEntity.class);
        return this.qihoMainItemMapper.updateByPrimaryKeySelective(mainItemEntiy);
    }

    @Override
    public MainItemDto queryMainItem(Long id) {
        QihoMainItemEntity mainItemEntiy = this.qihoMainItemMapper.selectByPrimaryKey(id);
        return (MainItemDto)BeanUtils.copy((Object)mainItemEntiy, MainItemDto.class);
    }

    @Override
    public PagenationDto<MainItemDto> queryMainItems() {
        PagenationDto pagenation = new PagenationDto();
        List list = this.qihoMainItemMapper.queryByParam();
        if (!list.isEmpty()) {
            this.countSkuStock(list);
            pagenation.setList(this.convertToMainItemDto(list));
        } else {
            pagenation.setList((List)Lists.newArrayList());
        }
        return pagenation;
    }

    @Override
    public void sortMainItem(Long mainIitemId, Integer originPayload, Integer newPayload) {
        if (originPayload == newPayload) {
            return;
        }
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        if (originPayload > newPayload) {
            param.put("biggerPayload", originPayload);
            param.put("samllerPayload", newPayload);
        } else {
            param.put("biggerPayload", newPayload);
            param.put("samllerPayload", originPayload);
        }
        List entityList = this.qihoMainItemMapper.selectBetweenPayload(param);
        QihoMainItemEntity entity = new QihoMainItemEntity();
        entity.setId(mainIitemId);
        entity.setPayload(newPayload);
        this.qihoMainItemMapper.updatePayloadById(entity);
        ArrayList idList = Lists.newArrayList();
        for (QihoMainItemEntity mainItem : entityList) {
            if (mainItem.getId() == mainIitemId) continue;
            idList.add(mainItem.getId());
        }
        int offset = originPayload > newPayload ? 1 : -1;
        HashMap<String, Serializable> updateParam = new HashMap<String, Serializable>();
        updateParam.put("idList", idList);
        updateParam.put("offset", Integer.valueOf(offset));
        this.qihoMainItemMapper.updatePayloadBatch(updateParam);
    }

    @Override
    public PagenationDto<MainItemDto> queryVaildList() {
        PagenationDto pagenation = new PagenationDto();
        List list = this.qihoMainItemMapper.queryVaildList();
        if (!list.isEmpty()) {
            this.countSkuStock(list);
            this.vaildStock(list);
            pagenation.setList(this.convertToMainItemDto(list));
        } else {
            pagenation.setList((List)Lists.newArrayList());
        }
        return pagenation;
    }

    private void vaildStock(List<QihoMainItemEntity> list) {
        Iterator<QihoMainItemEntity> it = list.iterator();
        while (it.hasNext()) {
            QihoMainItemEntity entity = it.next();
            if (entity.getStock() != 0L) continue;
            it.remove();
        }
    }

    private void countSkuStock(List<QihoMainItemEntity> list) {
        ArrayList idList = Lists.newArrayList();
        for (QihoMainItemEntity qihoMainItemEntity : list) {
            idList.add(qihoMainItemEntity.getItemId());
        }
        List skuList = this.qihoItemSkuDAO.getSkuByItemIds((List)idList);
        ArrayList stockIds = Lists.newArrayList();
        for (QihoItemSkuEntity skuEntity : skuList) {
            stockIds.add(skuEntity.getStockId());
        }
        Map stockMap = (Map)this.remoteStockService.findBatch((List)stockIds).getResult();
        Pair<Map, Map> stockPair = this.getSkuStockInfo(stockMap, skuList);
        Map enableStock = (Map)stockPair.getValue1();
        Pair<Map, Map> pricePair = this.getSkuPriceInfo(skuList);
        Map minPriceMap = (Map)pricePair.getValue0();
        Iterator<QihoMainItemEntity> it = list.iterator();
        Map<Long, Integer> batchMap = this.itemSaleCountService.queryItemSaleNum(idList);
        while (it.hasNext()) {
            QihoMainItemEntity mainItemEntiy = it.next();
            Long stock = (Long)enableStock.get(mainItemEntiy.getItemId());
            Integer minPrice = (Integer)minPriceMap.get(mainItemEntiy.getItemId());
            mainItemEntiy.setStock(Long.valueOf(stock == null ? 0L : stock));
            mainItemEntiy.setSaleNumStr(batchMap.get(mainItemEntiy.getItemId()));
            mainItemEntiy.setMinPrice(minPrice);
        }
    }

    private List<MainItemDto> convertToMainItemDto(List<QihoMainItemEntity> list) {
        ArrayList result = Lists.newArrayList();
        for (QihoMainItemEntity qihoMainItemEntity : list) {
            MainItemDto mainItemDto = (MainItemDto)BeanUtils.copy((Object)qihoMainItemEntity, MainItemDto.class);
            result.add(mainItemDto);
        }
        return result;
    }

    private Pair<Map, Map> getSkuPriceInfo(List<QihoItemSkuEntity> skuList) {
        HashMap minPriceMap = Maps.newHashMap();
        HashMap minOriginalPriceMap = Maps.newHashMap();
        for (QihoItemSkuEntity skuEntity : skuList) {
            Long itemId = skuEntity.getItemId();
            Integer minPrice = (Integer)minPriceMap.get(itemId);
            Integer sellingPrice = skuEntity.getSellingPrice() == null ? 0 : skuEntity.getSellingPrice();
            minPriceMap.put(itemId, minPrice == null ? sellingPrice : Math.min(minPrice, sellingPrice));
            Integer minOriginalPrice = (Integer)minOriginalPriceMap.get(itemId);
            Integer originalPrice = skuEntity.getOriginalPrice() == null ? 0 : skuEntity.getOriginalPrice();
            minOriginalPriceMap.put(itemId, minOriginalPrice == null ? originalPrice : Math.min(minOriginalPrice, originalPrice));
        }
        return Pair.with((Object)minPriceMap, (Object)minOriginalPriceMap);
    }

    private Pair<Map, Map> getSkuStockInfo(Map<Long, Long> stockMap, List<QihoItemSkuEntity> skuList) {
        HashMap itemStockMap = Maps.newHashMap();
        HashMap itemEnableStockMap = Maps.newHashMap();
        for (QihoItemSkuEntity skuEntity : skuList) {
            Long itemStock;
            Long itemId;
            Long stock = stockMap.get(skuEntity.getStockId());
            if (stock == null || stock <= 0L) {
                stock = 0L;
            }
            itemStockMap.put(itemId, (itemStock = (Long)itemStockMap.get(itemId = skuEntity.getItemId())) == null ? stock : itemStock + stock);
            if (!skuEntity.getSkuEnable().booleanValue()) continue;
            Long itemEnableStock = (Long)itemEnableStockMap.get(itemId);
            itemEnableStockMap.put(itemId, itemEnableStock == null ? stock : itemEnableStock + stock);
        }
        return Pair.with((Object)itemStockMap, (Object)itemEnableStockMap);
    }
}

