/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaWhiteListDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.MediaWhiteListQueryParam;
import com.qiho.center.biz.service.MediaWhiteListService;
import com.qiho.center.biz.service.order.ChannelInfoService;
import com.qiho.center.common.dao.QihoMediaWhiteListDAO;
import com.qiho.center.common.entity.campaign.QihoMediaWhiteListEntity;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MediaWhiteListServiceImpl
implements MediaWhiteListService {
    @Resource
    private QihoMediaWhiteListDAO qihoMediaWhiteListDAO;
    @Resource
    private ChannelInfoService channelInfoService;

    @Override
    public Long saveOrUpdateWhiteList(MediaWhiteListDto whiteListDto) {
        QihoMediaWhiteListEntity entity = (QihoMediaWhiteListEntity)BeanUtils.copy((Object)whiteListDto, QihoMediaWhiteListEntity.class);
        entity.setIsDeleted(Integer.valueOf(0));
        MediaWhiteListQueryParam param = new MediaWhiteListQueryParam();
        param.setAppId(entity.getAppId());
        QihoMediaWhiteListEntity resultEntity = this.qihoMediaWhiteListDAO.selectWhiteListByParam(param);
        if (null != resultEntity && !resultEntity.getId().equals(entity.getId())) {
            throw new QihoException("\u5a92\u4f53AppId\u5df2\u5b58\u5728");
        }
        param.setAppId(null);
        param.setAppName(entity.getAppName());
        resultEntity = this.qihoMediaWhiteListDAO.selectWhiteListByParam(param);
        if (null != resultEntity && !resultEntity.getId().equals(entity.getId())) {
            throw new QihoException("\u5a92\u4f53\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (null == entity.getId()) {
            this.qihoMediaWhiteListDAO.insert(entity);
        } else {
            this.qihoMediaWhiteListDAO.update(entity);
        }
        return entity.getId();
    }

    @Override
    public Integer deleteWhiteListById(Long id) {
        return this.qihoMediaWhiteListDAO.delete(id);
    }

    @Override
    public PagenationDto<MediaWhiteListDto> queryWhiteListPage(MediaWhiteListQueryParam param) {
        PagenationDto page = new PagenationDto();
        int count = this.qihoMediaWhiteListDAO.selectWhiteListPageCount(param);
        page.setTotal(Integer.valueOf(count));
        if (count == 0) {
            page.setList((List)Lists.newArrayList());
            return page;
        }
        List list = this.qihoMediaWhiteListDAO.selectWhiteListByPage(param);
        page.setList(BeanUtils.copyList((List)list, MediaWhiteListDto.class));
        return page;
    }

    @Override
    public QihoMediaWhiteListEntity queryWhiteListByParam(MediaWhiteListQueryParam param) {
        return this.qihoMediaWhiteListDAO.selectWhiteListByParam(param);
    }

    @Override
    public boolean isInWhiteList(String orderId) {
        ChannelInfoDto infoDto = this.channelInfoService.findByOrderId(orderId);
        if (null == infoDto || null == infoDto.getAppId()) {
            return Boolean.FALSE;
        }
        MediaWhiteListQueryParam param = new MediaWhiteListQueryParam();
        param.setAppId(infoDto.getAppId());
        QihoMediaWhiteListEntity entity = this.qihoMediaWhiteListDAO.selectWhiteListByParam(param);
        return null != entity;
    }

    @Override
    public boolean appInWhiteList(Long appId) {
        if (appId == null || appId <= 0L) {
            return false;
        }
        MediaWhiteListQueryParam param = new MediaWhiteListQueryParam();
        param.setAppId(appId);
        QihoMediaWhiteListEntity entity = this.qihoMediaWhiteListDAO.selectWhiteListByParam(param);
        return null != entity;
    }

    @Override
    public QihoMediaWhiteListEntity selectWhiteById(Long id) {
        return this.qihoMediaWhiteListDAO.selectById(id);
    }
}

