/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.abtest;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.dayu.api.client.DayuClient;
import cn.com.duiba.dayu.api.dto.Experiment;
import cn.com.duiba.dayu.api.dto.Layer;
import cn.com.duiba.dayu.api.enums.ArgumentType;
import cn.com.duiba.dayu.api.enums.DiversionTypeEnum;
import cn.com.duiba.dayu.api.remoteservice.RemoteDayuABService;
import cn.com.duiba.dayu.api.result.DayuResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestPlanDetailDto;
import com.qiho.center.api.dto.abtest.TestPlanDto;
import com.qiho.center.api.dto.abtest.TestPlanStrategyDetailDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.enums.PlanStatusEnum;
import com.qiho.center.api.params.TestPlanQueryParam;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.abtest.TestPlanService;
import com.qiho.center.common.daoh.qiho.QihoMetadataDetailMapper;
import com.qiho.center.common.daoh.qiho.QihoTestMetadataMapper;
import com.qiho.center.common.daoh.qiho.QihoTestPlanDetailMapper;
import com.qiho.center.common.daoh.qiho.QihoTestPlanMapper;
import com.qiho.center.common.entityd.qiho.abtest.QihoMetadataDetailEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestMetadataEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestPlanDetailEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestPlanEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TestPlanServiceImpl
implements TestPlanService {
    private Logger logger = LoggerFactory.getLogger(TestPlanServiceImpl.class);
    @Resource
    private ItemService itemService;
    private static String suffix = "_";
    private static String scnceName = "\u5947\u8d27A/Btest-";
    @Resource
    QihoTestPlanMapper qihoTestPlanMapper;
    @Resource
    QihoTestPlanDetailMapper qihoTestPlanDetailMapper;
    @Resource
    QihoTestMetadataMapper qihoTestMetadataMapper;
    @Resource
    QihoMetadataDetailMapper qihoMetadataDetailMapper;
    @Resource
    RemoteDayuABService remoteDayuABService;
    @Resource
    private DayuClient dayuClient;

    @Override
    public PagenationDto<TestPlanDto> queryTestPlanListByPage(TestPlanQueryParam param) {
        PagenationDto result = new PagenationDto();
        int count = this.qihoTestPlanMapper.selectPageCount(param);
        if (count == 0) {
            return result;
        }
        result.setTotal(Integer.valueOf(count));
        List list = this.qihoTestPlanMapper.selectByPage(param);
        ArrayList resultList = Lists.newArrayList();
        list.stream().forEach(entity -> {
            TestPlanDto testPlanDto = (TestPlanDto)BeanUtils.copy((Object)entity, TestPlanDto.class);
            ItemSimpleDto itemSimpleDto = this.itemService.queryItemSimpleDto(entity.getItemId());
            testPlanDto.setItemName(null != itemSimpleDto ? itemSimpleDto.getItemName() : "");
            resultList.add(testPlanDto);
        });
        result.setList((List)resultList);
        return result;
    }

    @Override
    public boolean updatePlanStatus(Long id, String planStatus, String updator) throws BizException {
        QihoTestPlanEntity entity = this.qihoTestPlanMapper.selectById(id);
        if (StringUtils.equals((CharSequence)entity.getPlanStatus(), (CharSequence)PlanStatusEnum.TO_PUBLISH.getCode())) {
            throw new BizException("\u5f85\u53d1\u5e03\u72b6\u6001\u6d3b\u52a8\u4e0d\u80fd\u88ab\u6682\u505c\u548c\u6062\u590d");
        }
        entity.setPlanStatus(planStatus);
        entity.setUpdator(updator);
        return 1 == this.qihoTestPlanMapper.update(entity);
    }

    @Override
    public boolean deleteTestPlan(Long id, String updator) {
        return 1 == this.qihoTestPlanMapper.delete(id, updator);
    }

    @Override
    public boolean publishTestPlan(Long id) throws BizException {
        QihoTestPlanEntity planEntity = this.qihoTestPlanMapper.selectById(id);
        Long senceId = null;
        if (null == planEntity.getSenceId()) {
            senceId = this.remoteDayuABService.createScene(scnceName + planEntity.getId());
            planEntity.setSenceId(senceId);
        } else {
            senceId = planEntity.getSenceId();
        }
        planEntity.setPlanStatus(PlanStatusEnum.NORMAL.getCode());
        this.qihoTestPlanMapper.update(planEntity);
        Layer layer = new Layer();
        layer.setDiversion(DiversionTypeEnum.CONSUMER_ID_HASH);
        ArrayList experiments = Lists.newArrayList();
        List codeList = Splitter.on((String)",").trimResults().splitToList((CharSequence)planEntity.getPlanCode());
        codeList.stream().forEach(code -> {
            List list = this.qihoTestPlanDetailMapper.selectListByCode(code);
            Experiment experiment = new Experiment();
            experiment.setFlowRate(Integer.valueOf(((QihoTestPlanDetailEntity)list.get(0)).getFlowPercent().intValue()));
            experiment.setName(code);
            experiment.setId(((QihoTestPlanDetailEntity)list.get(0)).getExperimentId());
            HashMap arguments = Maps.newHashMap();
            arguments.put("planCode", code);
            experiment.setArguments((Map)arguments);
            experiments.add(experiment);
        });
        layer.setExperiments((List)experiments);
        ArrayList layerList = Lists.newArrayList();
        layerList.add(layer);
        boolean result = this.remoteDayuABService.save(senceId, "\u8ba1\u5212\u53d1\u5e03", (List)layerList);
        if (!result) {
            throw new BizException("\u5927\u79b9\u7cfb\u7edf\u521b\u5efa\u5b9e\u9a8c\u5931\u8d25");
        }
        List resultList = this.remoteDayuABService.getLayers(senceId);
        Layer layerRe = (Layer)resultList.get(0);
        List experimentList = layerRe.getExperiments();
        experimentList.stream().forEach(experiment -> {
            QihoTestPlanDetailEntity detailEntity = new QihoTestPlanDetailEntity();
            detailEntity.setExperimentId(experiment.getId());
            detailEntity.setPlanCode((String)experiment.getArguments().get("planCode"));
            this.qihoTestPlanDetailMapper.updateByCode(detailEntity);
        });
        return true;
    }

    @Override
    @Transactional(value="QIHO")
    public int saveTestPlan(TestPlanDto planDto) throws BizException {
        if (null == planDto.getId()) {
            return this.addTestPlan(planDto);
        }
        return this.updateTestPlan(planDto);
    }

    private int updateTestPlan(TestPlanDto planDto) throws BizException {
        QihoTestPlanEntity oldEntity = this.qihoTestPlanMapper.selectById(planDto.getId());
        List oldCodeList = Splitter.on((String)",").splitToList((CharSequence)oldEntity.getPlanCode());
        QihoTestPlanEntity entity = (QihoTestPlanEntity)BeanUtils.copy((Object)planDto, QihoTestPlanEntity.class);
        this.validateTestPlan(entity);
        entity.setPlanStatus(PlanStatusEnum.TO_PUBLISH.getCode());
        StringBuilder planCodeSb = new StringBuilder();
        planDto.getDetailDtoList().stream().forEach(detailDto -> {
            Map param = detailDto.getParam();
            StringBuilder sb = new StringBuilder();
            sb.append(entity.getId()).append(suffix).append(param.get(MetadataTypeEnum.PRICE.getCode())).append(suffix).append(param.get(MetadataTypeEnum.DETAIL.getCode())).append(suffix).append(param.get(MetadataTypeEnum.SKIN.getCode()));
            planCodeSb.append((CharSequence)sb).append(",");
            if (oldCodeList.contains(sb.toString())) {
                QihoTestPlanDetailEntity detailEntity = new QihoTestPlanDetailEntity();
                detailEntity.setFlowPercent(detailDto.getFlowPercent());
                detailEntity.setPlanCode(sb.toString());
                this.qihoTestPlanDetailMapper.updateByCode(detailEntity);
            } else {
                param.entrySet().stream().forEach(entry -> {
                    QihoTestPlanDetailEntity detailEntity = new QihoTestPlanDetailEntity();
                    detailEntity.setPlanCode(sb.toString());
                    detailEntity.setPlanId(entity.getId());
                    detailEntity.setMetadataId((Long)entry.getValue());
                    detailEntity.setFlowPercent(detailDto.getFlowPercent());
                    detailEntity.setMetadataKey((String)entry.getKey());
                    this.qihoTestPlanDetailMapper.insert(detailEntity);
                });
            }
        });
        List newCodeList = Splitter.on((String)",").trimResults().splitToList((CharSequence)planCodeSb);
        oldCodeList.stream().forEach(code -> {
            if (!newCodeList.contains(code)) {
                this.qihoTestPlanDetailMapper.deleteByCode(code);
            }
        });
        entity.setPlanCode(planCodeSb.substring(0, planCodeSb.length() - 1));
        this.qihoTestPlanMapper.update(entity);
        return 1;
    }

    private int addTestPlan(TestPlanDto planDto) throws BizException {
        QihoTestPlanEntity entity = (QihoTestPlanEntity)BeanUtils.copy((Object)planDto, QihoTestPlanEntity.class);
        this.validateTestPlan(entity);
        entity.setPlanStatus(PlanStatusEnum.TO_PUBLISH.getCode());
        this.qihoTestPlanMapper.insert(entity);
        StringBuilder planCodeSb = new StringBuilder();
        planDto.getDetailDtoList().stream().forEach(detailDto -> {
            Map param = detailDto.getParam();
            StringBuilder sb = new StringBuilder();
            sb.append(entity.getId()).append(suffix).append(param.get(MetadataTypeEnum.PRICE.getCode())).append(suffix).append(param.get(MetadataTypeEnum.DETAIL.getCode())).append(suffix).append(param.get(MetadataTypeEnum.SKIN.getCode()));
            planCodeSb.append((CharSequence)sb).append(",");
            param.entrySet().stream().forEach(entry -> {
                QihoTestPlanDetailEntity detailEntity = new QihoTestPlanDetailEntity();
                detailEntity.setFlowPercent(detailDto.getFlowPercent());
                detailEntity.setPlanCode(sb.toString());
                detailEntity.setPlanId(entity.getId());
                detailEntity.setMetadataKey((String)entry.getKey());
                detailEntity.setMetadataId((Long)entry.getValue());
                this.qihoTestPlanDetailMapper.insert(detailEntity);
            });
        });
        entity.setPlanCode(planCodeSb.substring(0, planCodeSb.length() - 1));
        this.qihoTestPlanMapper.update(entity);
        return 1;
    }

    @Override
    public TestPlanDto queryTestPlanById(Long planId) {
        QihoTestPlanEntity entity = this.qihoTestPlanMapper.selectById(planId);
        TestPlanDto dto = (TestPlanDto)BeanUtils.copy((Object)entity, TestPlanDto.class);
        ArrayList list = Lists.newArrayList();
        List codeList = Splitter.on((String)",").trimResults().splitToList((CharSequence)entity.getPlanCode());
        codeList.stream().forEach(code -> {
            List detailList = this.qihoTestPlanDetailMapper.selectListByCode(code);
            TestPlanDetailDto detailDto = new TestPlanDetailDto();
            detailDto.setFlowPercent(((QihoTestPlanDetailEntity)detailList.get(0)).getFlowPercent());
            HashMap map = Maps.newHashMap();
            detailList.forEach(e -> map.put(e.getMetadataKey(), e.getMetadataId()));
            detailDto.setParam((Map)map);
            list.add(detailDto);
        });
        dto.setDetailDtoList((List)list);
        return dto;
    }

    @Override
    public TestPlanStrategyDetailDto queryTestStrategyByItemIdAndUser(Long itemId, String acUserId) {
        TestPlanStrategyDetailDto resultDto = new TestPlanStrategyDetailDto();
        try {
            QihoTestPlanEntity entity = this.qihoTestPlanMapper.selectValidPlanByItemId(itemId);
            if (null == entity) {
                return null;
            }
            DayuResult handleResult = this.dayuClient.handleRequest("scene:" + entity.getSenceId(), (Object)Long.valueOf(acUserId), ArgumentType.CONSUMER_ID);
            if (null == handleResult) {
                this.logger.warn("TestPlanServiceImpl call dayuClient result is null, acUserId = {},sceneId = {}", (Object)acUserId, (Object)entity.getSenceId());
                return null;
            }
            Map arguments = handleResult.getArguments();
            String planCode = (String)arguments.get("planCode");
            if (StringUtils.isBlank((CharSequence)planCode)) {
                return null;
            }
            List planCodeList = Splitter.on((String)",").trimResults().splitToList((CharSequence)entity.getPlanCode());
            if (!planCodeList.contains(planCode)) {
                return null;
            }
            resultDto.setPlanId(entity.getId());
            resultDto.setPlanCode(planCode);
            List detailEntityList = this.qihoTestPlanDetailMapper.selectListByCode(planCode);
            detailEntityList.stream().forEach(detailEntity -> {
                if (detailEntity.getMetadataKey().equals(MetadataTypeEnum.SKIN.getCode())) {
                    QihoTestMetadataEntity testMetadataEntity = this.qihoTestMetadataMapper.selectById(detailEntity.getMetadataId());
                    resultDto.setSkinId(Long.valueOf(testMetadataEntity.getMetadataValue()));
                    resultDto.setSkinType(testMetadataEntity.getSkinType());
                }
            });
        }
        catch (Exception e) {
            this.logger.error("TestPlanServiceImpl call queryTestStrategyByItemIdAndUser error,itemId={},userId={}", new Object[]{itemId, acUserId, e});
            return null;
        }
        return resultDto;
    }

    @Override
    public TestPlanStrategyDetailDto queryStrategyDetailByPlanCode(String planCode) {
        TestPlanStrategyDetailDto dto = new TestPlanStrategyDetailDto();
        dto.setPlanCode(planCode);
        List detailEntityList = this.qihoTestPlanDetailMapper.selectListByCode(planCode);
        detailEntityList.stream().forEach(detailEntity -> {
            dto.setPlanId(detailEntity.getPlanId());
            QihoTestMetadataEntity testMetadataEntity = this.qihoTestMetadataMapper.selectById(detailEntity.getMetadataId());
            if (detailEntity.getMetadataKey().equals(MetadataTypeEnum.PRICE.getCode())) {
                dto.setPriceInfo(testMetadataEntity.getMetadataValue());
            }
            if (detailEntity.getMetadataKey().equals(MetadataTypeEnum.DETAIL.getCode())) {
                QihoMetadataDetailEntity e = this.qihoMetadataDetailMapper.selectById(Long.valueOf(testMetadataEntity.getMetadataValue()));
                dto.setDetailText(e.getDetailText());
            }
        });
        return dto;
    }

    private void validateTestPlan(QihoTestPlanEntity entity) throws BizException {
        this.validateTestPlanName(entity);
        this.validateTestPlanTime(entity);
    }

    private void validateTestPlanTime(QihoTestPlanEntity entity) throws BizException {
        HashMap map = Maps.newHashMap();
        map.put("itemId", entity.getItemId());
        map.put("startTime", entity.getStartTime());
        map.put("endTime", entity.getEndTime());
        List existList = this.qihoTestPlanMapper.selectExistTestPlanByItemId((Map)map);
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            if (null == entity.getId() || 0L == entity.getId()) {
                throw new BizException("\u5546\u54c1\u5728\u5f53\u524d\u65f6\u95f4\u6bb5\u5185\u5df2\u5b58\u5728\u6d4b\u8bd5\u8ba1\u5212,\u8ba1\u5212\u540d\u79f0\u540d\u79f0:" + ((QihoTestPlanEntity)existList.get(0)).getPlanName());
            }
            for (QihoTestPlanEntity e : existList) {
                if (e.getId().equals(entity.getId())) continue;
                throw new BizException("\u5546\u54c1\u5728\u5f53\u524d\u65f6\u95f4\u6bb5\u5185\u5df2\u5b58\u5728\u6d4b\u8bd5\u8ba1\u5212,\u8ba1\u5212\u540d\u79f0\u540d\u79f0:" + e.getPlanName());
            }
        }
    }

    private void validateTestPlanName(QihoTestPlanEntity entity) throws BizException {
        HashMap map = Maps.newHashMap();
        map.put("planName", entity.getPlanName());
        List list = this.qihoTestPlanMapper.selectListByField((Map)map);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            if (null == entity.getId() || 0L == entity.getId()) {
                throw new BizException("\u6d4b\u8bd5\u8ba1\u5212\u540d\u79f0\u5df2\u5b58\u5728");
            }
            for (QihoTestPlanEntity e : list) {
                if (e.getId().equals(entity.getId())) continue;
                throw new BizException("\u6d4b\u8bd5\u8ba1\u5212\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
    }
}

