/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.account;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiAccountDto;
import com.qiho.center.api.dto.account.BaiqiMainAndAgenAccountDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.enums.account.BaiqiAccountStatusEnum;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.params.account.AccountPageParam;
import com.qiho.center.api.params.menu.AccountMenuParams;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.daoh.qiho.account.BaiqiAccountMapper;
import com.qiho.center.common.daoh.qiho.agent.BaiqiAgentMapper;
import com.qiho.center.common.daoh.qiho.menu.BaiqiAccountMenuMapper;
import com.qiho.center.common.daoh.qiho.menu.BaiqiMenuMapper;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entityd.qiho.account.BaiqiAccountEntity;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.menu.BaiqiAccountMenuEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="baiqiAccountService")
public class BaiqiAccountServiceImpl
implements BaiqiAccountService {
    @Resource
    private BaiqiAccountMapper baiqiAccountMapper;
    @Resource
    private BaiqiAccountMenuMapper baiqiAccountMenuMapper;
    @Resource
    private BaiqiMenuMapper baiqiMenuMapper;
    @Resource
    private MerchantService merchantService;
    @Resource
    private BaiqiAgentService baiqiAgentService;
    @Autowired
    private BaiqiAgentMapper baiqiAgentMapper;
    @Autowired
    private QihoMerchantDAO qihoMerchantDAO;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;

    @Override
    public BaiqiAccountDto findByAccount(String account) {
        MerchantDto merchantDto;
        BaiqiAccountEntity accountEntity = this.baiqiAccountMapper.findByAccount(account);
        if (!(Objects.isNull(accountEntity) || accountEntity.getAccountType().intValue() != BaiqiAccountTypeEnum.SUB_ACCOUNT.getCode() && accountEntity.getAccountType().intValue() != BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode() || Objects.isNull(merchantDto = this.merchantService.findById(accountEntity.getRelationId())))) {
            accountEntity.setVersionSign(merchantDto.getVersionSign());
        }
        return (BaiqiAccountDto)BeanUtils.copy((Object)accountEntity, BaiqiAccountDto.class);
    }

    @Override
    public BaiqiAccountDto findByMobile(String mobile) {
        MerchantDto merchantDto;
        BaiqiAccountEntity accountEntity = this.baiqiAccountMapper.findByMobile(mobile);
        if (!(Objects.isNull(accountEntity) || accountEntity.getAccountType().intValue() != BaiqiAccountTypeEnum.SUB_ACCOUNT.getCode() && accountEntity.getAccountType().intValue() != BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode() || Objects.isNull(merchantDto = this.merchantService.findById(accountEntity.getRelationId())))) {
            accountEntity.setVersionSign(merchantDto.getVersionSign());
        }
        return (BaiqiAccountDto)BeanUtils.copy((Object)accountEntity, BaiqiAccountDto.class);
    }

    @Override
    public boolean deleteById(Long id) {
        this.baiqiAccountMapper.deleteById(id);
        this.baiqiAccountMenuMapper.deleteByAccountId(id);
        return true;
    }

    @Override
    public PagenationDto<BaiqiMainAndAgenAccountDto> findPageAccount(AccountPageParam pageQueryParams) {
        PagenationDto pagenationDto = new PagenationDto();
        if (StringUtils.isNotEmpty((CharSequence)pageQueryParams.getMerchantName())) {
            List merchantEntityList = this.qihoMerchantDAO.listByMerchantName(pageQueryParams.getMerchantName());
            if (CollectionUtils.isEmpty((Collection)merchantEntityList)) {
                return pagenationDto.emptyPage();
            }
            pageQueryParams.setMerchantIdList(merchantEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageQueryParams.getAgentName())) {
            List agentEntityList = this.baiqiAgentMapper.listByAgentName(pageQueryParams.getAgentName());
            if (CollectionUtils.isEmpty((Collection)agentEntityList)) {
                return pagenationDto.emptyPage();
            }
            pageQueryParams.setAgentIdList(agentEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        int total = this.baiqiAccountMapper.countPageMainAccount(pageQueryParams);
        pagenationDto.setTotal(Integer.valueOf(total));
        if (total == 0) {
            pagenationDto.setList(Collections.emptyList());
            return pagenationDto;
        }
        List entities = this.baiqiAccountMapper.findPageAccount(pageQueryParams);
        pagenationDto.setList(this.convertDtoList(entities));
        return pagenationDto;
    }

    private List<BaiqiMainAndAgenAccountDto> convertDtoList(List<BaiqiAccountEntity> entities) {
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        ArrayList<Long> agentIds = new ArrayList<Long>();
        this.setRelationIds(merchantIds, agentIds, entities);
        Map<Object, Object> merchantDtoMap = new HashMap();
        Map<Object, Object> agentMap = new HashMap();
        if (CollectionUtils.isNotEmpty(merchantIds)) {
            merchantDtoMap = this.merchantService.findByIdList(merchantIds);
        }
        if (CollectionUtils.isNotEmpty(agentIds)) {
            agentMap = this.baiqiAgentService.findByIdsMap(agentIds);
        }
        ArrayList<BaiqiMainAndAgenAccountDto> mainAccountDtos = new ArrayList<BaiqiMainAndAgenAccountDto>();
        for (BaiqiAccountEntity entity : entities) {
            Long relationId = entity.getRelationId();
            int accountType = entity.getAccountType();
            BaiqiMainAndAgenAccountDto accountDto = (BaiqiMainAndAgenAccountDto)BeanUtils.copy((Object)entity, BaiqiMainAndAgenAccountDto.class);
            accountDto.setPwd("BAIqi123");
            if (accountType == BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode()) {
                accountDto.setAccountTypeName(BaiqiAccountTypeEnum.AGENT_ACCOUNT.getTypeName());
                BaiqiAgentEntity agentEntity = (BaiqiAgentEntity)agentMap.get(relationId);
                accountDto.setRelationName(agentEntity == null ? null : agentEntity.getAgentName());
            } else {
                accountDto.setAccountTypeName(BaiqiAccountTypeEnum.MAIN_ACCOUNT.getTypeName());
                MerchantDto merchantDto = (MerchantDto)merchantDtoMap.get(relationId);
                accountDto.setRelationName(merchantDto == null ? null : merchantDto.getMerchantName());
            }
            mainAccountDtos.add(accountDto);
        }
        return mainAccountDtos;
    }

    private void setRelationIds(List<Long> merchantIds, List<Long> agentIds, List<BaiqiAccountEntity> entities) {
        for (BaiqiAccountEntity entity : entities) {
            int accountType = entity.getAccountType();
            Long relationId = entity.getRelationId();
            if (accountType == BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode()) {
                agentIds.add(relationId);
                continue;
            }
            merchantIds.add(relationId);
        }
    }

    @Override
    public Boolean disableMainAccount(Long id) throws BizException {
        BaiqiAccountDto accountDto = this.baiqiAccountMapper.findById(id);
        if (accountDto == null) {
            throw new BizException("\u4e3b\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        boolean result = this.disable(id);
        if (!result) {
            return Boolean.FALSE;
        }
        int accountType = accountDto.getAccountType();
        String account = accountDto.getAccount();
        this.advancedCacheClient.remove("BAIQI:FERRARI:USER:" + account);
        if (accountType != BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode()) {
            return Boolean.TRUE;
        }
        List entities = this.baiqiAccountMapper.findAllSubAccountByParentId(id);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return Boolean.TRUE;
        }
        int total = this.baiqiAccountMapper.disableSubAccountByParentId(id);
        if (total <= 0) {
            return Boolean.FALSE;
        }
        ArrayList<String> redisKeys = new ArrayList<String>();
        for (BaiqiAccountEntity accountEntity : entities) {
            redisKeys.add("BAIQI:FERRARI:USER:" + accountEntity.getAccount());
        }
        this.advancedCacheClient.remove(redisKeys.toArray(new String[redisKeys.size()]));
        return Boolean.TRUE;
    }

    @Override
    public List<BaiqiAccountDto> findByParentId(Long mainAid) {
        List accountList = this.baiqiAccountMapper.findByParentId(mainAid);
        return BeanUtils.copyList((List)accountList, BaiqiAccountDto.class);
    }

    @Override
    public List<String> findAllMainAccount() {
        return this.baiqiAccountMapper.findAllMainAccount();
    }

    @Override
    public Boolean enable(Long id) {
        BaiqiAccountEntity accountEntity = new BaiqiAccountEntity();
        accountEntity.setId(id);
        accountEntity.setState(Integer.valueOf(BaiqiAccountStatusEnum.ENABLE.getCode()));
        return this.baiqiAccountMapper.update(accountEntity) > 0;
    }

    @Override
    public Boolean disable(Long id) {
        BaiqiAccountEntity accountEntity = new BaiqiAccountEntity();
        accountEntity.setId(id);
        accountEntity.setState(Integer.valueOf(BaiqiAccountStatusEnum.DISABLE.getCode()));
        return this.baiqiAccountMapper.update(accountEntity) > 0;
    }

    @Override
    public Boolean save(BaiqiAccountDto accountDto) throws BizException {
        BaiqiAccountEntity accountEntity = (BaiqiAccountEntity)BeanUtils.copy((Object)accountDto, BaiqiAccountEntity.class);
        Long accountId = accountEntity.getId();
        if (accountId == null) {
            this.insertAccount(accountEntity);
            accountId = accountEntity.getId();
        } else {
            this.updateAccount(accountEntity);
        }
        String menuIdStr = accountDto.getMenuIds();
        if (StringUtils.isBlank((CharSequence)menuIdStr)) {
            return true;
        }
        int accountType = accountEntity.getAccountType();
        if (BaiqiAccountTypeEnum.SUB_ACCOUNT.getCode() == accountType) {
            this.doSaveMenu(accountId, menuIdStr, accountDto.getAccount());
        }
        return true;
    }

    private void doSaveMenu(Long accountId, String menuIdStr, String accountName) {
        List menuIds = Arrays.stream(menuIdStr.split(",")).map(Long::valueOf).collect(Collectors.toList());
        List menuEntityList = this.baiqiMenuMapper.selectByIdList(menuIds);
        if (CollectionUtils.isNotEmpty((Collection)menuEntityList)) {
            ArrayList insertList = Lists.newArrayListWithExpectedSize((int)menuEntityList.size());
            menuEntityList.forEach(e -> {
                BaiqiAccountMenuEntity accountMenuEntity = new BaiqiAccountMenuEntity();
                accountMenuEntity.setAccountId(accountId);
                accountMenuEntity.setMenuId(e.getId());
                insertList.add(accountMenuEntity);
            });
            this.baiqiAccountMenuMapper.deleteByAccountId(accountId);
            this.baiqiAccountMenuMapper.insertBatch((List)insertList);
            this.advancedCacheClient.remove("BAIQI:FERRARI:USER:" + accountName);
        }
    }

    private void insertAccount(BaiqiAccountEntity accountEntity) throws BizException {
        Long accountId = accountEntity.getId();
        BaiqiAccountEntity existsAccount = this.baiqiAccountMapper.findByAccount(accountEntity.getAccount());
        if (existsAccount != null && !existsAccount.getId().equals(accountId)) {
            throw new BizException("\u8d26\u53f7\u540d\u79f0\u5df2\u5b58\u5728");
        }
        BaiqiAccountEntity existsMobile = this.baiqiAccountMapper.findByMobile(accountEntity.getMobile());
        if (existsMobile != null && !existsMobile.getId().equals(accountId)) {
            throw new BizException("\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        Integer accountType = accountEntity.getAccountType();
        if (BaiqiAccountTypeEnum.SUB_ACCOUNT.getCode() == accountType.intValue()) {
            this.baiqiAccountMapper.insert(accountEntity);
            return;
        }
        Long relationId = accountEntity.getRelationId();
        String account = this.baiqiAccountMapper.findAccountByTypeAndRelationId(accountType, relationId);
        if (StringUtils.isBlank((CharSequence)account)) {
            this.baiqiAccountMapper.insert(accountEntity);
            return;
        }
        if (BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode() == accountType.intValue()) {
            throw new BizException("\u5546\u5bb6id=[" + relationId + "]\u5df2\u4e0e\u4e3b\u8d26\u53f7=[" + account + "]\u5173\u8054,\u4e0d\u53ef\u91cd\u590d\u5173\u8054");
        }
        throw new BizException("\u4ee3\u7406\u5546id=[" + relationId + "]\u5df2\u4e0e\u4ee3\u7406\u5546\u8d26\u53f7=[" + account + "]\u5173\u8054,\u4e0d\u53ef\u91cd\u590d\u5173\u8054");
    }

    private void updateAccount(BaiqiAccountEntity accountEntity) throws BizException {
        Long accountId = accountEntity.getId();
        BaiqiAccountEntity existsMobile = this.baiqiAccountMapper.findByMobile(accountEntity.getMobile());
        if (existsMobile != null && !existsMobile.getId().equals(accountId)) {
            throw new BizException("\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        this.baiqiAccountMapper.update(accountEntity);
    }

    @Override
    public BaiqiAccountDto findById(Long id) {
        BaiqiAccountDto accountDto = this.baiqiAccountMapper.findById(id);
        AccountMenuParams params = new AccountMenuParams();
        params.setAccountId(id);
        List accountMenuList = this.baiqiAccountMenuMapper.selectByParam(params);
        if (CollectionUtils.isNotEmpty((Collection)accountMenuList)) {
            List menuIds = accountMenuList.stream().map(BaiqiAccountMenuEntity::getMenuId).collect(Collectors.toList());
            accountDto.setMenuIds(Joiner.on((String)",").join(menuIds));
        }
        return accountDto;
    }

    @Override
    public String findAccountById(Long id) {
        if (id == null) {
            return "";
        }
        return this.baiqiAccountMapper.findAccountById(id);
    }

    @Override
    public Boolean update(BaiqiAccountEntity accountEntity) {
        return this.baiqiAccountMapper.update(accountEntity) > 0;
    }

    @Override
    public List<Long> findRelationIdsByAccountType(Integer accountType) {
        return this.baiqiAccountMapper.findRelationIdsByAccountType(accountType);
    }

    @Override
    public BaiqiAccountEntity findMainAccountByMerchantId(Long merchantId) {
        MerchantDto merchantDto;
        BaiqiAccountEntity accountEntity = this.baiqiAccountMapper.findMainAccountByMerchantId(merchantId);
        if (!(Objects.isNull(accountEntity) || accountEntity.getAccountType().intValue() != BaiqiAccountTypeEnum.SUB_ACCOUNT.getCode() && accountEntity.getAccountType().intValue() != BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode() || Objects.isNull(merchantDto = this.merchantService.findById(accountEntity.getRelationId())))) {
            accountEntity.setVersionSign(merchantDto.getVersionSign());
        }
        return accountEntity;
    }

    @Override
    public BaiqiAccountEntity findByTypeAndRelationId(Integer accountType, Long relationId) {
        return this.baiqiAccountMapper.findByTypeAndRelationId(accountType, relationId);
    }

    @Override
    public List<Long> filterMerchantIds(List<Long> merchantIds) {
        return this.baiqiAccountMapper.filterMerchantIds(merchantIds);
    }
}

