/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.advert;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.advert.ItemAdvertPlanDto;
import com.qiho.center.api.dto.advert.TuiaPlanDto;
import com.qiho.center.api.params.advert.ItemBindPlanParams;
import com.qiho.center.api.params.advert.ItemPlanQueryParams;
import com.qiho.center.biz.service.advert.ItemPlanService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemMerchantDAO;
import com.qiho.center.common.daoh.qiho.advert.BaiqiItemPlanMapper;
import com.qiho.center.common.daoh.qiho.advert.BaiqiMerchantLinkRelationMapper;
import com.qiho.center.common.daoh.qiho.advert.BaiqiTuiaPlanMapper;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entityd.qiho.advert.BaiqiItemPlanEntity;
import com.qiho.center.common.entityd.qiho.advert.BaiqiMerchantLinkRelationEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ItemPlanServiceImpl
implements ItemPlanService {
    @Autowired
    private BaiqiItemPlanMapper baiqiItemPlanMapper;
    @Autowired
    private QihoItemDAO qihoItemDAO;
    @Autowired
    private BaiqiTuiaPlanMapper baiqiTuiaPlanMapper;
    @Autowired
    private QihoItemMerchantDAO qihoItemMerchantDAO;
    @Autowired
    private BaiqiMerchantLinkRelationMapper baiqiMerchantLinkRelationMapper;

    @Override
    public PagenationDto<ItemAdvertPlanDto> queryPage(ItemPlanQueryParams params) {
        PagenationDto page = new PagenationDto();
        QihoItemEntity qihoItemEntity = new QihoItemEntity();
        qihoItemEntity.setId(params.getItemId());
        qihoItemEntity.setItemName(params.getItemName());
        Integer count = this.qihoItemDAO.countByParam(qihoItemEntity);
        page.setTotal(count);
        if (count == 0) {
            page.setList((List)Lists.newArrayList());
            return page;
        }
        List itemEntities = this.qihoItemDAO.queryByParam(qihoItemEntity, params.getPageNum(), params.getPageSize());
        List<Long> itemIds = itemEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List itemPlanEntities = this.baiqiItemPlanMapper.findByList(itemIds);
        HashMap advertMap = Maps.newHashMap();
        for (BaiqiItemPlanEntity entity : itemPlanEntities) {
            if (Objects.equals(null, advertMap.get(entity.getItemId()))) {
                TuiaPlanDto tuiaPlanDto = (TuiaPlanDto)BeanUtils.copy((Object)entity, TuiaPlanDto.class);
                advertMap.put(entity.getItemId(), Lists.newArrayList((Object[])new TuiaPlanDto[]{tuiaPlanDto}));
                continue;
            }
            List tuiaPlanDtos = (List)advertMap.get(entity.getItemId());
            tuiaPlanDtos.add(BeanUtils.copy((Object)entity, TuiaPlanDto.class));
            advertMap.put(entity.getItemId(), tuiaPlanDtos);
        }
        Map<Long, Boolean> itemAdvert = this.validAdvert(itemIds);
        List list = Lists.transform((List)itemEntities, itemEntitie -> {
            ItemAdvertPlanDto itemAdvertPlanDto = new ItemAdvertPlanDto();
            itemAdvertPlanDto.setItemId(itemEntitie.getId());
            itemAdvertPlanDto.setItemName(itemEntitie.getItemName());
            itemAdvertPlanDto.setAdvertList(advertMap.get(itemEntitie.getId()) == null ? Lists.newArrayList() : (List)advertMap.get(itemEntitie.getId()));
            itemAdvertPlanDto.setBindAdvert((Boolean)itemAdvert.get(itemEntitie.getId()));
            return itemAdvertPlanDto;
        });
        page.setList(list);
        return page;
    }

    private Map<Long, Boolean> validAdvert(List<Long> itemIds) {
        List itemMerchantEntities = this.qihoItemMerchantDAO.findByItemIds(itemIds);
        HashMap map1 = Maps.newHashMap();
        itemMerchantEntities.stream().forEach(e -> map1.put(e.getItemId(), e.getMerchantId()));
        HashMap map2 = Maps.newHashMap();
        ArrayList merchantIds = Lists.newArrayList(map1.values());
        List relationEntityList = this.baiqiMerchantLinkRelationMapper.findBymerchantIds((List)merchantIds);
        relationEntityList.stream().forEach(e -> map2.put(e.getMerchantId(), e.getRelationId()));
        HashMap map3 = Maps.newHashMap();
        for (Long itemId : itemIds) {
            map3.put(itemId, map2.get(map1.get(itemId)) != null);
        }
        return map3;
    }

    @Override
    public List<TuiaPlanDto> getUnbindPlan(Long itemId) {
        BaiqiMerchantLinkRelationEntity relationEntity = this.getLinkRelation(itemId);
        if (Objects.equals(null, relationEntity)) {
            return Lists.newArrayList();
        }
        Long advertId = relationEntity.getRelationId();
        List tuiaPlanEntities = this.baiqiTuiaPlanMapper.findUnbindPlan(advertId);
        return BeanUtils.copyList((List)tuiaPlanEntities, TuiaPlanDto.class);
    }

    @Override
    public Boolean bingPlan(ItemBindPlanParams params) throws BizException {
        List entityList;
        Integer result;
        BaiqiMerchantLinkRelationEntity relationEntity = this.getLinkRelation(params.getItemId());
        if (Objects.equals(null, relationEntity)) {
            throw new BizException("\u5546\u5bb6\u672a\u5173\u8054\u5e7f\u544a\u4e3b");
        }
        List planIds = params.getPlanList();
        List itemPlanEntities = this.baiqiItemPlanMapper.findByPlanIds(planIds);
        if (itemPlanEntities.size() == planIds.size()) {
            throw new BizException("\u6240\u6709\u7684\u5e7f\u544a\u8ba1\u5212\u90fd\u5df2\u88ab\u5173\u8054");
        }
        if (!CollectionUtils.isEmpty((Collection)itemPlanEntities)) {
            List bindPlanIds = itemPlanEntities.stream().map(BaiqiItemPlanEntity::getPlanId).collect(Collectors.toList());
            planIds.removeAll(bindPlanIds);
        }
        return (result = this.baiqiItemPlanMapper.insertBatch(entityList = Lists.transform((List)planIds, e -> {
            BaiqiItemPlanEntity baiqiItemPlanEntity = new BaiqiItemPlanEntity();
            baiqiItemPlanEntity.setItemId(params.getItemId());
            baiqiItemPlanEntity.setPlanId(e);
            baiqiItemPlanEntity.setCreater(params.getCreater());
            baiqiItemPlanEntity.setModifier(params.getModifier());
            return baiqiItemPlanEntity;
        }))).intValue() == entityList.size();
    }

    private BaiqiMerchantLinkRelationEntity getLinkRelation(Long itemId) {
        Long merchantId = this.qihoItemMerchantDAO.findByItemId(itemId).getMerchantId();
        BaiqiMerchantLinkRelationEntity merchantRelationEntity = new BaiqiMerchantLinkRelationEntity();
        merchantRelationEntity.setMerchantId(merchantId);
        merchantRelationEntity.setRelationType(Integer.valueOf(1));
        return this.baiqiMerchantLinkRelationMapper.findByMerchantId(merchantRelationEntity);
    }
}

