/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.agent;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.enums.finance.BaiqiCommercialTenantTypeEnum;
import com.qiho.center.api.params.PageQueryParams;
import com.qiho.center.api.params.agent.AgentPageParam;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.common.daoh.qiho.agent.BaiqiAgentMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceMapper;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="baiqiAgentService")
public class BaiqiAgentServiceImpl
implements BaiqiAgentService {
    @Resource
    private BaiqiAgentMapper baiqiAgentMapper;
    @Resource
    private BaiqiFinanceMapper baiqiFinanceMapper;

    @Override
    public Map<Long, BaiqiAgentEntity> findByIdsMap(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        List agentEntities = this.baiqiAgentMapper.findByIds(ids);
        if (CollectionUtils.isEmpty((Collection)agentEntities)) {
            return Collections.emptyMap();
        }
        HashMap<Long, BaiqiAgentEntity> map = new HashMap<Long, BaiqiAgentEntity>();
        for (BaiqiAgentEntity entity : agentEntities) {
            map.put(entity.getId(), entity);
        }
        return map;
    }

    @Override
    public List<BaiqiAgentEntity> findAll() {
        return this.baiqiAgentMapper.findAll();
    }

    @Override
    public PagenationDto<BaiqiAgentDto> find4Page(AgentPageParam params) {
        PagenationDto page = new PagenationDto();
        if (params.getOffset() == null || params.getMax() == null) {
            page.setTotal(Integer.valueOf(0));
            return page;
        }
        Integer count = this.baiqiAgentMapper.countByQuery(params);
        page.setTotal(count);
        if (count == 0) {
            return page;
        }
        List list = BeanUtils.copyList((List)this.baiqiAgentMapper.listByQuery((PageQueryParams)params), BaiqiAgentDto.class);
        page.setList(list);
        return page;
    }

    @Override
    public Boolean update(BaiqiAgentDto agentDto) {
        return this.baiqiAgentMapper.update((BaiqiAgentEntity)BeanUtils.copy((Object)agentDto, BaiqiAgentEntity.class)) > 0;
    }

    @Override
    @Transactional(value="QIHO")
    public Boolean insert(BaiqiAgentEntity agentEntity) {
        Integer res1 = this.baiqiAgentMapper.insert(agentEntity);
        BaiqiFinanceEntity financeEntity = new BaiqiFinanceEntity();
        financeEntity.setRelationId(agentEntity.getId());
        financeEntity.setRelationType(Integer.valueOf(BaiqiCommercialTenantTypeEnum.AGENT.getType()));
        Integer res2 = this.baiqiFinanceMapper.insertAccountFinance(financeEntity);
        return res1 + res2 == 2;
    }

    @Override
    public BaiqiAgentEntity findById(Long id) {
        return this.baiqiAgentMapper.findById(id);
    }

    @Override
    public List<SimpleIdAndNameDto> findSimpleAll() {
        List list = this.baiqiAgentMapper.findAll();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        ArrayList<SimpleIdAndNameDto> dtos = new ArrayList<SimpleIdAndNameDto>();
        for (BaiqiAgentEntity entity : list) {
            SimpleIdAndNameDto dto = new SimpleIdAndNameDto();
            dto.setId(entity.getId());
            dto.setName(entity.getAgentName());
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public BaiqiAgentEntity findAgentByMerchantId(String merchantId) {
        return this.baiqiAgentMapper.findAgentByMerchantId(merchantId);
    }

    @Override
    public BaiqiAgentDto findByAgentName(String agentName) {
        return (BaiqiAgentDto)BeanUtils.copy((Object)this.baiqiAgentMapper.findByAgentName(agentName), BaiqiAgentDto.class);
    }
}

