/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.amap;

import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.amap.BaiqiAmapDto;
import com.qiho.center.api.dto.amap.BaiqiAmapTipDto;
import com.qiho.center.biz.service.amap.AmapApiService;
import com.qiho.center.common.util.HttpClientUtil;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="amapApiService")
public class AmapApiServiceImpl
implements AmapApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmapApiServiceImpl.class);
    @Value(value="${qiho.amap.tips.url}")
    private String amapUrl;
    @Value(value="${qiho.amap.tips.key}")
    private String amapKey;

    @Override
    public List<BaiqiAmapTipDto> getAmapTipList(String keywords, String city) {
        String cityCode = "";
        if (Objects.isNull(keywords)) {
            keywords = "";
        }
        if (Objects.isNull(city)) {
            city = "";
        } else if (StringUtils.isNumeric((CharSequence)city) && city.length() == 6) {
            cityCode = city.substring(0, 4);
        }
        String url = "";
        try {
            url = this.amapUrl + "?key=" + this.amapKey + "&keywords=" + URLEncoder.encode(keywords, "utf-8") + "&city=" + URLEncoder.encode(city, "utf-8");
            String result = HttpClientUtil.sendGet((String)url);
            if (StringUtils.isBlank((CharSequence)result)) {
                return Collections.emptyList();
            }
            BaiqiAmapDto amapDto = (BaiqiAmapDto)JSON.parseObject((String)result, BaiqiAmapDto.class);
            if (Objects.isNull(amapDto) || amapDto.getStatus() == 0) {
                return Collections.emptyList();
            }
            Iterator iterator = amapDto.getTips().iterator();
            while (iterator.hasNext()) {
                BaiqiAmapTipDto baiqiAmapTipDto = (BaiqiAmapTipDto)iterator.next();
                if (baiqiAmapTipDto.getAdcode().equals("[]")) {
                    iterator.remove();
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)city) || !StringUtils.isNotBlank((CharSequence)cityCode) || cityCode.equals(baiqiAmapTipDto.getAdcode().substring(0, 4))) continue;
                iterator.remove();
            }
            return amapDto.getTips();
        }
        catch (Exception e) {
            LOGGER.warn("\u8c03\u7528\u9ad8\u5fb7\u5730\u56fe\u63a5\u53e3\u5931\u8d25, URL:{}", (Object)url, (Object)e);
            return Collections.emptyList();
        }
    }
}

