/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.area;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.area.AddressDto;
import com.qiho.center.biz.service.area.AddressService;
import com.qiho.center.common.daoh.qiho.area.BaiqiAddressMapper;
import com.qiho.center.common.entity.area.BaiqiAddressEntity;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AddressServiceImpl
implements AddressService {
    @Autowired
    private BaiqiAddressMapper baiqiAddressMapper;

    @Override
    public List<AddressDto> findByUserId(Long userId) {
        BaiqiAddressEntity param = new BaiqiAddressEntity();
        param.setUserId(userId);
        List entityList = this.baiqiAddressMapper.findByParam(param);
        return BeanUtils.copyList((List)entityList, AddressDto.class);
    }

    @Override
    @Transactional(value="QIHO")
    public Boolean createAddress(AddressDto dto) {
        if (dto.getDefaulted().booleanValue()) {
            this.baiqiAddressMapper.cancelDefault(dto.getUserId());
        }
        this.baiqiAddressMapper.insert((BaiqiAddressEntity)BeanUtils.copy((Object)dto, BaiqiAddressEntity.class));
        return Boolean.TRUE;
    }

    @Override
    @Transactional(value="QIHO")
    public Boolean deleteAddress(AddressDto dto) {
        BaiqiAddressEntity entity = this.baiqiAddressMapper.findById(dto.getId());
        this.baiqiAddressMapper.delete(dto.getId());
        if (entity.getDefaulted().booleanValue()) {
            BaiqiAddressEntity param = new BaiqiAddressEntity();
            param.setUserId(dto.getUserId());
            List entities = this.baiqiAddressMapper.findByParam(param);
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                this.baiqiAddressMapper.setDefault(((BaiqiAddressEntity)entities.get(0)).getId());
            }
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional(value="QIHO")
    public Boolean alterDefault(AddressDto dto) {
        this.baiqiAddressMapper.cancelDefault(dto.getUserId());
        this.baiqiAddressMapper.setDefault(dto.getId());
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateAddress(AddressDto dto) {
        if (dto.getDefaulted().booleanValue()) {
            this.baiqiAddressMapper.cancelDefault(dto.getUserId());
        }
        this.baiqiAddressMapper.updateAddress((BaiqiAddressEntity)BeanUtils.copy((Object)dto, BaiqiAddressEntity.class));
        return Boolean.TRUE;
    }

    @Override
    public AddressDto findById(Long addressId) {
        return (AddressDto)BeanUtils.copy((Object)this.baiqiAddressMapper.findById(addressId), AddressDto.class);
    }
}

