/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.blacklist;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BaiqiBlackListDto;
import com.qiho.center.api.enums.DealTypeEnum;
import com.qiho.center.api.enums.blacklist.BaiqiBlackListTypeEnum;
import com.qiho.center.api.enums.blacklist.BlackListUseTypeEnum;
import com.qiho.center.api.enums.blacklist.SourceTypeEnum;
import com.qiho.center.api.params.blacklist.BaiqiBlackListQueryParam;
import com.qiho.center.api.params.blacklist.BlackListBatchDealParam;
import com.qiho.center.biz.runnable.BaiqiBlackListRunnable;
import com.qiho.center.biz.service.blacklist.BaiqiBlackListService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.daoh.qiho.blacklist.BaiqiBlackListMapper;
import com.qiho.center.common.entityd.qiho.blacklist.BaiqiBlackListEntity;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class BaiqiBlackListServiceImpl
implements BaiqiBlackListService,
ApplicationContextAware {
    @Autowired
    private BaiqiBlackListMapper baiqiBlackListMapper;
    @Autowired
    private MerchantService merchantService;
    @Resource
    private ExecutorService executorService;
    private ApplicationContext context;

    @Override
    public PagenationDto<BaiqiBlackListDto> queryPage(BaiqiBlackListQueryParam param) {
        Integer count;
        PagenationDto page = new PagenationDto();
        if (param.getMerchantId() < 0L) {
            param.setMerchantId(null);
        }
        if ((count = Integer.valueOf(this.baiqiBlackListMapper.countQueryPage(param))) == 0) {
            return page.emptyPage();
        }
        List blackListEntities = this.baiqiBlackListMapper.queryPage(param);
        page.setTotal(count);
        page.setList(this.convertToDtoList(blackListEntities));
        return page;
    }

    @Override
    public ResultDto<Boolean> deleteBlackList(Long id, String name) {
        if (id == null || id <= 0L) {
            return ResultDto.failResult((String)"id\u4e0d\u5408\u6cd5");
        }
        this.baiqiBlackListMapper.deleteBlackList(id, name);
        return ResultDto.successResult((Object)Boolean.TRUE);
    }

    @Override
    public int queryPageCount(BaiqiBlackListQueryParam param) {
        if (param.getMerchantId() == -1L) {
            param.setMerchantId(null);
        }
        return this.baiqiBlackListMapper.countQueryPage(param);
    }

    @Override
    public int batchAddBlackList(String cacheKey, List<BlackListBatchDealParam> list, Long merchantId, String operator) {
        BaiqiBlackListRunnable runnable = (BaiqiBlackListRunnable)this.context.getBean(BaiqiBlackListRunnable.class);
        runnable.setProgressKey(cacheKey);
        runnable.setParams(list);
        runnable.setMerchantId(merchantId);
        runnable.setOperator(operator);
        int useAbleCount = runnable.enableFilter();
        this.executorService.submit(runnable);
        return useAbleCount;
    }

    private List<BaiqiBlackListDto> convertToDtoList(List<BaiqiBlackListEntity> blackListEntities) {
        Map<Long, String> merchantMap = this.merchantService.fetchNamesWithCache();
        return Lists.transform(blackListEntities, e -> {
            BaiqiBlackListDto dto = (BaiqiBlackListDto)BeanUtils.copy((Object)e, BaiqiBlackListDto.class);
            dto.setBkType(BaiqiBlackListTypeEnum.getByNum((int)e.getBkType()));
            dto.setDealType(DealTypeEnum.getByNum((int)e.getDealType()));
            dto.setSourceType(SourceTypeEnum.getByNum((int)e.getSourceType()));
            if (e.getUseType().intValue() == BlackListUseTypeEnum.PART.getNum()) {
                dto.setMerchantName((String)merchantMap.get(e.getMerchantId()));
            } else {
                dto.setMerchantName(BlackListUseTypeEnum.ALL.getDesc());
            }
            return dto;
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

